/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import misc.FileManager;

public class getSwapExpId {
    public static void main(String[] args) {
        File inFn = new File(args[0]);
        File outFn = new File(args[1]);
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            getSwapExpId.getExperimentIds(srcDB, inFn, outFn);
            getSwapExpId.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void getExperimentIds(Connection srcDB, File inFn, File outFn) throws SQLException {
        String[] lines;
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines = FileManager.readTextFile(inFn).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf("ReAssociatePlates experiment one id") > 0) {
                builder.append(line.substring(0, 20)).append("\t");
                builder.append("Swap").append("\t");
                String id1 = line.split(":")[3].trim().split("\\s+")[0];
                String id2 = line.split(":")[4].trim();
                builder.append(getSwapExpId.getPlateName(id1, srcDB)).append("\t");
                builder.append(getSwapExpId.getPlateName(id2, srcDB)).append("\n");
            } else if (line.indexOf("Preparing to swap chromat coordinates") > 0) {
                builder.append(line.substring(0, 20)).append("\t");
                builder.append("Rotate").append("\t");
                String[] ids = line.split("\\s+");
                builder.append(getSwapExpId.getPlateName(ids[ids.length - 1], srcDB)).append("\n");
            }
            ++n2;
        }
        FileManager.writeTextFile(outFn, builder.toString(), true);
    }

    private static String getPlateName(String id, Connection srcDB) throws SQLException {
        System.out.println(id);
        String selectSql = "select plate_name from pcr.experiment where experiment_id =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, id);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

