/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import misc.FileManager;

public class getCellLineIds {
    public static void main(String[] args) {
        File inFn = new File(args[0]);
        File outFn = new File(args[1]);
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            getCellLineIds.startQuery(inFn, outFn, srcDB);
            getCellLineIds.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void startQuery(File inFn, File outFn, Connection srcDB) {
        String[] info = FileManager.readTextFile(inFn).split("\n");
        String id = null;
        StringBuilder builder = new StringBuilder();
        String[] stringArray = info;
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            id = getCellLineIds.queryId(name, srcDB);
            builder.append(name.trim()).append(",").append(id).append("\n");
            ++n2;
        }
        FileManager.writeTextFile(outFn, builder.toString(), true);
    }

    private static String queryId(String name, Connection srcDB) {
        String selectSql = "select * from core.cell_line where local_name =?";
        PreparedStatement preparedStatement = null;
        String id = null;
        try {
            preparedStatement = srcDB.prepareStatement(selectSql);
            preparedStatement.setString(1, name.trim());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                id = resultSet.getString(1);
                if (resultSet.next()) {
                    System.out.println("more than 1 " + name);
                }
            } else {
                System.out.println("no record " + name);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

