/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class ToFastq {
    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File qualityFile = new File(args[1]);
        File fastqFile = new File(args[2]);
        Map<String, String> sequences = ToFastq.getSequences(fastaFile);
        Map<String, String> qualities = ToFastq.getSequences(qualityFile);
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append("@").append(name).append("\n");
            builder.append(sequences.get(name)).append("\n");
            builder.append("+").append("\n");
            builder.append(qualities.get(name)).append("\n");
        }
        FileManager.writeTextFile(fastqFile, builder.toString(), true);
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                ++i;
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

