/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;

public class RenameRunFolder {
    static String GNAME = "DRB1-Combined";
    static String OLD_F_PRIMER = "DRB1-F";
    static String NEW_F_PRIMER = "DRB1-combineF";
    static String OLD_R_PRIMER = "DRB1-R";
    static String NEW_R_PRIMER = "DRB1-combineR";

    public static void main(String[] args) {
        File srcfolder = new File(args[0]);
        File destfolder = new File(args[1]);
        File sampleSheet = new File(args[2]);
        File fakeChromat = new File(args[3]);
        if (!destfolder.exists() || !destfolder.isDirectory()) {
            destfolder.mkdirs();
        }
        HashMap<String, String> ampliconMap = new HashMap<String, String>();
        ampliconMap.put("HLA-A", "HLA-A");
        ampliconMap.put("HLA-B", "HLA-B-Single");
        ampliconMap.put("HLA-C", "HLAC");
        ampliconMap.put("HLA-DRB1-Combine", "DRB1-Combined");
        ampliconMap.put("HLA-DRB1-15", "DRB1-15");
        ampliconMap.put("HLA-DRB1-03", "DRB1-03");
        ampliconMap.put("HLA-DRB1-13", "DRB1-13");
        ampliconMap.put("HLA-DRB1-05", "DRB1-05");
        ampliconMap.put("HLA-DPA1", "DPA-M");
        ampliconMap.put("HLA-DPB1", "DPB-M");
        ampliconMap.put("HLA-DQB1-A", "HLA-DQB1-A");
        ampliconMap.put("HLA-DQB1-B", "HLA-DQB1-B");
        ampliconMap.put("HLA-DQB1", "HLA-DQB1-A");
        HashMap<String, Map<String, String>> ampliconPrimerMap = new HashMap<String, Map<String, String>>();
        ampliconPrimerMap.put("HLA-A", new HashMap());
        ampliconPrimerMap.put("HLA-B", new HashMap());
        ampliconPrimerMap.put("HLA-C", new HashMap());
        ampliconPrimerMap.put("HLA-DRB1-Combine", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DRB1-Combine")).put("DRB1-combineF", "DRB1-F");
        ((Map)ampliconPrimerMap.get("HLA-DRB1-Combine")).put("DRB1-combineR", "DRB1-R");
        ampliconPrimerMap.put("HLA-DRB1-15", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DRB1-15")).put("DRB1-combineF", "DRB1-015F");
        ((Map)ampliconPrimerMap.get("HLA-DRB1-15")).put("DRB1-combineR", "DRB1-002R");
        ampliconPrimerMap.put("HLA-DRB1-03", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DRB1-03")).put("DRB1-combineF", "DRB1-003F");
        ((Map)ampliconPrimerMap.get("HLA-DRB1-03")).put("DRB1-combineR", "DRB1-002R");
        ampliconPrimerMap.put("HLA-DRB1-13", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DRB1-13")).put("DRB1-combineF", "DRB1-013F");
        ((Map)ampliconPrimerMap.get("HLA-DRB1-13")).put("DRB1-combineR", "DRB1-005R");
        ampliconPrimerMap.put("HLA-DRB1-05", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DRB1-05")).put("DRB1-combineF", "DRB1-005F");
        ((Map)ampliconPrimerMap.get("HLA-DRB1-05")).put("DRB1-combineR", "DRB1-003R");
        ampliconPrimerMap.put("HLA-DPA1", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DPA1")).put("M13F", "DPA1.l1.5.6Mf");
        ((Map)ampliconPrimerMap.get("HLA-DPA1")).put("M13R", "DPA1.l.2.3.6Mr");
        ampliconPrimerMap.put("HLA-DPB1", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DPB1")).put("M13F", "DPB5.2Mf");
        ((Map)ampliconPrimerMap.get("HLA-DPB1")).put("M13R", "DPB3.4Mr");
        ampliconPrimerMap.put("HLA-DQB1-A", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DQB1-A")).put("M13F", "M13F");
        ((Map)ampliconPrimerMap.get("HLA-DQB1-A")).put("M13R", "M13R");
        ampliconPrimerMap.put("HLA-DQB1-B", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DQB1-B")).put("M13F", "M13F");
        ((Map)ampliconPrimerMap.get("HLA-DQB1-B")).put("M13R", "M13R");
        ampliconPrimerMap.put("HLA-DQB1", new HashMap());
        ((Map)ampliconPrimerMap.get("HLA-DQB1")).put("M13F", "M13F");
        ((Map)ampliconPrimerMap.get("HLA-DQB1")).put("M13R", "M13R");
        RenameRunFolder.rename(srcfolder, destfolder, sampleSheet, fakeChromat, ampliconMap, ampliconPrimerMap);
    }

    public static void rename(File srcfolder, File destfolder, File sampleSheet, File fakeChromat, Map<String, String> ampliconMap, Map<String, Map<String, String>> ampliconPrimerMap) {
        String[] info = FileManager.readTextFile(sampleSheet).split("\n");
        File[] chromats = srcfolder.listFiles();
        HashMap<String, String> coordNames = new HashMap<String, String>();
        int i = 3;
        while (i < info.length) {
            String[] items = info[i].trim().split("\\s+");
            String coord = items[0].trim();
            String ssId = items[1].trim();
            if (ssId.trim().length() == 0 || ssId.trim().equals("Empty")) {
                coordNames.put("FAKE" + coord, String.valueOf(coord) + ".ab1");
            } else {
                String newName = String.valueOf(ssId) + "_" + coord + ".ab1";
                if (ssId.startsWith("___")) {
                    coordNames.put("FAKE" + ssId, newName);
                } else {
                    String[] fields = ssId.split("_");
                    String amplicon = ampliconMap.get(fields[1].trim());
                    System.out.println(String.valueOf(amplicon) + " " + ssId);
                    String primer = ampliconPrimerMap.get(fields[1].trim()).get(fields[2].trim());
                    if (primer == null) {
                        primer = fields[2].trim();
                    }
                    coordNames.put(String.valueOf(amplicon) + "_" + fields[0] + "_" + primer, newName);
                }
            }
            ++i;
        }
        for (String oldName : coordNames.keySet()) {
            boolean isFound = false;
            File[] fileArray = chromats;
            int n = chromats.length;
            int n2 = 0;
            while (n2 < n) {
                File chromat = fileArray[n2];
                String fName = chromat.getName();
                if (fName.startsWith(oldName)) {
                    System.out.println(String.valueOf(fName) + " -> " + (String)coordNames.get(oldName));
                    File newFile = new File(destfolder, (String)coordNames.get(oldName));
                    chromat.renameTo(newFile);
                    isFound = true;
                    break;
                }
                ++n2;
            }
            if (isFound) continue;
            System.out.println(" fake " + (String)coordNames.get(oldName));
            File newFile = new File(destfolder, (String)coordNames.get(oldName));
            FileManager.copyFile(fakeChromat, newFile, true);
        }
    }

    private static String mapPrimer(String primer) {
        if (primer.equals(NEW_F_PRIMER)) {
            return OLD_F_PRIMER;
        }
        if (primer.equals(NEW_R_PRIMER)) {
            return OLD_R_PRIMER;
        }
        return null;
    }
}

