/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import dataFix.ChromatVO;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RenameCelllineByCoord {
    public static void main(String[] args) {
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            RenameCelllineByCoord.renameCellLine(srcDB);
            RenameCelllineByCoord.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void renameCellLine(Connection srcDB) {
        String selectSql = "select chromat_id, cell_line_name from pcr.chromat_report_mv where coordinate = ? and project_name='UCLA-48Panel-022708'";
        PreparedStatement preparedStatement = null;
        String coord = null;
        String col = null;
        String row = "ABCDEFGH";
        try {
            int i = 0;
            while (i < row.length()) {
                int j = 6;
                while (j <= 12) {
                    col = j < 10 ? (col = "0" + j) : String.valueOf(j);
                    coord = String.valueOf(row.charAt(i)) + col;
                    preparedStatement = srcDB.prepareStatement(selectSql);
                    preparedStatement.setString(1, coord);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    ArrayList<ChromatVO> chromats = new ArrayList<ChromatVO>();
                    ChromatVO chromatVO = null;
                    while (resultSet.next()) {
                        chromatVO = new ChromatVO();
                        chromatVO.setId(resultSet.getString(1));
                        chromatVO.setCellLineName(resultSet.getString(2));
                        chromats.add(chromatVO);
                    }
                    System.out.println(String.valueOf(coord) + " " + chromats.size());
                    RenameCelllineByCoord.updateName(chromats, srcDB);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getClId(String name, Connection srcDB) throws SQLException {
        String selectSql = "select cell_line_id from core.cell_line where local_name =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, name);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    private static void updateName(List<ChromatVO> chromats, Connection srcDB) throws SQLException {
        String updateSql = "update pcr.chromat_report_mv set cell_line_id=? where chromat_id =?";
        PreparedStatement preparedStatement = null;
        String newClId = null;
        for (ChromatVO chromatVO : chromats) {
            if (!chromatVO.getCellLineName().endsWith("-1")) continue;
            preparedStatement = srcDB.prepareStatement(updateSql);
            newClId = RenameCelllineByCoord.getClId(chromatVO.getCellLineName(), srcDB);
            if (newClId == null) {
                System.out.println(chromatVO.getCellLineName());
            }
            preparedStatement.setString(1, newClId);
            preparedStatement.setString(2, chromatVO.getId());
            preparedStatement.executeUpdate();
        }
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

