/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class MergeSnpFiles {
    public static void main(String[] args) {
        File inDir = new File(args[0]);
        File inList = new File(args[1]);
        File upn = new File(args[2]);
        File outfile = new File(args[3]);
        String[] list = FileManager.readTextFile(inList).split("\n");
        Map<String, String> upnMap = MergeSnpFiles.makeUPN(upn);
        LinkedHashMap<String, Map<String, String>> snpMap = new LinkedHashMap<String, Map<String, String>>();
        HashMap<String, String> mafMap = new HashMap<String, String>();
        HashMap<String, String> majorMap = new HashMap<String, String>();
        File snpFile = null;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String fn = stringArray[n2];
            snpFile = new File(inDir, fn.trim());
            System.out.println(snpFile.getAbsolutePath());
            MergeSnpFiles.loadSnpData(snpFile, snpMap, mafMap, majorMap);
            ++n2;
        }
        MergeSnpFiles.writeOutput(outfile, upnMap, snpMap, mafMap, majorMap);
    }

    private static void writeOutput(File outfile, Map<String, String> upnMap, Map<String, Map<String, String>> snpMap, Map<String, String> mafMap, Map<String, String> majorMap) {
        StringBuilder headbuilder = new StringBuilder();
        headbuilder.append("HIP").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t");
        for (String hip : upnMap.keySet()) {
            headbuilder.append(hip).append("\t");
        }
        headbuilder.append("\n");
        headbuilder.append("UPN").append("\t").append("\t").append("\t").append("\t").append("\t").append("\t");
        for (String hip : upnMap.values()) {
            headbuilder.append(hip).append("\t");
        }
        headbuilder.append("\n");
        headbuilder.append("group#").append("\n");
        headbuilder.append("backbone").append("\t").append("localSNPname").append("\t").append("description").append("\t").append("rs#").append("\t").append("MAF").append("\t").append("major").append("\n");
        Map<String, String> genotypes = null;
        System.out.println(String.valueOf(snpMap.size()) + "--------------");
        for (String pos : snpMap.keySet()) {
            headbuilder.append(pos.split("-")[2]).append("\t").append(pos).append("\t").append("\t").append("rs0").append("\t").append(mafMap.get(pos)).append("\t").append(majorMap.get(pos)).append("\t");
            genotypes = snpMap.get(pos);
            for (String hip : upnMap.keySet()) {
                headbuilder.append(genotypes.get(hip)).append("\t");
            }
            headbuilder.append("\n");
        }
        FileManager.writeTextFile(outfile, headbuilder.toString(), true);
    }

    private static void loadSnpData(File snpFile, Map<String, Map<String, String>> snpMap, Map<String, String> mafMap, Map<String, String> majorMap) {
        String[] lines = FileManager.readTextFile(snpFile).split("\n");
        String[] positions = lines[1].trim().split(",");
        int col = 1;
        while (col < positions.length) {
            if (positions[col].trim().startsWith("Snp Position")) {
                String pos = MergeSnpFiles.formatPos(positions[col], snpFile.getName());
                HashMap<String, String> genotypes = new HashMap<String, String>();
                int i = 5;
                while (i < lines.length) {
                    String[] items = lines[i].trim().split(",");
                    String hip = items[0].trim();
                    if (!hip.startsWith("HIP")) {
                        System.out.println("skip " + hip);
                    } else {
                        String call = MergeSnpFiles.formatCall(items[col].trim());
                        genotypes.put(hip, call);
                    }
                    ++i;
                }
                snpMap.put(pos, genotypes);
                mafMap.put(pos, MergeSnpFiles.getMaf(genotypes));
                majorMap.put(pos, MergeSnpFiles.getMajor(genotypes));
            }
            ++col;
        }
    }

    private static String getMaf(Map<String, String> genotypes) {
        Map<String, Integer> callMap = MergeSnpFiles.getCallMap(genotypes);
        if (callMap.size() != 2) {
            System.out.println("wrong size " + callMap.size());
        }
        int num1 = 0;
        int num2 = 0;
        for (String read : callMap.keySet()) {
            int count = callMap.get(read);
            if (num1 == 0) {
                num1 = count;
                continue;
            }
            if (num2 != 0) continue;
            num2 = count;
        }
        if (num2 > num1) {
            return String.valueOf(num1) + "/" + (num2 + num1);
        }
        return String.valueOf(num2) + "/" + (num2 + num1);
    }

    private static String getMajor(Map<String, String> genotypes) {
        Map<String, Integer> callMap = MergeSnpFiles.getCallMap(genotypes);
        int max = 0;
        String major = null;
        for (String read : callMap.keySet()) {
            int count = callMap.get(read);
            if (count <= max || read.equals("N")) continue;
            max = count;
            major = read;
        }
        return major;
    }

    private static Map<String, Integer> getCallMap(Map<String, String> genotypes) {
        HashMap<String, Integer> callMap = new HashMap<String, Integer>();
        for (String call : genotypes.values()) {
            if (call.equals("NN")) continue;
            MergeSnpFiles.addToMap(callMap, String.valueOf(call.charAt(0)));
            MergeSnpFiles.addToMap(callMap, String.valueOf(call.charAt(1)));
        }
        return callMap;
    }

    private static void addToMap(Map<String, Integer> callMap, String call) {
        if (!callMap.containsKey(String.valueOf(call))) {
            callMap.put(call, 1);
        } else {
            callMap.put(call, callMap.get(call) + 1);
        }
    }

    private static String formatCall(String call) {
        String part = call.split("\\(")[0].trim().replace("/", "");
        if (part.indexOf("/") > 0) {
            part = String.valueOf(part.charAt(0)) + part.charAt(2);
        }
        if (part.length() == 1) {
            part = String.valueOf(part) + part;
        }
        if (part.length() != 2) {
            System.out.println("check call " + call + " " + part);
        }
        return part.toUpperCase();
    }

    private static String formatPos(String field, String fileName) {
        String position = field.split(":")[1].trim();
        String prefix = fileName.split("\\.")[0];
        return String.valueOf(prefix) + "-" + position;
    }

    private static Map<String, String> makeUPN(File upnFile) {
        String[] upns = FileManager.readTextFile(upnFile).split("\n");
        LinkedHashMap<String, String> upnMap = new LinkedHashMap<String, String>();
        String[] stringArray = upns;
        int n = upns.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] item = line.trim().split("\t");
            upnMap.put(item[0], item[1]);
            ++n2;
        }
        return upnMap;
    }
}

