/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import fileOperation.BatchConvertFastaQdataMiSeq;
import java.io.File;
import java.util.HashMap;
import misc.FileManager;

public class AssemblyChromats {
    public static void main(String[] args) throws Exception {
        File sourceRoot = new File(args[0]);
        File destRoot = new File(args[1]);
        AssemblyChromats.assemble(sourceRoot, destRoot);
    }

    public static void assemble(File sourceRoot, File destRoot) {
        File[] sourceDirs;
        if (!destRoot.exists() || !destRoot.isDirectory()) {
            destRoot.mkdirs();
        }
        File[] fileArray = sourceDirs = sourceRoot.listFiles();
        int n = sourceDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceDir = fileArray[n2];
            if (sourceDir.isDirectory()) {
                AssemblyChromats.parseDir(sourceDir, destRoot);
            }
            ++n2;
        }
        AssemblyChromats.runPhredPhrap(destRoot);
    }

    private static void runPhredPhrap(File destRoot) {
        File[] dirs;
        File[] fileArray = dirs = destRoot.listFiles();
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory()) {
                File assemblydir = new File(dir, "assembly");
                BatchConvertFastaQdataMiSeq.runCmd("/genome/bin/phredPhrap ", assemblydir);
            }
            ++n2;
        }
    }

    private static void parseDir(File sourceDir, File destRoot) {
        File[] files = sourceDir.listFiles();
        System.out.println(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("ab1")) {
                AssemblyChromats.parseFile(destRoot, file);
            }
            ++n2;
        }
    }

    public static void parseFile(File destRoot, File chrFile) {
        String[] name = chrFile.getName().split("_");
        String amp = name[0];
        File destDir = new File(destRoot, amp);
        File chrdir = new File(destDir, "chromat_dir");
        File phddir = new File(destDir, "phd_dir");
        File assemblydir = new File(destDir, "assembly");
        if (!destDir.exists() || !destDir.isDirectory()) {
            destDir.mkdirs();
            chrdir.mkdir();
            phddir.mkdir();
            assemblydir.mkdir();
        }
        String cl = name[1];
        String primer = name[2];
        String newName = String.valueOf(cl) + "_" + primer;
        File destfn = new File(chrdir, newName);
        FileManager.copyFile(chrFile, destfn, true);
        System.out.println(String.valueOf(chrFile.getAbsolutePath()) + " -> " + destfn.getAbsolutePath());
    }

    private static void getFastas(File fastaFile, File fastaRoot) {
        HashMap backboneMap = new HashMap();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        String name = null;
        String sequence = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            if (data.startsWith(">")) {
                String fullName;
                if (sequence == null) {
                    fullName = data.substring(1).trim();
                    name = String.valueOf(fullName.split("_")[0]) + "_" + fullName.split("_")[1];
                    sequence = ">" + name + "\n";
                } else {
                    FileManager.writeTextFile(new File(fastaRoot, name), sequence, true);
                    System.out.println(String.valueOf(data) + " " + name);
                    fullName = data.substring(1).trim();
                    name = String.valueOf(fullName.split("_")[0]) + "_" + fullName.split("_")[1];
                    sequence = ">" + name + "\n";
                }
            } else if (data.trim().length() > 0) {
                sequence = String.valueOf(sequence) + data.trim();
            }
            FileManager.writeTextFile(new File(fastaRoot, name), sequence, true);
            ++n2;
        }
    }
}

