/*
 * Decompiled with CFR 0.152.
 */
package dataFix;

import dataFix.ChromatVO;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import misc.FileManager;

public class AddAmpliconSeq {
    public static void main(String[] args) {
        File inFn = new File(args[0]);
        String destDBurl = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection srcDB = DriverManager.getConnection(destDBurl, "gems", "Caff1ne");
            AddAmpliconSeq.addSequence(srcDB, inFn);
            AddAmpliconSeq.closeResources(null, null, srcDB);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void addSequence(Connection srcDB, File inFn) {
        String selectSql = "select amplicon_id from pcr.amplicon where name=?";
        String updateSql = "update pcr.chromat_report_mv set amplicon_name=?, amplicon_id=? where project_name= ? and amplicon_name=?";
        String[] info = FileManager.readTextFile(inFn).split("\n");
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        try {
            int i = 1;
            while (i < info.length) {
                String current = info[i].trim().split("\t")[0].trim();
                String previous = info[i].trim().split("\t")[1].trim();
                preparedStatement = srcDB.prepareStatement(selectSql);
                preparedStatement.setString(1, current);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    System.out.println(previous);
                    String id = resultSet.getString(1);
                    preparedStatement2 = srcDB.prepareStatement(updateSql);
                    preparedStatement2.setString(1, current);
                    preparedStatement2.setString(2, id);
                    preparedStatement2.setString(3, "CYNO-MHC-ProbeSequencing-2");
                    preparedStatement2.setString(4, previous);
                    preparedStatement2.executeUpdate();
                } else {
                    System.out.println(String.valueOf(previous) + " ??????????????? ");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getClId(String name, Connection srcDB) throws SQLException {
        String selectSql = "select cell_line_id from core.cell_line where local_name =?";
        PreparedStatement preparedStatement = srcDB.prepareStatement(selectSql);
        preparedStatement.setString(1, name);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            return resultSet.getString(1);
        }
        return null;
    }

    private static void updateName(List<ChromatVO> chromats, Connection srcDB) throws SQLException {
        String updateSql = "update pcr.chromat_report_mv set cell_line_id=? where chromat_id =?";
        PreparedStatement preparedStatement = null;
        String newClId = null;
        for (ChromatVO chromatVO : chromats) {
            if (!chromatVO.getCellLineName().endsWith("-1")) continue;
            preparedStatement = srcDB.prepareStatement(updateSql);
            newClId = AddAmpliconSeq.getClId(chromatVO.getCellLineName(), srcDB);
            if (newClId == null) {
                System.out.println(chromatVO.getCellLineName());
            }
            preparedStatement.setString(1, newClId);
            preparedStatement.setString(2, chromatVO.getId());
            preparedStatement.executeUpdate();
        }
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

