/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpdateAmpliconSequence {
    public static String UPDATE_AMPLICON = "update pcr.amplicon set sequence=?,masked_sequence=? WHERE name = ?";

    public static void main(String[] args) {
        File assoFile = new File(args[0]);
        File backboneDir = new File(args[1]);
        String[] assoData = FileManager.readTextFile(assoFile).split("\n");
        String[] info = null;
        String amplicon = null;
        String sequence = null;
        int i = 1;
        while (i < assoData.length) {
            info = assoData[i].split(",");
            amplicon = info[0].trim();
            String fprimer = info[5].trim();
            String rprimer = info[7].trim();
            String backbone = UpdateAmpliconSequence.getBackboneSeq(info[4].trim().substring(0, 5), backboneDir);
            int start = backbone.indexOf(fprimer);
            int end = backbone.indexOf(StringUtils.revCompSeq(rprimer)) + rprimer.length() + 1;
            sequence = backbone.substring(start, end);
            System.out.println(sequence);
            UpdateAmpliconSequence.excuteUpdate(amplicon, sequence);
            ++i;
        }
        System.out.println("done");
    }

    private static String getBackboneSeq(String name, File backboneDir) {
        File[] files;
        File[] fileArray = files = backboneDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().indexOf(name) == 0) {
                System.out.println(String.valueOf(name) + " : " + file.getName());
                return UpdateAmpliconSequence.getSequenceFromFasta(file);
            }
            ++n2;
        }
        return null;
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString().toUpperCase();
    }

    private static void excuteUpdate(String ampName, String sequence) {
        String url = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        ResultSet resultSet = null;
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            PreparedStatement preparedStatement = null;
            preparedStatement = db.prepareStatement(UPDATE_AMPLICON);
            preparedStatement.setString(1, sequence);
            preparedStatement.setString(2, sequence);
            preparedStatement.setString(3, ampName);
            preparedStatement.executeUpdate();
            UpdateAmpliconSequence.closeResources(resultSet, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    private static void excuteUpdate(String sql, String mainPlate, String mainCoord, String newPlate, String newCoord) {
        String url = "jdbc:postgresql://asclepius.fhcrc.org:5432/gemsprod";
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            PreparedStatement preparedStatement = db.prepareStatement(sql);
            preparedStatement.setString(1, mainPlate);
            preparedStatement.setString(2, mainCoord);
            preparedStatement.setString(3, newPlate);
            preparedStatement.setString(4, newCoord);
            preparedStatement.executeUpdate();
            UpdateAmpliconSequence.closeResources(null, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }
}

