/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TranslatePhd {
    public static String PHD_FILE_SUFFIX = ".phd.1";
    public static int TRIM_MIN_SEQ_LEN = 20;
    private String phdDir;
    private String outputDir;
    private SnpConfig config;
    private LogUtil phredLog;
    private FileHandler handler;
    private Map seqMap;
    private Map qualMap;
    private Map trimedSeqMap;
    private Map trimedQualMap;

    public TranslatePhd(String chrDir, String outDir, SnpConfig conf) {
        this.phdDir = FileHelper.phdDir(chrDir);
        this.outputDir = outDir;
        this.config = conf;
        this.phredLog = new LogUtil(FileHelper.PHRED_LOG);
        this.handler = new FileHandler();
        this.seqMap = new LinkedHashMap();
        this.qualMap = new LinkedHashMap();
        this.trimedSeqMap = new LinkedHashMap();
        this.trimedQualMap = new LinkedHashMap();
    }

    public void translate() throws IOException {
        System.out.println("\ttranslate Phds...");
        this.phredLog.enter("<Script TranslatePhd>\n");
        String snpDataDir = FileHelper.snpDataDir(this.outputDir, this.phdDir);
        String polyDir = FileHelper.polyDir(this.outputDir, this.phdDir, this.config);
        String fastaFile = FileHelper.fastaFile(snpDataDir);
        String qualFile = FileHelper.qualFile(snpDataDir);
        String fastaTrimFile = FileHelper.fastaTrimFile(snpDataDir);
        String qualTrimFile = FileHelper.qualTrimFile(snpDataDir);
        this.getSeqQual();
        this.writeFastaFile(this.seqMap, fastaFile);
        this.writeFastaFile(this.qualMap, qualFile);
        this.writeFastaFile(this.trimedSeqMap, fastaTrimFile);
        this.writeFastaFile(this.trimedQualMap, qualTrimFile);
        this.phredLog.exit("</Script TranslatePhd>\n");
        this.phredLog.write(snpDataDir);
    }

    public void getSeqQual() throws IOException {
        List phdFns = this.listPhdFile(this.phdDir, true);
        System.out.println(String.valueOf(this.phdDir) + ":" + phdFns.size());
        for (String fn : phdFns) {
            String chrName = new File(fn).getName().split(PHD_FILE_SUFFIX)[0];
            List data = this.handler.readFile(fn);
            int[] pos = this.getDataStartEnd(data);
            int[] tpos = this.populateSeqQualMap(data, pos[0], pos[1], chrName);
            this.populateTrimedSeqQualMap(data, tpos[0], tpos[1], chrName);
            this.phredLog.add(String.valueOf(chrName) + "\n");
        }
    }

    public void populateTrimedSeqQualMap(List data, int start, int end, String chrName) {
        String seq = "";
        String quals = "";
        int i = start;
        while (i < end) {
            String line = ((String)data.get(i)).trim();
            String base = line.split("\\s+")[0];
            String qual = line.split("\\s+")[1];
            seq = String.valueOf(seq) + base;
            quals = String.valueOf(quals) + qual + " ";
            ++i;
        }
        this.trimedSeqMap.put(chrName, seq);
        this.trimedQualMap.put(chrName, quals.trim());
    }

    public int[] populateSeqQualMap(List data, int start, int end, String chrName) {
        String seq = "";
        String quals = "";
        int tStart = 0;
        int tEnd = 0;
        int tbg = 0;
        double probScore = 0.0;
        double maxScore = 0.0;
        double qualScore = 0.0;
        double maxQualScore = 0.0;
        int i = start;
        while (i < end) {
            String line = ((String)data.get(i)).trim();
            String base = line.split("\\s+")[0];
            String qual = line.split("\\s+")[1];
            seq = String.valueOf(seq) + base;
            quals = String.valueOf(quals) + qual + " ";
            probScore += this.config.getTrimCutoff() - Math.pow(10.0, -new Double(qual).doubleValue() / 10.0);
            qualScore += new Double(qual).doubleValue();
            if (probScore >= maxScore) {
                tStart = tbg;
                tEnd = i;
                maxScore = probScore;
                maxQualScore = qualScore;
            }
            if (probScore < 0.0) {
                probScore = 0.0;
                qualScore = 0.0;
                tbg = i + 1;
            }
            ++i;
        }
        if (++tEnd >= end) {
            tEnd = end - 1;
        }
        if (tEnd - tStart + 1 < TRIM_MIN_SEQ_LEN) {
            tStart = 0;
            tEnd = 0;
        }
        this.seqMap.put(chrName, seq);
        this.qualMap.put(chrName, quals.trim());
        int[] ret = new int[]{tStart, tEnd};
        return ret;
    }

    public int[] getDataStartEnd(List data) {
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < data.size()) {
            String line = ((String)data.get(i)).trim();
            if (line.indexOf("BEGIN_DNA") > -1) {
                start = i + 1;
            } else if (line.indexOf("END_DNA") > -1) {
                end = i;
                break;
            }
            ++i;
        }
        int[] ret = new int[]{start, end};
        return ret;
    }

    public List listPhdFile(String thePath, boolean absPath) {
        ArrayList<String> newList = new ArrayList<String>();
        File theDir = new File(thePath);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(PHD_FILE_SUFFIX);
            }
        };
        File[] files = theDir.listFiles(fileFilter);
        int i = 0;
        while (i < files.length) {
            newList.add(absPath ? files[i].getAbsolutePath() : files[i].getName());
            ++i;
        }
        return newList;
    }

    public void writeFastaFile(Map dataMap, String fn) throws IOException {
        Iterator it = dataMap.keySet().iterator();
        ArrayList<String> data = new ArrayList<String>();
        while (it.hasNext()) {
            String chrName = (String)it.next();
            data.add(">" + chrName + "\n");
            data.add(String.valueOf((String)dataMap.get(chrName)) + "\n");
        }
        System.out.println(String.valueOf(fn) + " " + data.size());
        this.handler.writeFile(fn, data);
    }
}

