/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SnpFinalOutput {
    private String chromatDir;
    private String backbone;
    private String outputDir;
    private SnpConfig config;
    private LogUtil log;
    private FileHandler handler;
    private String backboneSeq;
    private SnpConfig snpConfig;
    private String snpDataDir;
    private String FinalFile;
    private List optimizedData;
    private String optimizedFile;
    private List posList;
    private List flanking5List;
    private List flanking3List;
    private Map callDic;

    public SnpFinalOutput(String chrDir, String fn, String outDir, SnpConfig conf, LogUtil mainLog) {
        this.chromatDir = chrDir;
        this.backbone = fn;
        this.outputDir = outDir;
        this.config = conf;
        this.log = mainLog;
        this.handler = new FileHandler();
        this.snpConfig = new SnpConfig();
        this.posList = new ArrayList();
        this.flanking5List = new ArrayList();
        this.flanking3List = new ArrayList();
    }

    public void finalOutput() throws IOException {
        System.out.println("\tSnp Final...");
        this.snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        this.optimizedFile = FileHelper.snpOptimizedDataFile(this.snpDataDir);
        this.optimizedData = this.handler.readFile(this.optimizedFile);
        this.FinalFile = FileHelper.snpFinalDataFile(this.snpDataDir);
        this.backboneSeq = ((String)this.handler.readFile(this.backbone).get(1)).trim();
        this.getFlankingSeq();
        this.writeFinalDataFile();
    }

    public void writeFinalDataFile() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(String.valueOf((String)this.optimizedData.get(0)) + "\n");
        list.add("5_end_flanking" + this.formatFlankingLine(this.flanking5List) + "\n");
        list.add("3_end_flanking" + this.formatFlankingLine(this.flanking3List) + "\n");
        int i = 1;
        while (i < this.optimizedData.size()) {
            list.add(String.valueOf((String)this.optimizedData.get(i)) + "\n");
            ++i;
        }
        this.handler.writeFile(this.FinalFile, list);
    }

    public String formatFlankingLine(List flanks) {
        String ret = "";
        Iterator it = flanks.iterator();
        while (it.hasNext()) {
            ret = String.valueOf(ret) + "\t" + (String)it.next();
        }
        return ret;
    }

    public void getFlankingSeq() {
        String end5 = null;
        String end3 = null;
        String[] positions = ((String)this.optimizedData.get(0)).split("\t");
        int i = 1;
        while (i < positions.length) {
            int pos = this.formatPos(positions[i]);
            if (pos >= this.config.getLengthFlanking() + 1 && this.backboneSeq.length() >= pos + this.config.getLengthFlanking()) {
                end5 = this.backboneSeq.substring(pos - this.config.getLengthFlanking() - 1, pos - 1);
                end3 = this.backboneSeq.substring(pos, pos + this.config.getLengthFlanking());
            } else if (pos < this.config.getLengthFlanking() - 1) {
                end5 = this.backboneSeq.substring(0, pos - 1);
                end3 = this.backboneSeq.substring(pos, pos + this.config.getLengthFlanking());
            } else if (this.backboneSeq.length() < pos + this.config.getLengthFlanking()) {
                end5 = this.backboneSeq.substring(pos - this.config.getLengthFlanking() - 1, pos - 1);
                end3 = this.backboneSeq.substring(pos);
            }
            this.flanking5List.add(end5);
            this.flanking3List.add(end3);
            ++i;
        }
    }

    public Integer formatPos(String pos) {
        if (pos.indexOf(42) > -1) {
            return new Integer(pos.split("\\*+")[1]);
        }
        return new Integer(pos);
    }
}

