/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class ParseFile {
    private static final String UTF_8 = "UTF-8";
    private static final String SEPARATOR = "\t";
    private static final String CUSIP_LINE_END = "USD";
    private static final String HEADER1_1 = "Cusip";
    private static final String HEADER1_2 = "No_payments";
    private static final String HEADER1_3 = "Int_rate";
    private static final String HEADER1_4 = "Mat_date";
    private static final String HEADER1_5 = "Acq_date";
    private static final String HEADER1_6 = "Acq_price";
    private static final String HEADER1_7 = "Misc";
    private static final String HEADER2_1 = "cusip";
    private static final String HEADER2_2 = "Date";
    private static final String HEADER2_3 = "Par";
    private static final String HEADER2_4 = "Price";
    private static final String HEADER2_5 = "Priciple_CF";
    private static final String HEADER2_6 = "Int_CF";
    private static final String HEADER2_7 = "Int_on_Assets";
    private static final String HEADER2_8 = "MV";
    private static final String HEADER2_9 = "BV";
    private static final String HEADER2_10 = "Accrued_Int";
    private static final String HEADER2_11 = "YTM";
    private static final String HEADER2_12 = "Book_Yield";
    private static final String HEADER2_13 = "PSA%";
    private static final String HEADER2_14 = "G_L";
    private static final String HEADER2_15 = "Accrued_Int_chg";
    private static final String HEADER2_16 = "Amort";
    private static final String HEADER2_17 = "Principle_CF_MBS_ABS";
    private static final String HEADER2_18 = "Prepay_CF_MBS";
    private static final String HEADER2_19 = "CPR%";
    private static final String HEADER2_20 = "Runoff_YTM";
    private static final String HEADER2_21 = "Runoff_BY";

    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output1 = new File(args[1]);
        File output2 = new File(args[2]);
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        ParseFile.constructHeader1(builder1);
        ParseFile.constructHeader2(builder2);
        ParseFile.writeTextFile(output1, builder1.toString(), true);
        ParseFile.writeTextFile(output2, builder2.toString(), true);
        BufferedReader indexReader = new BufferedReader(new FileReader(input));
        try {
            String line;
            String cusip = null;
            ArrayList<String> thisBlockData = new ArrayList<String>();
            while ((line = indexReader.readLine()) != null) {
                if (line.trim().endsWith(CUSIP_LINE_END)) {
                    if (cusip == null) {
                        cusip = line.trim().split("\\s+")[0];
                        ParseFile.appendToCusipFile(output1, line.trim());
                        continue;
                    }
                    ParseFile.appendToDetailFile(output2, thisBlockData, cusip);
                    cusip = line.trim().split("\\s+")[0];
                    thisBlockData = new ArrayList();
                    ParseFile.appendToCusipFile(output1, line.trim());
                    continue;
                }
                if (line.trim().length() <= 0) continue;
                if (cusip == null) {
                    System.out.println("don't know cusip for " + line.trim());
                    thisBlockData.add(" \t" + line.trim());
                    continue;
                }
                thisBlockData.add(String.valueOf(cusip) + SEPARATOR + line.trim());
            }
            ParseFile.appendToDetailFile(output2, thisBlockData, cusip);
        }
        finally {
            indexReader.close();
        }
    }

    private static void appendToDetailFile(File targetFile, List<String> thisBlockData, String cusip) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        for (String line : thisBlockData) {
            writer.write(line);
            writer.write("\n");
        }
        writer.close();
    }

    private static void appendToCusipFile(File targetFile, String data) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        writer.write(data);
        writer.write("\n");
        writer.close();
    }

    private static void constructHeader1(StringBuilder builder) {
        builder.append(HEADER1_1).append(SEPARATOR);
        builder.append(HEADER1_2).append(SEPARATOR);
        builder.append(HEADER1_3).append(SEPARATOR);
        builder.append(HEADER1_4).append(SEPARATOR);
        builder.append(HEADER1_5).append(SEPARATOR);
        builder.append(HEADER1_6).append(SEPARATOR);
        builder.append(HEADER1_7).append("\n");
    }

    private static void constructHeader2(StringBuilder builder) {
        builder.append(HEADER2_1).append(SEPARATOR);
        builder.append(HEADER2_2).append(SEPARATOR);
        builder.append(HEADER2_3).append(SEPARATOR);
        builder.append(HEADER2_4).append(SEPARATOR);
        builder.append(HEADER2_5).append(SEPARATOR);
        builder.append(HEADER2_6).append(SEPARATOR);
        builder.append(HEADER2_7).append(SEPARATOR);
        builder.append(HEADER2_8).append(SEPARATOR);
        builder.append(HEADER2_9).append(SEPARATOR);
        builder.append(HEADER2_10).append(SEPARATOR);
        builder.append(HEADER2_11).append(SEPARATOR);
        builder.append(HEADER2_12).append(SEPARATOR);
        builder.append(HEADER2_13).append(SEPARATOR);
        builder.append(HEADER2_14).append(SEPARATOR);
        builder.append(HEADER2_15).append(SEPARATOR);
        builder.append(HEADER2_16).append(SEPARATOR);
        builder.append(HEADER2_17).append(SEPARATOR);
        builder.append(HEADER2_18).append(SEPARATOR);
        builder.append(HEADER2_19).append(SEPARATOR);
        builder.append(HEADER2_20).append(SEPARATOR);
        builder.append(HEADER2_21).append("\n");
    }

    private static void closeFileDestination(FileChannel fileChannel) {
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeTextFile(File dest, String srcData, boolean isOverWrite) {
        return ParseFile.writeAnyFile(dest, srcData, isOverWrite, true);
    }

    private static boolean writeAnyFile(File dest, String srcData, boolean isOverWrite, boolean isTextOnly) {
        block8: {
            if (!ParseFile.isFileReadyForWrite(dest, isOverWrite)) {
                return false;
            }
            FileChannel destFileChannel = null;
            try {
                try {
                    destFileChannel = new FileOutputStream(dest).getChannel();
                    if (srcData == null) {
                        System.out.println("srcData=null");
                        destFileChannel.write(ByteBuffer.wrap("".getBytes(UTF_8)));
                    } else {
                        destFileChannel.write(ByteBuffer.wrap(srcData.getBytes(UTF_8)));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ParseFile.closeFileDestination(destFileChannel);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                ParseFile.closeFileDestination(destFileChannel);
                throw throwable;
            }
            ParseFile.closeFileDestination(destFileChannel);
        }
        return true;
    }

    private static boolean isFileReadyForWrite(File dest, boolean isOverWrite) {
        if (dest.exists() && dest.isFile() && !isOverWrite) {
            return false;
        }
        if (!dest.getParentFile().isDirectory()) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }
}

