/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LogUtil {
    private String m_name = null;
    private int m_status = 0;
    private int m_indent = 0;
    private List m_log = null;
    private String m_tab = null;

    public LogUtil(String theName) {
        this.m_name = theName;
        this.m_status = 1;
        this.m_log = new ArrayList();
        this.m_indent = 0;
        this.m_tab = "\t";
    }

    public void reset() {
        this.m_name = null;
        this.m_status = 1;
        this.m_log = new ArrayList();
        this.m_indent = 0;
        this.m_tab = "   ";
    }

    public void append(String theStr) {
        if (this.m_status == 1) {
            this.m_log.add(theStr);
        }
    }

    public void insert(int i, String theStr) {
        if (this.m_status == 1) {
            this.m_log.add(i, theStr);
        }
    }

    public void add(String theStr) {
        String theLine = "";
        if (this.m_status == 1) {
            int i = 0;
            while (i < this.m_indent) {
                theLine = String.valueOf(theLine) + this.m_tab;
                ++i;
            }
            this.m_log.add(String.valueOf(theLine) + theStr);
        }
    }

    public void addStreamOutput(String theStr) {
        String[] data = theStr.split("\n");
        int i = 0;
        while (i < data.length) {
            this.add(String.valueOf(data[i].trim()) + "\n");
            ++i;
        }
    }

    public void add(List theList) {
        String theLine = "";
        if (this.m_status == 1) {
            int i = 0;
            while (i < this.m_indent) {
                theLine = String.valueOf(theLine) + this.m_tab;
                ++i;
            }
            i = 0;
            while (i < theList.size()) {
                this.m_log.add(String.valueOf(theLine) + (String)theList.get(i));
                ++i;
            }
        }
    }

    public void enter() {
        ++this.m_indent;
    }

    public void enter(String theStr) {
        this.add(theStr);
        ++this.m_indent;
    }

    public void exit() {
        --this.m_indent;
    }

    public void exit(String theStr) {
        --this.m_indent;
        this.add(theStr);
    }

    public String write(String path) throws IOException {
        if (this.m_name == null || this.m_name.length() == 0) {
            this.m_name = StringUtils.timeStamp();
        }
        FileHandler theHandler = new FileHandler();
        return theHandler.writeFile(this.m_name, path, this.m_log);
    }

    public String logString() {
        String theLog = "";
        int i = 0;
        while (i < this.m_log.size()) {
            theLog = String.valueOf(theLog) + (String)this.m_log.get(i);
            ++i;
        }
        return theLog;
    }

    public void incIndent(int i) {
        this.m_indent += i;
    }

    public void decIndent(int i) {
        this.m_indent -= i;
    }

    public List getLog() {
        return this.m_log;
    }

    public void setTab(String theStr) {
        this.m_tab = theStr;
    }

    public String getTab() {
        return this.m_tab;
    }

    public void setIndent(int i) {
        this.m_indent = i;
    }

    public int getIndent() {
        return this.m_indent;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String theStr) {
        this.m_name = theStr;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int i) {
        this.m_status = i;
    }
}

