/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class GetSequenceFromAlignment {
    public static void main(String[] args) throws Exception {
        File fastaAlignmentFile = new File(args[0]);
        File output = new File(args[1]);
        Map<String, String> sequenceMap = GetSequenceFromAlignment.parseAlignmentFile(fastaAlignmentFile);
        for (String name : sequenceMap.keySet()) {
            File out = new File(output, name);
            String data = ">" + name + "\n";
            String seq = sequenceMap.get(name);
            int x = seq.length() / 50;
            int i = 0;
            while (i < x) {
                data = String.valueOf(data) + seq.substring(i * 50, (i + 1) * 50);
                data = String.valueOf(data) + "\n";
                ++i;
            }
            data = String.valueOf(data) + seq.substring(x * 50);
            FileManager.writeTextFile(out, data, true);
        }
    }

    public static Map<String, String> parseAlignmentFile(File fastaAlignmentFile) {
        HashMap<String, String> sequenceMap = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaAlignmentFile).split("\n");
        String[] data = null;
        String hapType = null;
        String sequence = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().indexOf(42) != 0 && line.trim().length() != 0) {
                data = line.trim().split("\\s+");
                hapType = data[0].trim();
                System.out.println(String.valueOf(hapType) + " " + line);
                sequence = sequenceMap.containsKey(hapType) ? (String)sequenceMap.get(hapType) : "";
                sequence = String.valueOf(sequence) + data[1].trim().toUpperCase().replaceAll("-", "");
                sequenceMap.put(hapType, sequence);
            }
            ++n2;
        }
        for (String h : sequenceMap.keySet()) {
            System.out.println(String.valueOf(h) + " -" + (String)sequenceMap.get(h));
        }
        return sequenceMap;
    }
}

