/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

public class Fasta2Phd {
    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        Fasta2Phd.generateFasta(inputDir, outputDir);
        Fasta2Phd.generatePhd(outputDir);
    }

    private static void generateFasta(File inputDir, File outputDir) {
        File[] files = inputDir.listFiles();
        String geneName = null;
        String sequence = null;
        String fileName = null;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String[] lines;
            File file = fileArray[n2];
            geneName = file.getName().split("\\.")[0];
            System.out.println(geneName);
            String[] stringArray = lines = FileManager.readTextFile(file).split("\n");
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                String data = stringArray[n4];
                if (data.startsWith(">")) {
                    if (sequence == null) {
                        fileName = String.valueOf(geneName) + "_" + data.substring(1).trim();
                        sequence = ">" + fileName + "\n";
                    } else {
                        FileManager.writeTextFile(new File(new File(outputDir, "fasta"), fileName), sequence, true);
                        System.out.println(String.valueOf(data) + " " + fileName);
                        fileName = String.valueOf(geneName) + "_" + data.substring(1).trim();
                        sequence = ">" + fileName + "\n";
                    }
                } else if (data.trim().length() > 0) {
                    sequence = String.valueOf(sequence) + data.trim();
                }
                ++n4;
            }
            FileManager.writeTextFile(new File(new File(outputDir, "fasta"), fileName), sequence, true);
            fileName = null;
            sequence = null;
            ++n2;
        }
    }

    private static void generatePhd(File outputDir) {
        File[] files;
        File inDir = new File(outputDir, "fasta");
        File outDir = new File(outputDir, "phd_dir");
        File[] fileArray = files = inDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String cmd = "fasta2Phd.perl -quality 40 " + file.getAbsolutePath();
            System.out.println(cmd);
            SystemCommand systemCommand = new SystemCommand(cmd, new File(outDir, "phd_dir"), true);
            systemCommand.makeItSo();
            ++n2;
        }
    }
}

