/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class CutFasta3 {
    private static final String UTF_8 = "UTF-8";

    public static void main(String[] args) throws Exception {
        String name = args[0];
        File fasta = new File(args[1]);
        int unit = new Integer(args[2]);
        File outputDir = new File(args[3]);
        File newFile = null;
        String backbone = CutFasta3.getSequenceFromFasta(fasta);
        int numberFiles = backbone.length() / unit + 1;
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < numberFiles) {
            end = start + unit;
            newFile = new File(outputDir, String.valueOf(name) + "-" + start + "-" + end + ".fa");
            CutFasta3.cut(backbone, start, Math.min(backbone.length(), end), newFile);
            start = end;
            ++i;
        }
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = CutFasta3.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        System.out.println("Total : " + seq.toString().length());
        return seq.toString();
    }

    public static String readTextFile(File src) {
        return CutFasta3.readAnyFile(src, true);
    }

    private static String readAnyFile(File src, boolean isTextOnly) {
        String data;
        block5: {
            FileChannel srcFileChannel = null;
            ByteBuffer byteBuffer = null;
            data = null;
            try {
                try {
                    srcFileChannel = new FileInputStream(src).getChannel();
                    byteBuffer = ByteBuffer.allocate((int)srcFileChannel.size());
                    srcFileChannel.read(byteBuffer);
                    data = new String(byteBuffer.array(), UTF_8);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    CutFasta3.closeFileDestination(srcFileChannel);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                CutFasta3.closeFileDestination(srcFileChannel);
                throw throwable;
            }
            CutFasta3.closeFileDestination(srcFileChannel);
        }
        return data;
    }

    private static void closeFileDestination(FileChannel fileChannel) {
        if (fileChannel != null) {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void cut(String seq, int start, int end, File output) {
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(output.getName()).append("\n");
        builder.append(seq.substring(start, end));
        CutFasta3.writeTextFile(output, builder.toString(), true);
    }

    public static boolean writeTextFile(File dest, String srcData, boolean isOverWrite) {
        return CutFasta3.writeAnyFile(dest, srcData, isOverWrite, true);
    }

    private static boolean isFileReadyForWrite(File dest, boolean isOverWrite) {
        if (dest.exists() && dest.isFile() && !isOverWrite) {
            return false;
        }
        if (!dest.getParentFile().isDirectory()) {
            dest.getParentFile().mkdirs();
        }
        return true;
    }

    private static boolean writeAnyFile(File dest, String srcData, boolean isOverWrite, boolean isTextOnly) {
        block8: {
            if (!CutFasta3.isFileReadyForWrite(dest, isOverWrite)) {
                return false;
            }
            FileChannel destFileChannel = null;
            try {
                try {
                    destFileChannel = new FileOutputStream(dest).getChannel();
                    if (srcData == null) {
                        System.out.println("srcData=null");
                        destFileChannel.write(ByteBuffer.wrap("".getBytes(UTF_8)));
                    } else {
                        destFileChannel.write(ByteBuffer.wrap(srcData.getBytes(UTF_8)));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    CutFasta3.closeFileDestination(destFileChannel);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                CutFasta3.closeFileDestination(destFileChannel);
                throw throwable;
            }
            CutFasta3.closeFileDestination(destFileChannel);
        }
        return true;
    }
}

