/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class CutFasta {
    public static void main(String[] args) throws Exception {
        File backbone = new File(args[0]);
        File output = new File(args[1]);
        Map<String, String> seqMap = CutFasta.getSequences(backbone);
        StringBuilder builder = new StringBuilder();
        for (String name : seqMap.keySet()) {
            builder.append(">");
            builder.append(name);
            builder.append("\n");
            builder.append("AG" + seqMap.get(name));
            builder.append("\n");
            FileManager.writeTextFile(output, builder.toString(), true);
        }
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    public static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static void cut(String seq, int start, int end, File output) {
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(output.getName()).append("\n");
        builder.append(seq.toString().substring(start, end));
        FileManager.writeTextFile(output, builder.toString(), true);
    }
}

