/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreateAmbPrimerSetupFilesDPDQ {
    private static final String EMPTY_AMPLICON = "EmptyAmplicon";
    private static final String EMPTY_PRIMER = "EmptyF";
    private static final String DPA1 = "DPA-M";
    private static final String DPB1 = "DPB-M";
    private static final String DQB1_A = "HLA-DQB1-A";
    private static final String DQB1_B = "HLA-DQB1-B";
    private static String[] COORDINATE_X = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
    private static String[] COORDINATE_Y = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final int MAX_NUMBER = 3;
    private static final String GEMS_PRIMER_TRUE = "N";
    private static final String GEMS_PRIMER_TRUE2 = "A";
    private static final String PROTOCOL_DPA1 = "GENERAL";
    private static final String PROTOCOL_DPB1 = "GENERAL";
    private static final String PROTOCOL_DQB1_A = "HLA-DQB1 (A)";
    private static final String PROTOCOL_DQB1_B = "HLA-DQB1 (B)";
    private static final String NO_HARP = "No HARP";
    public static String PRIMER_AVAILABLE = "1";
    public static String EMPTY = "";

    public static void main(String[] args) {
        String projectName = args[0];
        File gemsFileDPA1 = new File(args[1]);
        File gemsFileDPB1 = new File(args[2]);
        File gemsFileDQB1 = new File(args[3]);
        File outputDir = new File(args[4]);
        File labSetUpFile = new File(outputDir, "labSetUp.csv");
        File gemsFile = new File(outputDir, "GeMS.csv");
        File seqMMCoordFile = new File(outputDir, "seqMMCoord.csv");
        File associationFile = new File(outputDir, "association.csv");
        String[] gemsDataDPA1 = FileManager.readTextFile(gemsFileDPA1).split("\n");
        String[] gemsDataDPB1 = FileManager.readTextFile(gemsFileDPB1).split("\n");
        String[] gemsDataDQB1 = FileManager.readTextFile(gemsFileDQB1).split("\n");
        List<String> coordLists = CreateAmbPrimerSetupFilesDPDQ.getCoordinates();
        Map<String, List<String>> gemsDPA1Map = CreateAmbPrimerSetupFilesDPDQ.parseGemsData(gemsDataDPA1, DPA1);
        Map<String, List<String>> gemsDPB1Map = CreateAmbPrimerSetupFilesDPDQ.parseGemsData(gemsDataDPB1, DPB1);
        Map<String, List<String>> gemsDQB1AMap = CreateAmbPrimerSetupFilesDPDQ.parseGemsData(gemsDataDQB1, DQB1_A);
        Map<String, List<String>> gemsDQB1BMap = CreateAmbPrimerSetupFilesDPDQ.parseGemsData(gemsDataDQB1, DQB1_B);
        List<String> allDPA1CellLinePresent = CreateAmbPrimerSetupFilesDPDQ.getAllCellLine(gemsDPA1Map);
        List<String> allDPB1CellLinePresent = CreateAmbPrimerSetupFilesDPDQ.getAllCellLine(gemsDPB1Map);
        List<String> allDQB1ACellLinePresent = CreateAmbPrimerSetupFilesDPDQ.getAllCellLine(gemsDQB1AMap);
        List<String> allDQB1BCellLinePresent = CreateAmbPrimerSetupFilesDPDQ.getAllCellLine(gemsDQB1BMap);
        List<String> primerDPA1List = CreateAmbPrimerSetupFilesDPDQ.getPrimerList(gemsDataDPA1[0]);
        List<String> primerDPB1List = CreateAmbPrimerSetupFilesDPDQ.getPrimerList(gemsDataDPB1[0]);
        List<String> primerDQB1List = CreateAmbPrimerSetupFilesDPDQ.getPrimerList(gemsDataDQB1[0]);
        StringBuilder labSetUpData = new StringBuilder();
        StringBuilder gemsData = new StringBuilder();
        StringBuilder SeqMMCordData = new StringBuilder();
        StringBuilder associationData = new StringBuilder();
        int counter = CreateAmbPrimerSetupFilesDPDQ.addLabSetUpPart(projectName, allDPA1CellLinePresent, coordLists, gemsDPA1Map, primerDPA1List, labSetUpData, DPA1, "GENERAL", 0, true);
        int counter2 = CreateAmbPrimerSetupFilesDPDQ.addGemsPart(projectName, allDPA1CellLinePresent, coordLists, gemsDPA1Map, primerDPA1List, gemsData, DPA1, "GENERAL", 0, true);
        int counter3 = CreateAmbPrimerSetupFilesDPDQ.addSeqCoordPart(projectName, allDPA1CellLinePresent, coordLists, gemsDPA1Map, primerDPA1List, SeqMMCordData, DPA1, "GENERAL", 0, true);
        counter = CreateAmbPrimerSetupFilesDPDQ.addLabSetUpPart(projectName, allDPB1CellLinePresent, coordLists, gemsDPB1Map, primerDPB1List, labSetUpData, DPB1, "GENERAL", counter, false);
        counter2 = CreateAmbPrimerSetupFilesDPDQ.addGemsPart(projectName, allDPB1CellLinePresent, coordLists, gemsDPB1Map, primerDPB1List, gemsData, DPB1, "GENERAL", counter2, false);
        counter3 = CreateAmbPrimerSetupFilesDPDQ.addSeqCoordPart(projectName, allDPB1CellLinePresent, coordLists, gemsDPB1Map, primerDPB1List, SeqMMCordData, DPB1, "GENERAL", counter3, false);
        CreateAmbPrimerSetupFilesDPDQ.addLabSetUpPart(projectName, allDQB1ACellLinePresent, coordLists, gemsDQB1AMap, primerDQB1List, labSetUpData, DQB1_A, PROTOCOL_DQB1_A, counter, false);
        CreateAmbPrimerSetupFilesDPDQ.addGemsPart(projectName, allDQB1ACellLinePresent, coordLists, gemsDQB1AMap, primerDQB1List, gemsData, DQB1_A, PROTOCOL_DQB1_A, counter2, false);
        CreateAmbPrimerSetupFilesDPDQ.addSeqCoordPart(projectName, allDQB1ACellLinePresent, coordLists, gemsDQB1AMap, primerDQB1List, SeqMMCordData, DQB1_A, PROTOCOL_DQB1_A, counter3, false);
        CreateAmbPrimerSetupFilesDPDQ.buildAssociationData(allDPA1CellLinePresent, allDPB1CellLinePresent, allDQB1ACellLinePresent, allDQB1BCellLinePresent, projectName, coordLists, gemsDPA1Map, gemsDPB1Map, gemsDQB1AMap, gemsDQB1BMap, associationData);
        FileManager.writeTextFile(labSetUpFile, labSetUpData.toString(), true);
        FileManager.writeTextFile(gemsFile, gemsData.toString(), true);
        FileManager.writeTextFile(seqMMCoordFile, SeqMMCordData.toString(), true);
        FileManager.writeTextFile(associationFile, associationData.toString(), true);
        System.out.println("done");
    }

    private static void buildAssociationData(List<String> allDPA1CellLinePresent, List<String> allDPB1CellLinePresent, List<String> allDQB1ACellLinePresent, List<String> allDQB1BCellLinePresent, String projectName, List<String> coordLists, Map<String, List<String>> gemsDPA1Map, Map<String, List<String>> gemsDPB1Map, Map<String, List<String>> gemsDQB1AMap, Map<String, List<String>> gemsDQB1BMap, StringBuilder associationData) {
        associationData.append("Cell Line,PCR Plate,PCR Coord,Sequencing Plate,Seq Coord,Lab Seq Primer\n");
        String plateName = null;
        Object ausPrimers = null;
        List<String> gemsPrimers = null;
        PcrPlateCoord pcrPlateCoord = null;
        int i = 0;
        while (i < 3) {
            int coord_index = 0;
            plateName = String.valueOf(CreateAmbPrimerSetupFilesDPDQ.fixName(projectName)) + "-" + "Resolving" + "_" + (i + 1) + "F";
            for (String cellLine : allDPA1CellLinePresent) {
                pcrPlateCoord = CreateAmbPrimerSetupFilesDPDQ.getPCRCoordinate(projectName, cellLine, DPA1, "GENERAL");
                associationData.append(cellLine).append(",");
                associationData.append(pcrPlateCoord.getPlate()).append(",");
                associationData.append(pcrPlateCoord.getCoord()).append(",");
                associationData.append(plateName).append(",");
                associationData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, coord_index)).append(",");
                gemsPrimers = gemsDPA1Map.get(cellLine);
                if (gemsPrimers == null) {
                    gemsPrimers = new ArrayList<String>();
                }
                if (gemsPrimers.size() > i) {
                    associationData.append(gemsPrimers.get(i)).append(",");
                } else {
                    associationData.append(EMPTY_AMPLICON).append(",");
                }
                associationData.append("\n");
                ++coord_index;
            }
            for (String cellLine : allDPB1CellLinePresent) {
                pcrPlateCoord = CreateAmbPrimerSetupFilesDPDQ.getPCRCoordinate(projectName, cellLine, DPB1, "GENERAL");
                associationData.append(cellLine).append(",");
                associationData.append(pcrPlateCoord.getPlate()).append(",");
                associationData.append(pcrPlateCoord.getCoord()).append(",");
                associationData.append(plateName).append(",");
                associationData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, coord_index)).append(",");
                gemsPrimers = gemsDPB1Map.get(cellLine);
                if (gemsPrimers == null) {
                    gemsPrimers = new ArrayList<String>();
                }
                if (gemsPrimers.size() > i) {
                    associationData.append(gemsPrimers.get(i)).append(",");
                } else {
                    associationData.append(EMPTY_AMPLICON).append(",");
                }
                associationData.append("\n");
                ++coord_index;
            }
            for (String cellLine : allDQB1ACellLinePresent) {
                pcrPlateCoord = CreateAmbPrimerSetupFilesDPDQ.getPCRCoordinate(projectName, cellLine, DQB1_A, PROTOCOL_DQB1_A);
                associationData.append(cellLine).append(",");
                associationData.append(pcrPlateCoord.getPlate()).append(",");
                associationData.append(pcrPlateCoord.getCoord()).append(",");
                associationData.append(plateName).append(",");
                associationData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, coord_index)).append(",");
                gemsPrimers = gemsDQB1AMap.get(cellLine);
                if (gemsPrimers == null) {
                    gemsPrimers = new ArrayList<String>();
                }
                if (gemsPrimers.size() > i) {
                    associationData.append(gemsPrimers.get(i)).append(",");
                } else {
                    associationData.append(EMPTY_AMPLICON).append(",");
                }
                associationData.append("\n");
                ++coord_index;
            }
            for (String cellLine : allDQB1BCellLinePresent) {
                pcrPlateCoord = CreateAmbPrimerSetupFilesDPDQ.getPCRCoordinate(projectName, cellLine, DQB1_B, PROTOCOL_DQB1_B);
                associationData.append(cellLine).append(",");
                associationData.append(pcrPlateCoord.getPlate()).append(",");
                associationData.append(pcrPlateCoord.getCoord()).append(",");
                associationData.append(plateName).append(",");
                associationData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, coord_index)).append(",");
                gemsPrimers = gemsDQB1BMap.get(cellLine);
                if (gemsPrimers == null) {
                    gemsPrimers = new ArrayList<String>();
                }
                if (gemsPrimers.size() > i) {
                    associationData.append(gemsPrimers.get(i)).append(",");
                } else {
                    associationData.append(EMPTY_AMPLICON).append(",");
                }
                associationData.append("\n");
                ++coord_index;
            }
            ++i;
        }
    }

    private static int addSeqCoordPart(String projectName, List<String> allACellLinePresent, List<String> coordLists, Map<String, List<String>> gemsDPA1Map, List<String> primerDPA1List, StringBuilder seqCoordData, String amp, String protocol, int index, boolean is1stPart) {
        if (is1stPart) {
            seqCoordData.append(",,,,,,,,\n");
            seqCoordData.append(",Plate1,,plate2,,Plate3,\n");
        }
        List<String> gemsPrimers = null;
        int counter = index;
        for (String cellLine : allACellLinePresent) {
            gemsPrimers = gemsDPA1Map.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
            }
            int i = 0;
            while (i < Math.min(3, gemsPrimers.size())) {
                seqCoordData.append(PRIMER_AVAILABLE).append(",");
                seqCoordData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (gemsPrimers.size() < 3) {
                i = 0;
                while (i < 3 - gemsPrimers.size()) {
                    seqCoordData.append(EMPTY).append(",");
                    seqCoordData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            seqCoordData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static int addGemsPart(String projectName, List<String> allACellLinePresent, List<String> coordLists, Map<String, List<String>> gemsDPA1Map, List<String> primerDPA1List, StringBuilder gemsData, String amp, String protocol, int index, boolean is1stPart) {
        if (is1stPart) {
            gemsData.append("Lab,,PCR Coord,");
            int i = 0;
            while (i < 3) {
                gemsData.append(",Seq Coord,");
                ++i;
            }
            gemsData.append("\n");
        }
        List<String> gemsPrimers = null;
        int counter = index;
        for (String cellLine : allACellLinePresent) {
            gemsPrimers = gemsDPA1Map.get(cellLine);
            gemsData.append(cellLine).append(",");
            gemsData.append(amp).append(",");
            gemsData.append(CreateAmbPrimerSetupFilesDPDQ.getPCRCoordinate(projectName, cellLine, amp, protocol).getCoord()).append(",");
            int i = 0;
            while (i < Math.min(3, gemsPrimers.size())) {
                gemsData.append(gemsPrimers.get(i)).append(",");
                gemsData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (gemsPrimers.size() < 3) {
                i = 0;
                while (i < 3 - gemsPrimers.size()) {
                    gemsData.append(EMPTY_PRIMER).append(",");
                    gemsData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            gemsData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static int addLabSetUpPart(String projectName, List<String> allDPA1CellLinePresent, List<String> coordLists, Map<String, List<String>> gemsDPA1Map, List<String> primerDPA1List, StringBuilder labSetUpData, String amp, String protocol, int ind, boolean isFirst) {
        if (isFirst) {
            labSetUpData.append("Lab,,PCR Coord,");
        } else {
            labSetUpData.append(",,,");
        }
        for (String primer : primerDPA1List) {
            labSetUpData.append(primer).append(",Seq Coord,");
        }
        labSetUpData.append("\n");
        List<String> gemsPrimers = null;
        int counter = ind;
        for (String cellLine : allDPA1CellLinePresent) {
            gemsPrimers = gemsDPA1Map.get(cellLine);
            labSetUpData.append(cellLine).append(",");
            labSetUpData.append(amp).append(",");
            labSetUpData.append(CreateAmbPrimerSetupFilesDPDQ.getPCRCoordinate(projectName, cellLine, amp, protocol).getCoord()).append(",");
            for (String aPrimer : primerDPA1List) {
                if (gemsPrimers.contains(aPrimer)) {
                    int index = gemsPrimers.indexOf(aPrimer) + 1;
                    if (index > 3) {
                        labSetUpData.append(",");
                    } else {
                        labSetUpData.append(index).append(",");
                    }
                } else {
                    labSetUpData.append(",");
                }
                labSetUpData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
            }
            labSetUpData.append("\n");
            ++counter;
        }
        return counter;
    }

    private static String fixName(String name) {
        return name.split("-")[0];
    }

    private static List<String> getAllCellLine(Map<String, List<String>> gemsMap) {
        ArrayList<String> list = new ArrayList<String>();
        CreateAmbPrimerSetupFilesDPDQ.addToList(gemsMap, list);
        return list;
    }

    private static void addToList(Map<String, List<String>> map, List<String> list) {
        for (String cellLine : map.keySet()) {
            if (list.contains(cellLine)) continue;
            list.add(cellLine);
        }
    }

    private static void addSeqCoordCPart(List<String> allCCellLinePresent, String projectName, Map<String, List<String>> ausCMap, int maxAusSize, List<String> coordLists, Map<String, List<String>> gemsCMap, List<String> cPrimerList, StringBuilder seqCoordData, int counter) {
        List<String> ausPrimers = null;
        List<String> gemsPrimers = null;
        for (String cellLine : allCCellLinePresent) {
            gemsPrimers = gemsCMap.get(cellLine);
            if (gemsPrimers == null) {
                gemsPrimers = new ArrayList<String>();
            }
            if ((ausPrimers = ausCMap.get(cellLine)) == null) {
                ausPrimers = new ArrayList<String>();
                ausPrimers.add("");
            }
            for (String primer : ausPrimers) {
                if (primer.equalsIgnoreCase(NO_HARP) || primer.equalsIgnoreCase("")) {
                    seqCoordData.append(EMPTY).append(",");
                } else {
                    seqCoordData.append(PRIMER_AVAILABLE).append(",");
                }
                seqCoordData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
            }
            int i = 0;
            while (i < Math.min(3 - ausPrimers.size(), gemsPrimers.size())) {
                seqCoordData.append(PRIMER_AVAILABLE).append(",");
                seqCoordData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
                ++i;
            }
            if (ausPrimers.size() + gemsPrimers.size() < 3) {
                i = 0;
                while (i < 3 - ausPrimers.size() - gemsPrimers.size()) {
                    seqCoordData.append(EMPTY).append(",");
                    seqCoordData.append(CreateAmbPrimerSetupFilesDPDQ.getThisCoordinate(coordLists, counter)).append(",");
                    ++i;
                }
            }
            seqCoordData.append("\n");
            ++counter;
        }
    }

    private static String getThisCoordinate(List<String> coordLists, int counter) {
        if (counter >= coordLists.size()) {
            return "Unknown Coord";
        }
        return coordLists.get(counter);
    }

    private static List<String> getCoordinates() {
        ArrayList<String> coordLists = new ArrayList<String>();
        String[] stringArray = COORDINATE_Y;
        int n = COORDINATE_Y.length;
        int n2 = 0;
        while (n2 < n) {
            String y = stringArray[n2];
            String[] stringArray2 = COORDINATE_X;
            int n3 = COORDINATE_X.length;
            int n4 = 0;
            while (n4 < n3) {
                String x = stringArray2[n4];
                coordLists.add(String.valueOf(x) + y);
                ++n4;
            }
            ++n2;
        }
        return coordLists;
    }

    private static PcrPlateCoord getPCRCoordinate(String projectName, String cellLine, String amplicon, String pcrProtocolName) {
        String url = "jdbc:postgresql://panacea.fhcrc.org:5432/gemsprod";
        String query1 = "select distinct parent_experiment_id, parent_coordinate_id from pcr.chromat_report_mv where cell_line_name ilike ? and project_name=? and amplicon_name=? and pcr_protocol_name=?";
        String query2 = "select plate_name from pcr.experiment where experiment_id=?";
        String query3 = "select coordinate from pcr.plate_coord where plate_coord_id = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet2 = null;
        PreparedStatement preparedStatement3 = null;
        ResultSet resultSet3 = null;
        PcrPlateCoord pcrPlateCoord = new PcrPlateCoord();
        try {
            Class.forName("org.postgresql.Driver");
            Connection db = DriverManager.getConnection(url, "gems", "Caff1ne");
            preparedStatement = db.prepareStatement(query1);
            preparedStatement.setString(1, cellLine);
            preparedStatement.setString(2, projectName);
            preparedStatement.setString(3, amplicon);
            preparedStatement.setString(4, pcrProtocolName);
            resultSet = preparedStatement.executeQuery();
            String parent_experiment_id = null;
            String parent_coordinate_id = null;
            if (resultSet.next()) {
                parent_experiment_id = resultSet.getString(1);
                parent_coordinate_id = resultSet.getString(2);
                preparedStatement2 = db.prepareStatement(query2);
                preparedStatement2.setString(1, parent_experiment_id);
                resultSet2 = preparedStatement2.executeQuery();
                preparedStatement3 = db.prepareStatement(query3);
                preparedStatement3.setString(1, parent_coordinate_id);
                resultSet3 = preparedStatement3.executeQuery();
                if (resultSet2.next()) {
                    pcrPlateCoord.setPlate(resultSet2.getString(1));
                }
                if (resultSet3.next()) {
                    pcrPlateCoord.setCoord(resultSet3.getString(1));
                }
            } else {
                System.out.println("Error : no pcr coordinate record for " + cellLine + " " + amplicon);
            }
            if (resultSet.next()) {
                System.out.println("Error : multiple pcr coordinate record for " + cellLine + " " + amplicon);
            }
            CreateAmbPrimerSetupFilesDPDQ.closeResources(resultSet3, preparedStatement3, null);
            CreateAmbPrimerSetupFilesDPDQ.closeResources(resultSet2, preparedStatement2, null);
            CreateAmbPrimerSetupFilesDPDQ.closeResources(resultSet, preparedStatement, db);
        }
        catch (Exception e) {
            System.err.println("Got an exception! ");
            System.err.println(e.getMessage());
        }
        return pcrPlateCoord;
    }

    public static void closeResources(ResultSet resultSet, Statement statement, Connection connection) {
        SQLException sqlException = new SQLException();
        boolean isSQLExceptionEncountered = false;
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                sqlException.setNextException(e);
                isSQLExceptionEncountered = true;
            }
        }
        if (isSQLExceptionEncountered) {
            System.out.println("error close resource");
        }
    }

    private static void sizeCheck(Map<String, List<String>> map1, Map<String, List<String>> map2, String type) {
        if (map1.size() != map2.size()) {
            System.out.println("Warning: sample size different in " + type + " " + map1.size() + " : " + map2.size());
        }
    }

    private static List<String> getPrimerList(String headerLine) {
        String[] info;
        ArrayList<String> primers = new ArrayList<String>();
        String[] stringArray = info = headerLine.split(",");
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            String primer = stringArray[n2];
            if (primer.trim().length() > 0) {
                primers.add(primer.trim());
            }
            ++n2;
        }
        return primers;
    }

    private static Map<String, List<String>> parseGemsData(String[] gemsData, String amplicon) {
        LinkedHashMap<String, List<String>> gemsMap = new LinkedHashMap<String, List<String>>();
        String[] header = gemsData[0].split(",");
        int i = 1;
        while (i < gemsData.length) {
            if (gemsData[i].indexOf(amplicon) < 0) {
                System.out.println("Warning skip b/c no " + amplicon + " find " + gemsData[i]);
            } else {
                String[] info = gemsData[i].split(",");
                gemsMap.put(info[0].trim(), new ArrayList());
                int j = 2;
                while (j < info.length) {
                    if (info[j].trim().equals(GEMS_PRIMER_TRUE) || info[j].trim().equals(GEMS_PRIMER_TRUE2)) {
                        ((List)gemsMap.get(info[0].trim())).add(header[j].trim());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return gemsMap;
    }
}

