/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompareHLAReport {
    public static void main(String[] args) throws Exception {
        File reportFile1 = new File(args[0]);
        File reportFile2 = new File(args[1]);
        File alignmentAFile = new File(args[2]);
        File alignmentBFile = new File(args[3]);
        File alignmentCFile = new File(args[4]);
        File HalotypeAmbiguityFile = new File(args[5]);
        String[] data1 = FileManager.readTextFile(reportFile1).split("\n");
        String[] data2 = FileManager.readTextFile(reportFile2).split("\n");
        Map<String, String> sequenceAMap = TestAmbiguity.parseAlignmentFile(alignmentAFile, "A");
        Map<String, String> sequenceBMap = TestAmbiguity.parseAlignmentFile(alignmentBFile, "B");
        Map<String, String> sequenceCMap = TestAmbiguity.parseAlignmentFile(alignmentCFile, "Cw");
        Map<String, Map<String, List<String>>> symbolMap = CompareHLAReport.parseSymbolFile(HalotypeAmbiguityFile);
        List<String> aAlleleList = CompareHLAReport.processMap(symbolMap.get("A"), sequenceAMap);
        List<String> bAlleleList = CompareHLAReport.processMap(symbolMap.get("B"), sequenceBMap);
        List<String> cAlleleList = CompareHLAReport.processMap(symbolMap.get("Cw"), sequenceCMap);
        int lastIndex = 0;
        boolean find = false;
        int i = 0;
        while (i < data1.length) {
            String[] items1 = data1[i].trim().split("\\t");
            find = false;
            int x = lastIndex;
            while (x < data2.length) {
                String[] items2 = data2[x].trim().split("\\t");
                if (items1[5].trim().equals(items2[5].trim()) && items1[9].trim().equals(items2[9].trim())) {
                    find = true;
                    if (i > 0 && !CompareHLAReport.isValideAllele(items1[9].trim(), items1[10].trim(), aAlleleList, bAlleleList, cAlleleList)) {
                        System.out.println("Not standard name " + items1[10] + " at line " + (i + 1));
                    }
                    if (i > 0 && !CompareHLAReport.isValideAllele(items2[9].trim(), items2[10].trim(), aAlleleList, bAlleleList, cAlleleList)) {
                        System.out.println("Not standard name " + items2[10] + " at line " + (i + 1));
                    }
                    int j = 0;
                    while (j < 16) {
                        if (!(items1[j].trim().equals(items2[j].trim()) || items1[j].indexOf("+") > 0 && items2[j].indexOf("+") > 0 && items1[j].trim().split("\\+")[0].equals(items2[j].trim().split("\\+")[1]) && items1[j].trim().split("\\+")[1].equals(items2[j].trim().split("\\+")[0]))) {
                            System.out.println("line " + (i + 1) + " line " + (x + 1) + ", field " + (j + 1) + ", " + items1[5] + ", " + items1[j] + ", " + items2[j]);
                        }
                        ++j;
                    }
                }
                ++x;
            }
            if (!find) {
                System.out.println("missing peer data at line " + (i + 1) + " " + items1[5] + " " + items1[9]);
            }
            ++i;
        }
        System.out.println("done ");
    }

    private static boolean isValideAllele(String locus, String type, List<String> aAlleleList, List<String> bAlleleList, List<String> cAlleleList) {
        String[] hs = type.split("\\+");
        String h1 = hs[0].trim().split("\\*")[1];
        String h2 = null;
        h2 = hs.length == 1 ? h1 : hs[1].trim().split("\\*")[1];
        if (type.startsWith("A") && aAlleleList.contains(h1) && aAlleleList.contains(h2)) {
            return true;
        }
        if (type.startsWith("B") && bAlleleList.contains(h1) && bAlleleList.contains(h2)) {
            return true;
        }
        return type.startsWith("C") && cAlleleList.contains(h1) && cAlleleList.contains(h2);
    }

    private static List<String> processMap(Map<String, List<String>> symbolMap, Map<String, String> sequenceAMap) {
        ArrayList<String> validAlleleList = new ArrayList<String>();
        for (String allele : sequenceAMap.keySet()) {
            if (CompareHLAReport.isInSymbol(allele, symbolMap)) continue;
            validAlleleList.add(allele);
        }
        for (String allele : symbolMap.keySet()) {
            validAlleleList.add(allele.trim());
        }
        return validAlleleList;
    }

    private static boolean isInSymbol(String allele, Map<String, List<String>> symbolMap) {
        for (List<String> list : symbolMap.values()) {
            if (!list.contains(allele)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Map<String, List<String>>> parseSymbolFile(File symbolFile) {
        HashMap<String, Map<String, List<String>>> symbolMap = new HashMap<String, Map<String, List<String>>>();
        String[] data = FileManager.readTextFile(symbolFile).split("\n");
        Map<String, List<String>> aMap = CompareHLAReport.parseSymbols(data, "A");
        Map<String, List<String>> bMap = CompareHLAReport.parseSymbols(data, "B");
        Map<String, List<String>> cMap = CompareHLAReport.parseSymbols(data, "Cw");
        symbolMap.put("A", aMap);
        symbolMap.put("B", bMap);
        symbolMap.put("Cw", cMap);
        return symbolMap;
    }

    public static Map<String, List<String>> parseSymbols(String[] lines, String type) {
        HashMap<String, List<String>> symbolMap = new HashMap<String, List<String>>();
        String[] info = null;
        ArrayList<String> list = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            info = line.trim().split(",");
            if (info[0].trim().startsWith(type)) {
                list = new ArrayList<String>();
                int i = 1;
                while (i < info.length) {
                    if (info[i].trim().startsWith(type)) {
                        list.add(info[i].trim().split("\\*")[1]);
                    }
                    ++i;
                }
                symbolMap.put(info[0].trim().split("\\*")[1], list);
            }
            ++n2;
        }
        return symbolMap;
    }
}

