/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;

public class AnnotationPhotographerSpecial {
    private static final String PNG = "png";
    private static final double MIN_NUMBER = 5.0;
    private static final double MAX_NUMBER = 10.0;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_HEIGHT = 500;
    private static final int IMAGE_SEQUENCE_POSITION = 100;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int IMAGE_AMPLICON_BAR_HEIGHT = 5;
    private static final int INTRON_EXON_BAR_HEIGHT = 5;
    private static final int AMPLICON_SHIFT_UNIT = 10;
    private static final int MARKER_HEIGHT = 8;
    private static final int SNP_MARKER_HEIGHT = 24;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 74;
    private static final int LETTER_WIDTH = 8;
    private static final int MASKED_SEQUENCE_POSITION = 100;
    private static final int INTRON_EXON_POSITION = 160;
    private static final int AMPLICON_POSITION = 185;
    private static final int SNP_POSITION = 60;
    private static final int MASKED_SEQUENCE_NOTE = 50;
    private static final int AMPLICON_NOTE = 90;
    private static final int SNP_NOTE = 70;
    private static final int INTRON_EXON_NOTE = 110;
    private static final int SNP_POINT_WIDTH = 1;
    private static final int IMAGE_UNIT = 100;
    private static final int NORMAL_SEQUENCE_UNIT = 1000;
    private static final int MAX_IMAGE_WIDTH = 65500;
    private static BufferedImage bufferedImage;
    private static Graphics2D graphics2D;
    private static int imageWidth;
    private static boolean useDefault;
    private static double unit;
    private static int num;
    private static int sequenceUnit;

    public static void main(String[] args) throws Exception {
        File fasta = new File(args[0]);
        File maskedFastaLog = new File(args[1]);
        File intronExons = new File(args[2]);
        File amplicons = new File(args[3]);
        File snps = new File(args[4]);
        File image = new File(args[5]);
        File intronExons2 = new File(args[6]);
        File intronExons3 = new File(args[7]);
        File intronExons4 = new File(args[8]);
        GeneAnnotationVO geneAnnotationVO = AnnotationPhotographerSpecial.prepDataForGraph(fasta, maskedFastaLog, intronExons, amplicons, snps);
        AnnotationPhotographerSpecial.generateImage(geneAnnotationVO, image, intronExons2, intronExons3, intronExons4);
    }

    private static GeneAnnotationVO prepDataForGraph(File fasta, File maskedFastaLog, File intronExons, File amplicons, File snps) {
        GeneAnnotationVO geneAnnotationVO = new GeneAnnotationVO();
        geneAnnotationVO.setDrawAmplicon(true);
        geneAnnotationVO.setDrawSnp(true);
        geneAnnotationVO.setDrawRepeatMask(true);
        geneAnnotationVO.setDrawIntronExon(true);
        geneAnnotationVO.setSequenceLength(AnnotationPhotographerSpecial.getSequenceLength(fasta));
        geneAnnotationVO.setRepeatMasked(AnnotationPhotographerSpecial.getRepeatMasked(maskedFastaLog));
        geneAnnotationVO.setAmplicons(AnnotationPhotographerSpecial.getAmplicons(amplicons));
        geneAnnotationVO.setSnps(AnnotationPhotographerSpecial.getSnps(snps));
        geneAnnotationVO.setIntronExons(AnnotationPhotographerSpecial.getIntronExons(intronExons));
        return geneAnnotationVO;
    }

    private static List<Snp> getSnps(File snps) {
        ArrayList<Snp> snpList = new ArrayList<Snp>();
        String[] lines = FileManager.readTextFile(snps).split("\n");
        int i = 1;
        int j = lines.length;
        while (i < j) {
            String[] token = lines[i].split("\\s+");
            snpList.add(AnnotationPhotographerSpecial.parseSnp(token));
            ++i;
        }
        return snpList;
    }

    private static Snp parseSnp(String[] item) {
        Snp snp = new Snp();
        snp.setLocalName(item[0].trim());
        snp.setPosition(new Integer(item[1]));
        snp.setRs(item[2].trim());
        if (item[3].trim().equalsIgnoreCase("r")) {
            snp.setRare(true);
        } else if (item[3].trim().equalsIgnoreCase("c")) {
            snp.setRare(false);
        } else {
            System.out.println("unknow MAF : " + item[3]);
        }
        return snp;
    }

    private static List<SequencePiece> getIntronExons(File intronExons) {
        ArrayList<SequencePiece> intronExonList = new ArrayList<SequencePiece>();
        String[] lines = FileManager.readTextFile(intronExons).split("\n");
        int i = 1;
        int j = lines.length;
        while (i < j) {
            String[] token = lines[i].trim().split("\t");
            intronExonList.add(AnnotationPhotographerSpecial.parseAmplicon(token));
            ++i;
        }
        return intronExonList;
    }

    private static List<SequencePiece> getAmplicons(File amplicons) {
        ArrayList<SequencePiece> ampliconList = new ArrayList<SequencePiece>();
        String[] lines = FileManager.readTextFile(amplicons).split("\n");
        int i = 1;
        int j = lines.length;
        while (i < j) {
            String[] token = lines[i].split("\\s+");
            ampliconList.add(AnnotationPhotographerSpecial.parseAmplicon(token));
            ++i;
        }
        return ampliconList;
    }

    private static List<SequencePiece> getRepeatMasked(File maskedFastaLog) {
        ArrayList<SequencePiece> repeatMaskPositionList = new ArrayList<SequencePiece>();
        String[] matches = FileManager.readTextFile(maskedFastaLog).split("\n");
        if (matches.length == 1 && matches[0].startsWith("No")) {
            return repeatMaskPositionList;
        }
        int i = 0;
        while (i < matches.length) {
            String[] token = matches[i].split("\\s+");
            repeatMaskPositionList.add(AnnotationPhotographerSpecial.parseMatch(token));
            ++i;
        }
        return repeatMaskPositionList;
    }

    private static SequencePiece parseAmplicon(String[] item) {
        SequencePiece sequencePiece = new SequencePiece();
        sequencePiece.setName(item[0].trim());
        sequencePiece.setStart(new Integer(item[1]));
        sequencePiece.setEnd(new Integer(item[2]));
        return sequencePiece;
    }

    private static SequencePiece parseMatch(String[] item) {
        SequencePiece sequencePiece = new SequencePiece();
        sequencePiece.setStart(new Integer(item[5]));
        sequencePiece.setEnd(new Integer(item[6]));
        return sequencePiece;
    }

    private static int getSequenceLength(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString().length();
    }

    private static void initializeBufferedImage(GeneAnnotationVO geneAnnotationVO) {
        imageWidth = 1000;
        unit = 100.0;
        useDefault = true;
        num = 0;
        if (geneAnnotationVO.getSequenceLength() < 10000) {
            unit = AnnotationPhotographerSpecial.getUnit(geneAnnotationVO.getSequenceLength());
            num = new Double((double)geneAnnotationVO.getSequenceLength() / unit).intValue();
        } else {
            imageWidth = geneAnnotationVO.getSequenceLength() * 100 / 1000;
            useDefault = false;
            num = new Double(geneAnnotationVO.getSequenceLength() / 1000).intValue();
            sequenceUnit = 1000;
            if (imageWidth > 65500) {
                imageWidth /= 2;
                sequenceUnit = 2000;
                num = new Double(geneAnnotationVO.getSequenceLength() / sequenceUnit).intValue();
            }
        }
        bufferedImage = new BufferedImage(imageWidth, 500, 9);
    }

    private static void initializeGraphics2D(GeneAnnotationVO geneAnnotationVO) {
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private static void drawSequence(GeneAnnotationVO geneAnnotationVO) {
        int length = geneAnnotationVO.getSequenceLength();
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.draw3DRect(0, bufferedImage.getHeight() - 100, bufferedImage.getWidth(), 10, true);
        graphics2D.fill3DRect(0, bufferedImage.getHeight() - 100, bufferedImage.getWidth(), 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, bufferedImage.getHeight() - 100, 1, bufferedImage.getHeight() - 100 + 10);
        graphics2D.drawString("1", 1, bufferedImage.getHeight() - 74);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 100, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 100 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, bufferedImage.getHeight() - 74);
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            if (useDefault) {
                x = Math.round(new Float(new Double(imageWidth) / new Double(length) * unit * (double)i).floatValue());
                index = String.valueOf(new Double(unit * (double)i).intValue());
            } else {
                x = 100 * i;
                index = String.valueOf(sequenceUnit * i);
            }
            graphics2D.drawLine(x, bufferedImage.getHeight() - 100, x, bufferedImage.getHeight() - 100 + 10);
            if (i < num || i == num && ((double)length - unit * (double)num >= unit / 2.0 && useDefault || length - sequenceUnit * num >= sequenceUnit / 2 && !useDefault)) {
                graphics2D.drawString(index, x, bufferedImage.getHeight() - 74);
            }
            ++i;
        }
    }

    private static void drawAmplicon(GeneAnnotationVO geneAnnotationVO) {
        int length = geneAnnotationVO.getSequenceLength();
        graphics2D.setColor(Color.GREEN);
        graphics2D.draw3DRect(30, 90, 50, 5, true);
        graphics2D.fill3DRect(30, 90, 50, 5, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("Amplicon", 90, 100);
        graphics2D.setColor(Color.GREEN);
        int adjustor = 0;
        for (SequencePiece sequencePiece : geneAnnotationVO.getAmplicons()) {
            int from = sequencePiece.getStart();
            int to = sequencePiece.getEnd();
            int x1 = 0;
            int x2 = 0;
            if (useDefault) {
                x1 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)from).floatValue());
                x2 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)to).floatValue());
            } else {
                x1 = from * 100 / sequenceUnit;
                x2 = to * 100 / sequenceUnit;
            }
            graphics2D.draw3DRect(x1, bufferedImage.getHeight() - 185 - adjustor % 2 * 10, x2 - x1, 5, true);
            graphics2D.fill3DRect(x1, bufferedImage.getHeight() - 185 - adjustor % 2 * 10, x2 - x1, 5, true);
            ++adjustor;
        }
    }

    private static void drawIntronExon(GeneAnnotationVO geneAnnotationVO, int offset) {
        int length = geneAnnotationVO.getSequenceLength();
        graphics2D.setColor(Color.CYAN);
        graphics2D.draw3DRect(30, 110, 50, 5, true);
        graphics2D.fill3DRect(30, 110, 50, 5, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("Exon", 90, 120);
        for (SequencePiece sequencePiece : geneAnnotationVO.getIntronExons()) {
            if (sequencePiece.getName().trim().substring(0, 4).equalsIgnoreCase("Exon")) {
                graphics2D.setColor(Color.CYAN);
            } else {
                graphics2D.setColor(Color.LIGHT_GRAY);
            }
            int from = sequencePiece.getStart();
            int to = sequencePiece.getEnd();
            int x1 = 0;
            int x2 = 0;
            if (useDefault) {
                x1 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)from).floatValue());
                x2 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)to).floatValue());
            } else {
                x1 = from * 100 / sequenceUnit;
                x2 = to * 100 / sequenceUnit;
            }
            graphics2D.draw3DRect(x1, bufferedImage.getHeight() - 160 - offset, x2 - x1, 5, true);
            graphics2D.fill3DRect(x1, bufferedImage.getHeight() - 160 - offset, x2 - x1, 5, true);
        }
    }

    private static void generateImage(GeneAnnotationVO geneAnnotationVO, File image, File intronExons2, File intronExons3, File intronExons4) {
        AnnotationPhotographerSpecial.initializeBufferedImage(geneAnnotationVO);
        AnnotationPhotographerSpecial.initializeGraphics2D(geneAnnotationVO);
        AnnotationPhotographerSpecial.drawSequence(geneAnnotationVO);
        if (geneAnnotationVO.isDrawRepeatMask()) {
            AnnotationPhotographerSpecial.drawRepeatMasker(geneAnnotationVO);
        }
        if (geneAnnotationVO.isDrawAmplicon()) {
            AnnotationPhotographerSpecial.drawAmplicon(geneAnnotationVO);
        }
        if (geneAnnotationVO.isDrawSnp()) {
            AnnotationPhotographerSpecial.drawDnSnp(geneAnnotationVO);
        }
        if (geneAnnotationVO.isDrawIntronExon()) {
            AnnotationPhotographerSpecial.drawIntronExon(geneAnnotationVO, 0);
            geneAnnotationVO.setIntronExons(AnnotationPhotographerSpecial.getIntronExons(intronExons2));
            AnnotationPhotographerSpecial.drawIntronExon(geneAnnotationVO, -15);
            geneAnnotationVO.setIntronExons(AnnotationPhotographerSpecial.getIntronExons(intronExons3));
            AnnotationPhotographerSpecial.drawIntronExon(geneAnnotationVO, -30);
            geneAnnotationVO.setIntronExons(AnnotationPhotographerSpecial.getIntronExons(intronExons4));
            AnnotationPhotographerSpecial.drawIntronExon(geneAnnotationVO, -45);
        }
        AnnotationPhotographerSpecial.writeImageToFile(image);
    }

    private static void writeImageToFile(File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName(PNG).next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }

    private static void drawDnSnp(GeneAnnotationVO geneAnnotationVO) {
        int length = geneAnnotationVO.getSequenceLength();
        graphics2D.setColor(Color.RED);
        graphics2D.drawRect(30, 70, 2, 8);
        graphics2D.fillRect(30, 70, 2, 8);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(100, 70, 2, 8);
        graphics2D.fillRect(100, 70, 2, 8);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("Rare Snp", 42, 78);
        graphics2D.drawString("Common Snp", 112, 78);
        graphics2D.setColor(Color.ORANGE);
        for (Snp snp : geneAnnotationVO.getSnps()) {
            if (snp.isRare()) {
                graphics2D.setColor(Color.RED);
            } else {
                graphics2D.setColor(Color.BLACK);
            }
            int snpPosition = snp.getPosition();
            int x = 0;
            x = useDefault ? Math.round(new Float(new Double(1000.0) / new Double(length) * (double)snpPosition).floatValue()) : snpPosition * 100 / sequenceUnit;
            int recYStart = bufferedImage.getHeight() - 60;
            graphics2D.drawRect(x, recYStart, 1, 24);
            graphics2D.fillRect(x, recYStart, 1, 24);
            if (!snp.isRare()) continue;
            int[] ARROW_X = new int[]{x - 3, x, x + 1, x + 4};
            int[] ARROW_Y = new int[]{recYStart + 5, recYStart, recYStart, recYStart + 5};
            graphics2D.drawPolyline(ARROW_X, ARROW_Y, 4);
        }
    }

    private static void drawRepeatMasker(GeneAnnotationVO geneAnnotationVO) {
        int length = geneAnnotationVO.getSequenceLength();
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.draw3DRect(30, 50, 50, 10, true);
        graphics2D.fill3DRect(30, 50, 50, 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("RepeatMasked", 90, 60);
        graphics2D.setColor(Color.DARK_GRAY);
        for (SequencePiece sequencePiece : geneAnnotationVO.getRepeatMasked()) {
            int from = sequencePiece.getStart();
            int to = sequencePiece.getEnd();
            int x1 = 0;
            int x2 = 0;
            if (useDefault) {
                x1 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)from).floatValue());
                x2 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)to).floatValue());
            } else {
                x1 = from * 100 / sequenceUnit;
                x2 = to * 100 / sequenceUnit;
            }
            graphics2D.draw3DRect(x1, bufferedImage.getHeight() - 100, x2 - x1, 10, true);
            graphics2D.fill3DRect(x1, bufferedImage.getHeight() - 100, x2 - x1, 10, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }
}

