/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import ruleset.Nmer;
import ruleset.PickingNmersForDoubleCoverageForBC;

public class PickingNmersForDoubleCoverageCII {
    static List<Integer> excludingSite = PickingNmersForDoubleCoverageCII.loadExcludingSite();
    static List<Nmer> nmerList = new ArrayList<Nmer>();

    public static void main(String[] args) throws Exception {
        String exon = args[0];
        File rulesetDir = new File(args[1]);
        int nmerSize = new Integer(args[2]);
        File nMerFile = new File(args[3]);
        LinkedHashMap<String, String> uniqueDPA1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorDPA1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueDPB1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorDPB1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueDQA1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorDQA1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueDRB1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorDRB1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueDQB1Sequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorDQAB1equences = new LinkedHashMap<String, String>();
        File inputDPA1 = new File(rulesetDir, "DPA1-" + exon + ".fa");
        File inputDPB1 = new File(rulesetDir, "DPB1-" + exon + ".fa");
        File inputDQA1 = new File(rulesetDir, "DQA1-" + exon + ".fa");
        File inputDQB1 = new File(rulesetDir, "DQB1-" + exon + ".fa");
        File inputDRB1 = new File(rulesetDir, "DRB1-" + exon + ".fa");
        PickingNmersForDoubleCoverageCII.loadAllSequence(inputDPA1, "DPA1", uniqueDPA1Sequences, majorDPA1Sequences);
        PickingNmersForDoubleCoverageCII.loadAllSequence(inputDPB1, "DPB1", uniqueDPB1Sequences, majorDPB1Sequences);
        PickingNmersForDoubleCoverageCII.loadAllSequence(inputDQA1, "DQA1", uniqueDQA1Sequences, majorDQA1Sequences);
        PickingNmersForDoubleCoverageCII.loadAllSequence(inputDQB1, "DQB1", uniqueDQB1Sequences, majorDQAB1equences);
        PickingNmersForDoubleCoverageCII.loadAllSequence(inputDRB1, "DRB", uniqueDRB1Sequences, majorDRB1Sequences);
        System.out.println("uniqueDPA1Sequences.size=" + uniqueDPA1Sequences.size());
        System.out.println("uniqueDPB1Sequences.size=" + uniqueDPB1Sequences.size());
        System.out.println("uniqueDQA1Sequences.size=" + uniqueDQA1Sequences.size());
        System.out.println("uniqueDQB1Sequences.size=" + uniqueDQB1Sequences.size());
        System.out.println("uniqueDRB1Sequences.size=" + uniqueDRB1Sequences.size());
        PickingNmersForDoubleCoverageForBC.parseNmerFile(nMerFile);
        Map<String, Integer> coverageDPA1 = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueDPA1Sequences, "DPA1-" + exon.replace("exon", ""));
        Map<String, Integer> coverageDPB1 = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueDPB1Sequences, "DPB1-" + exon.replace("exon", ""));
        Map<String, Integer> coverageDQA1 = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueDQA1Sequences, "DQA1-" + exon.replace("exon", ""));
        Map<String, Integer> coverageDQB1 = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueDQB1Sequences, "DQB1-" + exon.replace("exon", ""));
        Map<String, Integer> coverageDRB = PickingNmersForDoubleCoverageForBC.checkCoverage(uniqueDRB1Sequences, "DRB1-" + exon.replace("exon", ""));
        Map<String, String> singleCoverageDPA1sequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueDPA1Sequences, coverageDPA1);
        Map<String, String> singleCoverageDPB1sequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueDPB1Sequences, coverageDPB1);
        Map<String, String> singleCoverageDQA1sequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueDQA1Sequences, coverageDQA1);
        Map<String, String> singleCoverageDQB1sequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueDQB1Sequences, coverageDQB1);
        Map<String, String> singleCoverageDRB1sequence = PickingNmersForDoubleCoverageForBC.getSingleCoverageSequence(uniqueDRB1Sequences, coverageDRB);
    }

    private static List<Integer> loadExcludingSite() {
        ArrayList<Integer> excludingSite = new ArrayList<Integer>();
        excludingSite.add(12);
        excludingSite.add(23);
        return excludingSite;
    }

    public static List<Nmer> constructNmers(Map<String, String> majorSequences, int nmerSize, List<Map<String, String>> otherUniqueSequences, int offset) {
        ArrayList<Nmer> nMerList = new ArrayList<Nmer>();
        ArrayList<String> nMerSeq = new ArrayList<String>();
        for (String name : majorSequences.keySet()) {
            String seq = majorSequences.get(name);
            int i = offset;
            while (i <= seq.length() - nmerSize - offset) {
                Nmer nMer = new Nmer(seq.substring(i, i + nmerSize), i + 1);
                if (!(nMer.getSequence().indexOf("X") >= 0 || PickingNmersForDoubleCoverageCII.inExcludingRange(i + 1) || nMerSeq.contains(nMer.getSequence()) || PickingNmersForDoubleCoverageCII.findMatch(nMer.getSequence(), otherUniqueSequences))) {
                    nMerList.add(nMer);
                    nMerSeq.add(nMer.getSequence());
                }
                ++i;
            }
        }
        System.out.println("nMerList.size()=" + nMerList.size());
        return nMerList;
    }

    private static boolean inExcludingRange(int position) {
        for (Integer exPos : excludingSite) {
            if (position <= exPos - 30 || position >= exPos + 30) continue;
            return true;
        }
        return false;
    }

    private static boolean findMatch(String nmer, List<Map<String, String>> uniqueSequences) {
        for (Map<String, String> seqMap : uniqueSequences) {
            for (String name : seqMap.keySet()) {
                if (seqMap.get(name).indexOf(nmer) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private static String revComp(String seq) {
        String revcomp = new StringBuilder(seq.replace('A', 'B').replace('T', 'A').replace('B', 'T').replace('C', 'D').replace('G', 'C').replace('D', 'G')).reverse().toString();
        return revcomp;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> uniqueSequences, Map<String, String> majorSequenceNames) {
        Map<String, String> sequences = PickingNmersForDoubleCoverageCII.getSequences(input, header);
        System.out.println("sequences.size=" + sequences.size());
        ArrayList<String> majorGroupNameList = new ArrayList<String>();
        ArrayList<String> majorGroupSequenceList = new ArrayList<String>();
        LinkedHashMap<String, String> seqToName = new LinkedHashMap<String, String>();
        for (String name : sequences.keySet()) {
            if (seqToName.containsKey(sequences.get(name))) {
                String collectionName = String.valueOf((String)seqToName.get(sequences.get(name))) + "," + name;
                seqToName.put(sequences.get(name), collectionName);
            } else {
                seqToName.put(sequences.get(name), name);
            }
            String majorGroup = name.split("\\:")[0];
            if (majorGroupNameList.contains(majorGroup) || majorGroupSequenceList.contains(sequences.get(name))) continue;
            majorSequenceNames.put(name, sequences.get(name));
            majorGroupNameList.add(majorGroup);
            majorGroupSequenceList.add(sequences.get(name));
        }
        for (String seq : seqToName.keySet()) {
            uniqueSequences.put((String)seqToName.get(seq), seq);
        }
    }

    private static Map<String, String> getSequences(File fastaFile, String header) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">" + header)) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

