/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import ruleset.Nmer;
import ruleset.PickingNmersForBridge23;

public class PickingNmersForDoubleCoverage {
    static List<Integer> excludingSite = PickingNmersForDoubleCoverage.loadExcludingSite();
    static List<Nmer> nmerList = new ArrayList<Nmer>();

    public static void main(String[] args) throws Exception {
        String exon = args[0];
        File rulesetDir = new File(args[1]);
        int nmerSize = new Integer(args[2]);
        File nMerFile = new File(args[3]);
        LinkedHashMap<String, String> uniqueASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueCSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorCSequences = new LinkedHashMap<String, String>();
        File inputA = new File(rulesetDir, "A-" + exon + ".fa");
        File inputB = new File(rulesetDir, "B-" + exon + ".fa");
        File inputC = new File(rulesetDir, "C-" + exon + ".fa");
        PickingNmersForDoubleCoverage.loadAllSequence(inputA, "A", uniqueASequences, majorASequences);
        PickingNmersForDoubleCoverage.loadAllSequence(inputB, "B", uniqueBSequences, majorBSequences);
        PickingNmersForDoubleCoverage.loadAllSequence(inputC, "C", uniqueCSequences, majorCSequences);
        PickingNmersForDoubleCoverage.parseNmerFile(nMerFile);
        System.out.println("A uniqueASequences.size=" + uniqueASequences.size());
        System.out.println("B uniqueBSequences.size=" + uniqueBSequences.size());
        System.out.println("C uniqueCSequences.size=" + uniqueCSequences.size());
        Map<String, Integer> coverageA = PickingNmersForDoubleCoverage.checkCoverage(uniqueASequences, "A-" + exon.replace("exon", ""));
        Map<String, Integer> coverageB = PickingNmersForDoubleCoverage.checkCoverage(uniqueBSequences, "B-" + exon.replace("exon", ""));
        Map<String, Integer> coverageC = PickingNmersForDoubleCoverage.checkCoverage(uniqueCSequences, "C-" + exon.replace("exon", ""));
        Map<String, String> singleCoverageAsequence = PickingNmersForDoubleCoverage.getSingleCoverageSequence(uniqueASequences, coverageA);
        Map<String, String> singleCoverageBsequence = PickingNmersForDoubleCoverage.getSingleCoverageSequence(uniqueBSequences, coverageB);
        Map<String, String> singleCoverageCsequence = PickingNmersForDoubleCoverage.getSingleCoverageSequence(uniqueCSequences, coverageC);
        List<Nmer> nMerListA = PickingNmersForDoubleCoverage.constructNmers(singleCoverageAsequence, nmerSize, uniqueBSequences, uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordA = PickingNmersForBridge23.recordMatches(nMerListA, singleCoverageAsequence);
        Map<Nmer, List<String>> fullCoverageMapA = PickingNmersForBridge23.computeFullCoveragePath(matchRecordA, singleCoverageAsequence, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for A = " + fullCoverageMapA.size());
        for (Nmer nmer : fullCoverageMapA.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapA.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverage.revComp(nmer.getSequence()) + "\t" + fullCoverageMapA.get(nmer).toString());
        }
        List<Nmer> nMerListB = PickingNmersForDoubleCoverage.constructNmers(singleCoverageBsequence, nmerSize, uniqueASequences, uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordB = PickingNmersForBridge23.recordMatches(nMerListB, singleCoverageBsequence);
        Map<Nmer, List<String>> fullCoverageMapB = PickingNmersForBridge23.computeFullCoveragePath(matchRecordB, singleCoverageBsequence, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for B = " + fullCoverageMapB.size());
        for (Nmer nmer : fullCoverageMapB.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapB.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverage.revComp(nmer.getSequence()) + "\t" + fullCoverageMapB.get(nmer).toString());
        }
        List<Nmer> nMerListC = PickingNmersForDoubleCoverage.constructNmers(singleCoverageCsequence, nmerSize, uniqueASequences, uniqueBSequences, 0);
        Map<Nmer, List<String>> matchRecordC = PickingNmersForBridge23.recordMatches(nMerListC, singleCoverageCsequence);
        Map<Nmer, List<String>> fullCoverageMapC = PickingNmersForBridge23.computeFullCoveragePath(matchRecordC, singleCoverageCsequence, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for C = " + fullCoverageMapC.size());
        for (Nmer nmer : fullCoverageMapC.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapC.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForDoubleCoverage.revComp(nmer.getSequence()) + "\t" + fullCoverageMapC.get(nmer).toString());
        }
    }

    private static Map<String, String> getSingleCoverageSequence(Map<String, String> uniqueSequences, Map<String, Integer> coverage) {
        HashMap<String, String> sequences = new HashMap<String, String>();
        for (String name : uniqueSequences.keySet()) {
            if (coverage.get(name) >= 2) continue;
            sequences.put(name, uniqueSequences.get(name));
        }
        return sequences;
    }

    private static Map<String, Integer> checkCoverage(Map<String, String> uniqueSequences, String locusExon) {
        HashMap<String, Integer> coverage = new HashMap<String, Integer>();
        for (String name : uniqueSequences.keySet()) {
            String seq = uniqueSequences.get(name);
            int count = 0;
            for (Nmer nmer : nmerList) {
                if (!nmer.getDestination().get(0).equals(locusExon) || seq.indexOf(nmer.getSequence()) <= -1) continue;
                ++count;
            }
            coverage.put(name, count);
        }
        int multiCoveredCount = 0;
        int singleCount = 0;
        int noCoverageCount = 0;
        for (Integer count : coverage.values()) {
            if (count > 1) {
                ++multiCoveredCount;
                continue;
            }
            if (count == 1) {
                ++singleCount;
                continue;
            }
            if (count != 0) continue;
            ++noCoverageCount;
        }
        System.out.println(String.valueOf(locusExon) + " uniqueSequences.size=" + uniqueSequences.size() + " multiCoveredCount=" + multiCoveredCount + " singleCount=" + singleCount + " noCoverageCount=" + noCoverageCount);
        return coverage;
    }

    private static List<Integer> loadExcludingSite() {
        ArrayList<Integer> excludingSite = new ArrayList<Integer>();
        return excludingSite;
    }

    private static void parseNmerFile(File file) throws IOException {
        String[] nmerInfo;
        String[] stringArray = nmerInfo = FileManager.readTextFile(file).split("\n");
        int n = nmerInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split(",");
            if (line.trim().length() != 0 && items.length >= 4 && items[0].trim().length() != 0) {
                String[] dests;
                Nmer nmer = new Nmer(items[0].trim(), items[2].trim(), Integer.valueOf(items[1]));
                String[] stringArray2 = dests = items[3].trim().split("/");
                int n3 = dests.length;
                int n4 = 0;
                while (n4 < n3) {
                    String dest = stringArray2[n4];
                    nmer.getDestination().add(dest);
                    ++n4;
                }
                nmerList.add(nmer);
            }
            ++n2;
        }
    }

    public static List<Nmer> constructNmers(Map<String, String> majorSequences, int nmerSize, Map<String, String> otherUniqueSequences1, Map<String, String> otherUniqueSequences2, int offset) {
        ArrayList<Nmer> nMerList = new ArrayList<Nmer>();
        ArrayList<String> nMerSeq = new ArrayList<String>();
        for (String name : majorSequences.keySet()) {
            String seq = majorSequences.get(name);
            int i = offset;
            while (i <= seq.length() - nmerSize - offset) {
                Nmer nMer = new Nmer(seq.substring(i, i + nmerSize), i + 1);
                if (!(nMer.getSequence().indexOf("X") >= 0 || PickingNmersForDoubleCoverage.inNmerList(nMer.getSequence()) || nMerSeq.contains(nMer.getSequence()) || PickingNmersForDoubleCoverage.findMatch(nMer.getSequence(), otherUniqueSequences1) || PickingNmersForDoubleCoverage.findMatch(nMer.getSequence(), otherUniqueSequences2))) {
                    nMerList.add(nMer);
                    nMerSeq.add(nMer.getSequence());
                }
                ++i;
            }
        }
        System.out.println("nMerList.size()=" + nMerList.size());
        return nMerList;
    }

    private static boolean inNmerList(String sequence) {
        for (Nmer nmer : nmerList) {
            if (!nmer.getSequence().equals(sequence)) continue;
            return true;
        }
        return false;
    }

    private static boolean findMatch(String nmer, Map<String, String> uniqueSequences) {
        for (String name : uniqueSequences.keySet()) {
            if (uniqueSequences.get(name).indexOf(nmer) <= -1) continue;
            return true;
        }
        return false;
    }

    private static boolean inExcludingRange(int position) {
        for (Integer exPos : excludingSite) {
            if (position <= exPos - 30 || position >= exPos + 30) continue;
            return true;
        }
        return false;
    }

    private static String revComp(String seq) {
        String revcomp = new StringBuilder(seq.replace('A', 'B').replace('T', 'A').replace('B', 'T').replace('C', 'D').replace('G', 'C').replace('D', 'G')).reverse().toString();
        return revcomp;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> uniqueSequences, Map<String, String> majorSequenceNames) {
        Map<String, String> sequences = PickingNmersForDoubleCoverage.getSequences(input, header);
        System.out.println(String.valueOf(input.getName()) + " sequences.size=" + sequences.size());
        ArrayList<String> majorGroupNameList = new ArrayList<String>();
        ArrayList<String> majorGroupSequenceList = new ArrayList<String>();
        LinkedHashMap<String, String> seqToName = new LinkedHashMap<String, String>();
        for (String name : sequences.keySet()) {
            if (seqToName.containsKey(sequences.get(name))) {
                String collectionName = String.valueOf((String)seqToName.get(sequences.get(name))) + "," + name;
                seqToName.put(sequences.get(name), collectionName);
            } else {
                seqToName.put(sequences.get(name), name);
            }
            String majorGroup = name.split("\\:")[0];
            if (majorGroupNameList.contains(majorGroup) || majorGroupSequenceList.contains(sequences.get(name))) continue;
            majorSequenceNames.put(name, sequences.get(name));
            majorGroupNameList.add(majorGroup);
            majorGroupSequenceList.add(sequences.get(name));
        }
        for (String seq : seqToName.keySet()) {
            uniqueSequences.put((String)seqToName.get(seq), seq);
        }
    }

    private static Map<String, String> getSequences(File fastaFile, String header) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">" + header)) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

