/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import ruleset.Nmer;

public class PickingNmersForBridge23 {
    static int ROUND_1_PICK_NUM_1 = 12;
    static int ROUND_1_PICK_NUM_2 = 5;
    static int ROUND_1_PICK_NUM_3 = 5;

    public static void main(String[] args) throws Exception {
        String exon = args[0];
        File rulesetDir = new File(args[1]);
        int nmerSize = new Integer(args[2]);
        LinkedHashMap<String, String> uniqueASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueCSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorCSequences = new LinkedHashMap<String, String>();
        File inputA = new File(rulesetDir, "A-" + exon + ".fa");
        File inputB = new File(rulesetDir, "B-" + exon + ".fa");
        File inputC = new File(rulesetDir, "C-" + exon + ".fa");
        PickingNmersForBridge23.loadAllSequence(inputA, "A", uniqueASequences, majorASequences);
        PickingNmersForBridge23.loadAllSequence(inputB, "B", uniqueBSequences, majorBSequences);
        PickingNmersForBridge23.loadAllSequence(inputC, "C", uniqueCSequences, majorCSequences);
        System.out.println("uniqueASequences.size=" + uniqueASequences.size());
        System.out.println("uniqueBSequences.size=" + uniqueBSequences.size());
        System.out.println("uniqueCSequences.size=" + uniqueCSequences.size());
        ArrayList<String> uncoveredBList = new ArrayList<String>();
        uncoveredBList.addAll(uniqueBSequences.keySet());
        ArrayList<String> uncoveredCList = new ArrayList<String>();
        uncoveredCList.addAll(uniqueCSequences.keySet());
        LinkedHashMap<String, String> uncoveredSequencesB = new LinkedHashMap<String, String>();
        PickingNmersForBridge23.addUncoveredSeq(uncoveredSequencesB, uniqueBSequences, uncoveredBList);
        LinkedHashMap<String, String> uncoveredSequencesC = new LinkedHashMap<String, String>();
        PickingNmersForBridge23.addUncoveredSeq(uncoveredSequencesC, uniqueCSequences, uncoveredCList);
        int i = 1;
        while (i < 6) {
            List<Nmer> nMerListB = PickingNmersForBridge23.constructNmers(uncoveredSequencesB, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesC, 60);
            Map<Nmer, List<String>> matchRecordB = PickingNmersForBridge23.recordMatches(nMerListB, uncoveredSequencesB);
            uncoveredBList.clear();
            Map<Nmer, List<String>> fullCoverageMapB = PickingNmersForBridge23.computeFullCoveragePath(matchRecordB, uncoveredSequencesB, uncoveredBList, i);
            System.out.println("number of Nmer for B = " + fullCoverageMapB.size());
            for (Nmer nmer : fullCoverageMapB.keySet()) {
                System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapB.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForBridge23.revComp(nmer.getSequence()) + "\t" + fullCoverageMapB.get(nmer).toString());
            }
            uncoveredSequencesB = new LinkedHashMap();
            PickingNmersForBridge23.addUncoveredSeq(uncoveredSequencesB, uniqueBSequences, uncoveredBList);
            List<Nmer> nMerListC = PickingNmersForBridge23.constructNmers(uncoveredSequencesC, nmerSize, new LinkedHashMap<String, String>(), uncoveredSequencesB, 60);
            Map<Nmer, List<String>> matchRecordC = PickingNmersForBridge23.recordMatches(nMerListC, uncoveredSequencesC);
            uncoveredCList.clear();
            Map<Nmer, List<String>> fullCoverageMapC = PickingNmersForBridge23.computeFullCoveragePath(matchRecordC, uncoveredSequencesC, uncoveredCList, i);
            System.out.println("number of Nmer for C = " + fullCoverageMapC.size());
            for (Nmer nmer : fullCoverageMapC.keySet()) {
                System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapC.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmersForBridge23.revComp(nmer.getSequence()) + "\t" + fullCoverageMapC.get(nmer).toString());
            }
            uncoveredSequencesC = new LinkedHashMap();
            PickingNmersForBridge23.addUncoveredSeq(uncoveredSequencesC, uniqueCSequences, uncoveredCList);
            ++i;
        }
    }

    private static String revComp(String seq) {
        String revcomp = new StringBuilder(seq.replace('A', 'B').replace('T', 'A').replace('B', 'T').replace('C', 'D').replace('G', 'C').replace('D', 'G')).reverse().toString();
        return revcomp;
    }

    private static void addUncoveredSeq(Map<String, String> uncoveredSequences, Map<String, String> uniqueSequences, List<String> uncoveredList) {
        for (String name : uncoveredList) {
            uncoveredSequences.put(name, uniqueSequences.get(name));
        }
    }

    public static Map<Nmer, List<String>> computeFullCoveragePath(Map<Nmer, List<String>> matchRecord, Map<String, String> uniqueSequences, List<String> uncoveredList, int round) {
        int limit = 5;
        if (round == 1) {
            limit = ROUND_1_PICK_NUM_1;
        }
        if (round == 2) {
            limit = ROUND_1_PICK_NUM_2;
        }
        if (round == 3) {
            limit = ROUND_1_PICK_NUM_3;
        }
        LinkedHashMap<Nmer, List<String>> fullCoverageMap = new LinkedHashMap<Nmer, List<String>>();
        uncoveredList.addAll(uniqueSequences.keySet());
        int i = 0;
        while (i < matchRecord.size()) {
            if (uncoveredList.size() == 0) break;
            Nmer bestNmer = null;
            List<String> maxCoverage = new ArrayList<String>();
            for (Nmer nmer : matchRecord.keySet()) {
                List<String> affectiveCoverage;
                if (fullCoverageMap.containsKey(nmer) || (affectiveCoverage = PickingNmersForBridge23.getAffectiveCoverage(matchRecord.get(nmer), uncoveredList)).size() <= maxCoverage.size()) continue;
                maxCoverage = affectiveCoverage;
                bestNmer = nmer;
            }
            if (bestNmer != null) {
                fullCoverageMap.put(bestNmer, matchRecord.get(bestNmer));
                PickingNmersForBridge23.updateUncoverList(maxCoverage, uncoveredList);
            }
            if (fullCoverageMap.size() >= limit) break;
            ++i;
        }
        System.out.println("total type covered: " + (uniqueSequences.size() - uncoveredList.size()) + ", uncovered: " + uncoveredList.size() + " " + uncoveredList.toString());
        if (round == 2) {
            System.out.println(uncoveredList.toString());
        }
        return fullCoverageMap;
    }

    private static void updateUncoverList(List<String> maxCoverage, List<String> uncoveredList) {
        Iterator<String> it = uncoveredList.iterator();
        while (it.hasNext()) {
            String t = it.next();
            if (!maxCoverage.contains(t)) continue;
            it.remove();
        }
    }

    private static List<String> getAffectiveCoverage(List<String> coverage, List<String> uncoveredList) {
        ArrayList<String> thisCoverage = new ArrayList<String>();
        for (String name : coverage) {
            if (!uncoveredList.contains(name)) continue;
            thisCoverage.add(name);
        }
        return thisCoverage;
    }

    public static Map<Nmer, List<String>> recordMatches(List<Nmer> nMerList, Map<String, String> uniqueSequences) {
        LinkedHashMap<Nmer, List<String>> matchRecord = new LinkedHashMap<Nmer, List<String>>();
        for (Nmer nmer : nMerList) {
            matchRecord.put(nmer, new ArrayList());
            for (String name : uniqueSequences.keySet()) {
                if (uniqueSequences.get(name).indexOf(nmer.getSequence()) <= -1) continue;
                ((List)matchRecord.get(nmer)).add(name);
            }
        }
        return matchRecord;
    }

    private static boolean findMatch(String nmer, Map<String, String> uniqueSequences) {
        for (String name : uniqueSequences.keySet()) {
            if (uniqueSequences.get(name).indexOf(nmer) <= -1) continue;
            return true;
        }
        return false;
    }

    public static List<Nmer> constructNmers(Map<String, String> majorSequences, int nmerSize, Map<String, String> otherUniqueSequences1, Map<String, String> otherUniqueSequences2, int offset) {
        ArrayList<Nmer> nMerList = new ArrayList<Nmer>();
        ArrayList<String> nMerSeq = new ArrayList<String>();
        for (String name : majorSequences.keySet()) {
            String seq = majorSequences.get(name);
            int i = offset;
            while (i <= seq.length() - nmerSize - offset) {
                Nmer nMer = new Nmer(seq.substring(i, i + nmerSize), i + 1);
                if (!(nMer.getSequence().indexOf("X") >= 0 || nMerSeq.contains(nMer.getSequence()) || PickingNmersForBridge23.findMatch(nMer.getSequence(), otherUniqueSequences1) || PickingNmersForBridge23.findMatch(nMer.getSequence(), otherUniqueSequences2))) {
                    nMerList.add(nMer);
                    nMerSeq.add(nMer.getSequence());
                }
                ++i;
            }
        }
        System.out.println("nMerList.size()=" + nMerList.size());
        return nMerList;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> uniqueSequences, Map<String, String> majorSequenceNames) {
        Map<String, String> sequences = PickingNmersForBridge23.getSequences(input, header);
        System.out.println("sequences.size=" + sequences.size());
        ArrayList<String> majorGroupNameList = new ArrayList<String>();
        ArrayList<String> majorGroupSequenceList = new ArrayList<String>();
        LinkedHashMap<String, String> seqToName = new LinkedHashMap<String, String>();
        for (String name : sequences.keySet()) {
            if (seqToName.containsKey(sequences.get(name))) {
                String collectionName = String.valueOf((String)seqToName.get(sequences.get(name))) + "," + name;
                seqToName.put(sequences.get(name), collectionName);
            } else {
                seqToName.put(sequences.get(name), name);
            }
            String majorGroup = name.split("\\:")[0];
            if (majorGroupNameList.contains(majorGroup) || majorGroupSequenceList.contains(sequences.get(name))) continue;
            majorSequenceNames.put(name, sequences.get(name));
            majorGroupNameList.add(majorGroup);
            majorGroupSequenceList.add(sequences.get(name));
        }
        for (String seq : seqToName.keySet()) {
            uniqueSequences.put((String)seqToName.get(seq), seq);
        }
    }

    private static Map<String, String> getSequences(File fastaFile, String header) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">" + header)) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

