/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import ruleset.Nmer;
import ruleset.PickingNmersForBridge23;

public class PickingNmers {
    static List<Integer> excludingSite = PickingNmers.loadExcludingSite();

    public static void main(String[] args) throws Exception {
        String exon = args[0];
        File rulesetDir = new File(args[1]);
        int nmerSize = new Integer(args[2]);
        LinkedHashMap<String, String> uniqueASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorASequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorBSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> uniqueCSequences = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> majorCSequences = new LinkedHashMap<String, String>();
        File inputA = new File(rulesetDir, "A-" + exon + ".fa");
        File inputB = new File(rulesetDir, "B-" + exon + ".fa");
        File inputC = new File(rulesetDir, "C-" + exon + ".fa");
        PickingNmers.loadAllSequence(inputA, "A", uniqueASequences, majorASequences);
        PickingNmers.loadAllSequence(inputB, "B", uniqueBSequences, majorBSequences);
        PickingNmers.loadAllSequence(inputC, "C", uniqueCSequences, majorCSequences);
        System.out.println("uniqueASequences.size=" + uniqueASequences.size());
        System.out.println("uniqueBSequences.size=" + uniqueBSequences.size());
        System.out.println("uniqueCSequences.size=" + uniqueCSequences.size());
        List<Nmer> nMerListA = PickingNmers.constructNmers(uniqueASequences, nmerSize, uniqueBSequences, uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordA = PickingNmersForBridge23.recordMatches(nMerListA, uniqueASequences);
        Map<Nmer, List<String>> fullCoverageMapA = PickingNmersForBridge23.computeFullCoveragePath(matchRecordA, uniqueASequences, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for A = " + fullCoverageMapA.size());
        for (Nmer nmer : fullCoverageMapA.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapA.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmers.revComp(nmer.getSequence()) + "\t" + fullCoverageMapA.get(nmer).toString());
        }
        List<Nmer> nMerListB = PickingNmers.constructNmers(uniqueBSequences, nmerSize, uniqueASequences, uniqueCSequences, 0);
        Map<Nmer, List<String>> matchRecordB = PickingNmersForBridge23.recordMatches(nMerListB, uniqueBSequences);
        Map<Nmer, List<String>> fullCoverageMapB = PickingNmersForBridge23.computeFullCoveragePath(matchRecordB, uniqueBSequences, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for B = " + fullCoverageMapB.size());
        for (Nmer nmer : fullCoverageMapB.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapB.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmers.revComp(nmer.getSequence()) + "\t" + fullCoverageMapB.get(nmer).toString());
        }
        List<Nmer> nMerListC = PickingNmers.constructNmers(uniqueCSequences, nmerSize, uniqueASequences, uniqueBSequences, 0);
        Map<Nmer, List<String>> matchRecordC = PickingNmersForBridge23.recordMatches(nMerListC, uniqueCSequences);
        Map<Nmer, List<String>> fullCoverageMapC = PickingNmersForBridge23.computeFullCoveragePath(matchRecordC, uniqueCSequences, new ArrayList<String>(), 1);
        System.out.println("number of Nmer for C = " + fullCoverageMapC.size());
        for (Nmer nmer : fullCoverageMapC.keySet()) {
            System.out.println(String.valueOf(nmer.getSequence()) + "\tHit=" + fullCoverageMapC.get(nmer).size() + " position=" + nmer.getPosition() + "\trevcomp\t" + PickingNmers.revComp(nmer.getSequence()) + "\t" + fullCoverageMapC.get(nmer).toString());
        }
    }

    private static List<Integer> loadExcludingSite() {
        ArrayList<Integer> excludingSite = new ArrayList<Integer>();
        excludingSite.add(58);
        excludingSite.add(62);
        excludingSite.add(1);
        return excludingSite;
    }

    public static List<Nmer> constructNmers(Map<String, String> majorSequences, int nmerSize, Map<String, String> otherUniqueSequences1, Map<String, String> otherUniqueSequences2, int offset) {
        ArrayList<Nmer> nMerList = new ArrayList<Nmer>();
        ArrayList<String> nMerSeq = new ArrayList<String>();
        for (String name : majorSequences.keySet()) {
            String seq = majorSequences.get(name);
            int i = offset;
            while (i <= seq.length() - nmerSize - offset) {
                Nmer nMer = new Nmer(seq.substring(i, i + nmerSize), i + 1);
                if (!(nMer.getSequence().indexOf("X") >= 0 || PickingNmers.inExcludingRange(i + 1) || nMerSeq.contains(nMer.getSequence()) || PickingNmers.findMatch(nMer.getSequence(), otherUniqueSequences1) || PickingNmers.findMatch(nMer.getSequence(), otherUniqueSequences2))) {
                    nMerList.add(nMer);
                    nMerSeq.add(nMer.getSequence());
                }
                ++i;
            }
        }
        System.out.println("nMerList.size()=" + nMerList.size());
        return nMerList;
    }

    private static boolean findMatch(String nmer, Map<String, String> uniqueSequences) {
        for (String name : uniqueSequences.keySet()) {
            if (uniqueSequences.get(name).indexOf(nmer) <= -1) continue;
            return true;
        }
        return false;
    }

    private static boolean inExcludingRange(int position) {
        for (Integer exPos : excludingSite) {
            if (position <= exPos - 30 || position >= exPos + 30) continue;
            return true;
        }
        return false;
    }

    private static String revComp(String seq) {
        String revcomp = new StringBuilder(seq.replace('A', 'B').replace('T', 'A').replace('B', 'T').replace('C', 'D').replace('G', 'C').replace('D', 'G')).reverse().toString();
        return revcomp;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> uniqueSequences, Map<String, String> majorSequenceNames) {
        Map<String, String> sequences = PickingNmers.getSequences(input, header);
        System.out.println("sequences.size=" + sequences.size());
        ArrayList<String> majorGroupNameList = new ArrayList<String>();
        ArrayList<String> majorGroupSequenceList = new ArrayList<String>();
        LinkedHashMap<String, String> seqToName = new LinkedHashMap<String, String>();
        for (String name : sequences.keySet()) {
            if (seqToName.containsKey(sequences.get(name))) {
                String collectionName = String.valueOf((String)seqToName.get(sequences.get(name))) + "," + name;
                seqToName.put(sequences.get(name), collectionName);
            } else {
                seqToName.put(sequences.get(name), name);
            }
            String majorGroup = name.split("\\:")[0];
            if (majorGroupNameList.contains(majorGroup) || majorGroupSequenceList.contains(sequences.get(name))) continue;
            majorSequenceNames.put(name, sequences.get(name));
            majorGroupNameList.add(majorGroup);
            majorGroupSequenceList.add(sequences.get(name));
        }
        for (String seq : seqToName.keySet()) {
            uniqueSequences.put((String)seqToName.get(seq), seq);
        }
    }

    private static Map<String, String> getSequences(File fastaFile, String header) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">" + header)) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

