/*
 * Decompiled with CFR 0.152.
 */
package ruleset;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class CheckIntronEnd {
    private static final String EXT = "_gen.txt";

    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().endsWith(EXT)) {
                String gene = input.getName().replace(EXT, "");
                System.out.println("Work on gene " + gene + " " + input.getName());
                LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
                CheckIntronEnd.loadAllSequence(input, gene, seq);
                Map<String, String> actualSeq = CheckIntronEnd.translateExons(seq);
                CheckIntronEnd.writeSeqFiles(actualSeq, gene);
            }
            ++n2;
        }
    }

    private static void writeSeqFiles(Map<String, String> actualSeqs, String header) {
        String headerSeq = "";
        Iterator<String> iterator = actualSeqs.keySet().iterator();
        if (iterator.hasNext()) {
            String seq;
            String type = iterator.next();
            headerSeq = seq = actualSeqs.get(type);
        }
        int exonCount = headerSeq.split("\\|").length;
        int number = 0;
        while (number < exonCount) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            CheckIntronEnd.writeExonFastaFile(actualSeqs, header, number, map, headerSeq);
            number += 2;
        }
    }

    public static void writeExonFastaFile(Map<String, String> actualSeqs, String header, int number, Map<String, String> map, String headerSeq) {
        String anchor = headerSeq.split("\\|")[number].replaceAll("\\.", "").replaceAll("\\*", "N");
        String commonStart = anchor.substring(0, 2);
        String commonEnd = anchor.substring(anchor.length() - 2, anchor.length());
        System.out.println(anchor);
        System.out.println(String.valueOf(header) + " blockNumber=" + number + " start=" + commonStart + " end=" + commonEnd);
        for (String name : actualSeqs.keySet()) {
            String s;
            if (actualSeqs.get(name).split("\\|").length <= number) {
                System.out.println(String.valueOf(name) + " not exist block " + number);
                System.out.println(actualSeqs.get(name));
            }
            if ((s = actualSeqs.get(name).split("\\|")[number].replaceAll("\\.", "").replaceAll("\\*", "N")).length() < 4) {
                System.out.println("Too short Skip " + name);
                continue;
            }
            String thisStart = s.substring(0, 2);
            String thisEnd = s.substring(s.length() - 2, s.length());
            if (!thisStart.equals("NN") && !thisStart.equals(commonStart)) {
                System.out.println("\t" + name + " start diff " + thisStart);
                System.out.println(s);
            }
            if (thisEnd.equals("NN") || thisEnd.equals(commonEnd)) continue;
            System.out.println("\t" + name + " end diff " + thisEnd);
            System.out.println(s);
        }
    }

    private static boolean allN(String s) {
        return s.replaceAll("N", "").length() == 0;
    }

    private static boolean mostlyN(String s) {
        int len = s.length();
        return (double)s.replaceAll("N", "").length() <= 0.25 * (double)len;
    }

    private static Map<String, String> translateExons(Map<String, String> seqs) {
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        String headerSeq = "";
        String anchorType = "";
        Iterator<String> iterator = seqs.keySet().iterator();
        if (iterator.hasNext()) {
            String type = iterator.next();
            String seq = seqs.get(type);
            System.out.println("Type = " + type);
            headerSeq = seq;
            anchorType = type;
            System.out.println("anchorType = " + anchorType);
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
        return actualSeq;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> seq) {
        String[] data;
        System.out.println("header = " + header);
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(!header.equals("DRB") ? line.trim().length() == 0 || !line.trim().startsWith(String.valueOf(header) + "*") : line.trim().length() == 0 || !line.trim().startsWith(header))) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }
}

