/*
 * Decompiled with CFR 0.152.
 */
package primerDesign;

import java.io.File;
import misc.FileManager;

public class GetBackbone {
    public static void main(String[] args) throws Exception {
        File primerFile = new File(args[0]);
        File backbone = new File(args[1]);
        File output = new File(args[2]);
        String[] lines = FileManager.readTextFile(primerFile).split("\n");
        String seq = GetBackbone.getSequenceFromFasta(backbone);
        StringBuilder builder = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\t");
                String fSeq = items[2].trim();
                String rSeq = items[4].trim();
                int fPos = seq.indexOf(fSeq);
                int rPos = seq.indexOf(GetBackbone.revComp(rSeq)) + rSeq.length();
                System.out.println(String.valueOf(items[1]) + " " + (rPos - fPos));
                builder.append(seq.subSequence(fPos, rPos)).append("\n");
            }
            ++n2;
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    public static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        seq.append(lines[0].trim()).append("\n");
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static String revComp(String seq) {
        StringBuilder builder = new StringBuilder();
        int i = seq.length() - 1;
        while (i >= 0) {
            builder.append(GetBackbone.complement(seq.charAt(i)));
            --i;
        }
        return builder.toString();
    }

    public static char complement(char base) {
        if (base == 'a' || base == 'A') {
            return 'T';
        }
        if (base == 't' || base == 'T') {
            return 'A';
        }
        if (base == 'c' || base == 'C') {
            return 'G';
        }
        if (base == 'g' || base == 'G') {
            return 'C';
        }
        if (base == 'n' || base == 'N') {
            return 'N';
        }
        return base;
    }
}

