/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;

public class uniformDirection {
    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File refFile = new File(args[1]);
        File outputDir = new File(args[2]);
        Object[] files = fastaDir.listFiles();
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).getName().endsWith("fasta")) {
                System.out.println("\t" + ((File)file).getName());
                LinkedHashMap<String, String> sequenceMap = new LinkedHashMap<String, String>();
                uniformDirection.getSequenceFromFasta((File)file, sequenceMap);
                File matchOutputFile = uniformDirection.runMatchSearch((File)file, refFile);
                Map<String, Boolean> direction = uniformDirection.parseCMresult(matchOutputFile);
                File correctedFile = new File(outputDir, ((File)file).getName());
                FileManager.writeTextFile(correctedFile, uniformDirection.getCorrectedSeq(sequenceMap, direction), true);
            }
            ++n2;
        }
    }

    private static String getCorrectedSeq(Map<String, String> sequenceMap, Map<String, Boolean> direction) {
        StringBuilder builder = new StringBuilder();
        for (String name : sequenceMap.keySet()) {
            builder.append(">").append(name).append("\n");
            if (direction.containsKey(name) && direction.get(name).booleanValue()) {
                builder.append(FileManager.revCompSeq(sequenceMap.get(name))).append("\n");
                continue;
            }
            builder.append(sequenceMap.get(name)).append("\n");
        }
        return builder.toString();
    }

    public static void getSequenceFromFasta(File fasta, Map<String, String> sequenceMap) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) {
                String[] items = lines[i].trim().substring(1).split("\\s+");
                String seqName = items[0];
                sequenceMap.put(seqName, lines[i + 1].trim());
            }
            ++i;
        }
    }

    public static Map<String, Boolean> parseCMresult(File matchResult) {
        String[] lines;
        HashMap<String, Boolean> direction = new HashMap<String, Boolean>();
        String[] stringArray = lines = FileManager.readTextFile(matchResult).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\\s+");
            if (line.indexOf("/ccs ") > 0 && items.length >= 12 && items[4].split("/").length == 3) {
                String readsName = items[4].trim();
                boolean isReverseComp = items[8].trim().equals("C");
                direction.put(readsName, isReverseComp);
            }
            ++n2;
        }
        return direction;
    }

    private static File runMatchSearch(File file, File refFile) throws Exception {
        File tempOutputFile = File.createTempFile("out", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/home/rwang/software/phrap/cross_match -minscore 100 " + file.getAbsolutePath() + " " + refFile.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }
}

