/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import pacBio.PrimerPair;

public class makeProbeFastas {
    public static void main(String[] args) throws Exception {
        File inputPrimerFasta = new File(args[0]);
        File outputProbFasta = new File(args[1]);
        Map<String, PrimerPair> primerPairMap = makeProbeFastas.getPrimerSeq(inputPrimerFasta);
        StringBuilder builder = new StringBuilder();
        for (String id : primerPairMap.keySet()) {
            builder.append(">").append(id);
            builder.append("\n");
            builder.append(primerPairMap.get(id).getForwardSeq());
            builder.append(FileManager.revCompSeq(primerPairMap.get(id).getReverseSeq()));
            builder.append("\n");
        }
        System.out.println(builder.toString());
        FileManager.writeTextFile(outputProbFasta, builder.toString(), true);
    }

    private static Map<String, PrimerPair> getPrimerSeq(File primerFasta) {
        LinkedHashMap<String, PrimerPair> primerPairMap = new LinkedHashMap<String, PrimerPair>();
        String[] lines = FileManager.readTextFile(primerFasta).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) {
                String seqName = lines[i].trim().substring(1);
                String primerSeq = lines[i + 1].trim();
                String id = null;
                id = seqName.startsWith("KIR") ? seqName.split("-")[0] : seqName.replace("-up", "").replace("-down", "");
                if (!primerPairMap.containsKey(id)) {
                    primerPairMap.put(id, new PrimerPair());
                    ((PrimerPair)primerPairMap.get(id)).setId(id);
                }
                if (seqName.endsWith("up")) {
                    ((PrimerPair)primerPairMap.get(id)).setForwardName(seqName);
                    ((PrimerPair)primerPairMap.get(id)).setForwardSeq(primerSeq);
                }
                if (seqName.endsWith("down")) {
                    ((PrimerPair)primerPairMap.get(id)).setReverseName(seqName);
                    ((PrimerPair)primerPairMap.get(id)).setReverseSeq(primerSeq);
                }
            }
            ++i;
        }
        return primerPairMap;
    }
}

