/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class SummerizeLaaAndCheck {
    public static void main(String[] args) throws Exception {
        File demultiplexFastaDir = new File(args[0]);
        File laaOutputDir = new File(args[1]);
        File countFile = new File(args[2]);
        File outputFile = new File(args[3]);
        File masterIndexFile = new File(args[4]);
        String prefix = args[5];
        Map<String, String> masterMap = SummerizeLaaAndCheck.getMasterList(masterIndexFile);
        Map<String, Integer> countMap = SummerizeLaaAndCheck.getCountMap(countFile);
        Map<String, Map<String, String>> fastaOutputMap = SummerizeLaaAndCheck.initMap();
        StringBuilder info = new StringBuilder();
        info.append("Amplicon,").append("ZMWcount,").append("Consensus,").append("SubreadsCount,").append("Size,").append("PredictedAccuracy,").append("IsDuplicate,").append("IsChimera").append("\n");
        Object[] amplicons = masterMap.keySet().toArray();
        Arrays.sort(amplicons);
        Object[] objectArray = amplicons;
        int n = amplicons.length;
        int n2 = 0;
        while (n2 < n) {
            Object ampliconName = objectArray[n2];
            int count = 0;
            if (countMap.containsKey(ampliconName)) {
                count = countMap.get(ampliconName);
            }
            info.append(ampliconName).append(",").append(count).append(",").append("\n");
            if (count < 10) {
                info.append("\n");
                System.out.println("Skip low count amplicon " + ampliconName + " " + count);
            } else {
                File fastaFile = SummerizeLaaAndCheck.getFastaFile(demultiplexFastaDir, (String)ampliconName);
                File laaOutputFile = SummerizeLaaAndCheck.getLaaFile(laaOutputDir, (String)ampliconName);
                if (fastaFile == null || laaOutputFile == null) {
                    System.out.println("Missing file " + ampliconName + " " + count);
                } else {
                    File laaSummaryFile = new File(laaOutputDir, ampliconName + "-amplicon_analysis_summary.csv");
                    List<String> collectedFastaNames = SummerizeLaaAndCheck.parseSummaryFile(laaSummaryFile, info, (String)ampliconName);
                    SummerizeLaaAndCheck.collectSequences((String)ampliconName, collectedFastaNames, laaOutputFile, fastaOutputMap);
                    info.append("\n");
                }
            }
            ++n2;
        }
        SummerizeLaaAndCheck.writeFinalFastaFilesByGene(fastaOutputMap, prefix, outputFile);
        FileManager.writeTextFile(outputFile, info.toString(), true);
    }

    private static void writeFinalFastaFilesByGene(Map<String, Map<String, String>> fastaOutputMap, String prefix, File outputFile) {
        File outputDir = outputFile.getParentFile();
        for (String gene : fastaOutputMap.keySet()) {
            Map<String, String> sequences = fastaOutputMap.get(gene);
            if (sequences.size() == 0) continue;
            File outputFasta = new File(outputDir, String.valueOf(prefix) + "-" + gene + ".fasta");
            System.out.println(String.valueOf(gene) + " " + outputFasta.getAbsolutePath());
            FileManager.writeFastaFile(outputFasta, sequences);
        }
    }

    private static void collectSequences(String ampliconName, List<String> collectedFastaNames, File laaOutputFile, Map<String, Map<String, String>> fastaOutputMap) {
        String thisRegion = null;
        for (String regionName : fastaOutputMap.keySet()) {
            if (!ampliconName.contains(regionName)) continue;
            thisRegion = regionName;
            break;
        }
        Map<String, String> regionSequences = fastaOutputMap.get(thisRegion);
        Map<String, String> allSequences = FileManager.getSequencesFromFastq(laaOutputFile);
        for (String name : collectedFastaNames) {
            String newName = String.valueOf(ampliconName) + "--" + name;
            regionSequences.put(newName, allSequences.get(name));
        }
    }

    private static Map<String, Map<String, String>> initMap() {
        LinkedHashMap<String, Map<String, String>> outputMap = new LinkedHashMap<String, Map<String, String>>();
        outputMap.put("RH", new LinkedHashMap());
        outputMap.put("FCGR2A", new LinkedHashMap());
        outputMap.put("FCGR2BC", new LinkedHashMap());
        outputMap.put("IGHG_A", new LinkedHashMap());
        outputMap.put("FCGR1AB", new LinkedHashMap());
        outputMap.put("FCGR3AB", new LinkedHashMap());
        outputMap.put("ACE2", new LinkedHashMap());
        return outputMap;
    }

    private static Map<String, Integer> getCountMap(File countFile) {
        String[] lines;
        LinkedHashMap<String, Integer> countMap = new LinkedHashMap<String, Integer>();
        String[] stringArray = lines = FileManager.readTextFile(countFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.split("\\s+");
                String ampliconName = items[0].trim();
                int count = Integer.valueOf(items[1].trim());
                countMap.put(ampliconName, count);
            }
            ++n2;
        }
        return countMap;
    }

    private static Map<String, String> getMasterList(File masterIndexFile) {
        Map<String, String> sequencesMap = FileManager.getSequencesFromFasta(masterIndexFile);
        return sequencesMap;
    }

    private static List<String> parseSummaryFile(File laaSummaryFile, StringBuilder info, String ampliconName) {
        ArrayList<String> collectedFastaNames = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(laaSummaryFile).split("\n");
        if (lines.length < 2) {
            info.append("\n");
            return collectedFastaNames;
        }
        int geneMax = SummerizeLaaAndCheck.getMax(ampliconName);
        int count = 0;
        int max = 0;
        int i = 1;
        while (i < lines.length) {
            String[] items = lines[i].split(",");
            int numReads = new Integer(items[4]);
            if (count < 2) {
                if (numReads > max) {
                    max = numReads;
                }
                ++count;
                SummerizeLaaAndCheck.logToInfo(items, info);
                collectedFastaNames.add(items[1]);
            } else if (numReads >= 50 && count <= geneMax && numReads * 5 >= max && new Integer(items[9]) <= 0 && new Integer(items[11]) <= 0) {
                ++count;
                SummerizeLaaAndCheck.logToInfo(items, info);
                collectedFastaNames.add(items[1]);
            }
            ++i;
        }
        return collectedFastaNames;
    }

    private static int getMax(String ampliconName) {
        if (ampliconName.contains("ACE2")) {
            return 20;
        }
        if (ampliconName.contains("IGHG_A")) {
            return 10;
        }
        return 8;
    }

    private static void logToInfo(String[] items, StringBuilder info) {
        info.append(",").append(",").append(items[1]).append(",").append(items[4]).append(",").append(items[5]).append(",").append(items[6]).append(",").append(items[9]).append(",").append(items[11]).append("\n");
    }

    private static File getLaaFile(File laaOutputDir, String ampliconName) {
        File[] laaFiles;
        File[] fileArray = laaFiles = laaOutputDir.listFiles();
        int n = laaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File laaFile = fileArray[n2];
            if (laaFile.getName().equals(String.valueOf(ampliconName) + "-amplicon_analyisis.fastq")) {
                return laaFile;
            }
            ++n2;
        }
        return null;
    }

    private static File getFastaFile(File demultiplexFastaDir, String ampliconName) {
        File[] demultiplexFastas;
        File[] fileArray = demultiplexFastas = demultiplexFastaDir.listFiles();
        int n = demultiplexFastas.length;
        int n2 = 0;
        while (n2 < n) {
            File demultiplexFasta = fileArray[n2];
            if (demultiplexFasta.getName().split("\\.")[1].split("--")[0].equals(ampliconName)) {
                return demultiplexFasta;
            }
            ++n2;
        }
        return null;
    }
}

