/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import pacBio.CanuResult;
import pacBio.Contig;
import pacBio.RemoveAmpicillin;

public class SummerizeCanuContigs {
    static int MIN_CHILDREN_COUNT = 5;

    public static void main(String[] args) throws Exception {
        File demultiplexFastaDir = new File(args[0]);
        File canuContigDir = new File(args[1]);
        File outputFile = new File(args[2]);
        Object[] demultiplexFastas = demultiplexFastaDir.listFiles();
        LinkedHashMap<String, CanuResult> canuResultsMap = new LinkedHashMap<String, CanuResult>();
        System.out.println(demultiplexFastas.length);
        Arrays.sort(demultiplexFastas);
        Object[] objectArray = demultiplexFastas;
        int n = demultiplexFastas.length;
        int n2 = 0;
        while (n2 < n) {
            Object demultiplexFasta = objectArray[n2];
            if (((File)demultiplexFasta).getName().endsWith("fasta")) {
                String fosmidName = ((File)demultiplexFasta).getName().replace(".fasta", "");
                canuResultsMap.put(fosmidName, new CanuResult(fosmidName));
                SummerizeCanuContigs.loadInputSeqInfo((File)demultiplexFasta, (CanuResult)canuResultsMap.get(fosmidName));
                SummerizeCanuContigs.loadCanuResults(canuContigDir, (CanuResult)canuResultsMap.get(fosmidName));
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, SummerizeCanuContigs.outputSummary(canuResultsMap), true);
    }

    private static String outputSummary(Map<String, CanuResult> canuResultsMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("fosmid").append(",").append("demultiplexCount").append(",").append("averageSeqLen").append("\n");
        builder.append("\t,tigID").append(",").append("tigLen").append(",").append("coverage").append(",").append("numChildren").append("\n");
        for (String fosmid : canuResultsMap.keySet()) {
            builder.append(fosmid).append(",").append(canuResultsMap.get(fosmid).getInputSeqCount()).append(",").append(canuResultsMap.get(fosmid).getAverageSeqLength()).append("\n");
            for (Contig contig : canuResultsMap.get(fosmid).getContigs()) {
                builder.append("\t,").append(contig.getId()).append(",").append(contig.getLength()).append(",").append(contig.getCoverage()).append(",").append(contig.getChild()).append("\n");
            }
        }
        return builder.toString();
    }

    private static void loadCanuResults(File canuContigDir, CanuResult canuResult) {
        String rootName = SummerizeCanuContigs.getRootName(canuResult.getFosmidName());
        File canuContigInfoFile = new File(canuContigDir, String.valueOf(rootName) + ".contigs.layout.tigInfo");
        if (canuContigInfoFile.exists()) {
            SummerizeCanuContigs.loadCanuContigInfo(canuResult, canuContigInfoFile);
        } else {
            System.out.println("No output for " + rootName);
        }
    }

    private static void loadCanuContigInfo(CanuResult canuResult, File canuContigInfoFile) {
        String[] lines = FileManager.readTextFile(canuContigInfoFile).split("\n");
        int i = 1;
        while (i < lines.length) {
            String[] fields = lines[i].split("\\s+");
            int count = Integer.valueOf(fields[7].trim());
            if (count > MIN_CHILDREN_COUNT) {
                Contig contig = new Contig();
                contig.setId(fields[0].trim());
                contig.setLength(Integer.valueOf(fields[1].trim()));
                contig.setCoverage(Double.valueOf(fields[2].trim()));
                contig.setChild(Integer.valueOf(fields[7].trim()));
                canuResult.getContigs().add(contig);
            }
            ++i;
        }
    }

    private static String getRootName(String fosmidName) {
        return fosmidName;
    }

    private static void loadInputSeqInfo(File demultiplexFasta, CanuResult canuResult) {
        HashMap<String, String> sequenceMap = new HashMap<String, String>();
        HashMap<String, String> nameIdMap = new HashMap<String, String>();
        RemoveAmpicillin.getSequenceFromFasta(demultiplexFasta, sequenceMap, nameIdMap);
        canuResult.setInputSeqCount(sequenceMap.size());
        canuResult.setAverageSeqLength(SummerizeCanuContigs.getAverageSeqLength(sequenceMap));
    }

    private static int getAverageSeqLength(Map<String, String> sequenceMap) {
        int total = 0;
        for (String seq : sequenceMap.values()) {
            total += seq.length();
        }
        return total / sequenceMap.size();
    }
}

