/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import misc.FileManager;
import misc.SystemCommand;

public class SplitBamFile {
    public static void main(String[] args) throws Exception {
        File inputBam = new File(args[0]);
        File outputDir = new File(args[1]);
        int splicNumber = new Integer(args[2]);
        File zmwList = SplitBamFile.getZMWlist(inputBam);
        String[] zmws = FileManager.readTextFile(zmwList).split("\n");
        int unit = zmws.length / splicNumber;
        System.out.println("total zmws count = " + zmws.length + " split into " + splicNumber + " chunks each w " + unit + " zmws");
        int i = 0;
        while (i < splicNumber) {
            System.out.println("chunk " + i);
            String fileName = String.valueOf(inputBam.getName().replace(".bam", "")) + "-" + i + ".bam";
            File outputFile = new File(outputDir, fileName);
            File whiteList = SplitBamFile.makeWhiteList(zmws, unit, i);
            SplitBamFile.sliceBamFile(inputBam, whiteList, outputFile);
            ++i;
        }
    }

    private static void sliceBamFile(File inputBam, File whiteList, File outputFile) {
        String cmd = "/smrttools/smrtcmds/bin/bamsieve --whitelist " + whiteList.getAbsolutePath() + " " + inputBam.getAbsolutePath() + " " + outputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
    }

    private static File makeWhiteList(String[] zmws, int unit, int index) throws Exception {
        File tempOutputFile = File.createTempFile("unit", "txt");
        tempOutputFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        int i = unit * index;
        while (i < unit * index + unit) {
            builder.append(zmws[i]).append("\n");
            ++i;
        }
        FileManager.writeTextFile(tempOutputFile, builder.toString(), true);
        return tempOutputFile;
    }

    public static File getZMWlist(File inputBam) throws Exception {
        System.out.println("createTempFile ");
        File tempOutputFile = File.createTempFile("zmw", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/smrttools/smrtcmds/bin/bamsieve --show-zmws " + inputBam.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }
}

