/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;
import pacBio.OneMatch;

public class RemoveAmpicillin {
    public static String AMP_LABEL = "Ampicillin-promoter";
    public static String VECTOR_LABEL = "pCCFos1_vector";
    static int MIN_SIZE = 10000;

    public static void main(String[] args) throws Exception {
        File inputFasta = new File(args[0]);
        File ampFasta = new File(args[1]);
        File outputFasta = new File(args[2]);
        HashMap<String, String> sequenceMap = new HashMap<String, String>();
        HashMap<String, String> nameIdMap = new HashMap<String, String>();
        RemoveAmpicillin.getSequenceFromFasta(inputFasta, sequenceMap, nameIdMap);
        System.out.println("alignByCrossmatch ");
        File matchResult = RemoveAmpicillin.alignByCrossmatch(inputFasta, ampFasta);
        System.out.println("parseCMresult ");
        Map<String, List<OneMatch>> hitMap = RemoveAmpicillin.parseCMresult(matchResult, AMP_LABEL);
        System.out.println("trimAmpicillin ");
        Map<String, String> trimedSequenceMap = RemoveAmpicillin.trimAmpicillin(sequenceMap, hitMap);
        System.out.println("input sequence size=" + sequenceMap.size());
        System.out.println("cleaned and filtered sequence size=" + trimedSequenceMap.size());
        System.out.println("writeFastaFile ");
        RemoveAmpicillin.writeFastaFile(nameIdMap, trimedSequenceMap, outputFasta);
    }

    private static void writeFastaFile(Map<String, String> nameIdMap, Map<String, String> trimedSequenceMap, File outputFasta) {
        StringBuilder builder = new StringBuilder();
        for (String seqName : trimedSequenceMap.keySet()) {
            builder.append(">").append(seqName).append(" id=").append(nameIdMap.get(seqName)).append("\n");
            builder.append(trimedSequenceMap.get(seqName)).append("\n");
        }
        FileManager.writeTextFile(outputFasta, builder.toString(), true);
    }

    private static Map<String, String> trimAmpicillin(Map<String, String> sequenceMap, Map<String, List<OneMatch>> hitMap) {
        HashMap<String, String> trimedSequenceMap = new HashMap<String, String>();
        for (String readName : sequenceMap.keySet()) {
            if (!hitMap.containsKey(readName)) continue;
            List<OneMatch> matches = hitMap.get(readName);
            if (matches.size() > 1) {
                System.out.println("can't use " + readName + " matches count=" + matches.size());
                continue;
            }
            OneMatch aMatch = matches.get(0);
            int matchSize = aMatch.getQueryEnd() - aMatch.getQueryStart();
            if (matchSize < 940) {
                String newSequence;
                int seqLen = sequenceMap.get(readName).length();
                if (aMatch.getQueryEnd() >= 940) {
                    if (aMatch.isReverseComp && aMatch.getTargetEnd() >= seqLen - 10) {
                        newSequence = sequenceMap.get(readName).substring(0, aMatch.getTargetStart() - 1);
                        System.out.println("amp at end A" + readName + " afterTrimSize=" + newSequence.length());
                        trimedSequenceMap.put(readName, newSequence);
                        continue;
                    }
                    if (!aMatch.isReverseComp && aMatch.getTargetStart() <= 10) {
                        newSequence = sequenceMap.get(readName).substring(aMatch.getTargetEnd());
                        System.out.println("amp at beginning A" + readName + " afterTrimSize=" + newSequence.length());
                        trimedSequenceMap.put(readName, newSequence);
                        continue;
                    }
                } else if (aMatch.getQueryStart() < 10) {
                    if (aMatch.isReverseComp && aMatch.getTargetStart() <= 10) {
                        newSequence = sequenceMap.get(readName).substring(aMatch.getTargetEnd());
                        System.out.println("amp at beginning B" + readName + " afterTrimSize=" + newSequence.length());
                        trimedSequenceMap.put(readName, newSequence);
                        continue;
                    }
                    if (!aMatch.isReverseComp && aMatch.getTargetEnd() >= seqLen - 10) {
                        newSequence = sequenceMap.get(readName).substring(0, aMatch.getTargetStart() - 1);
                        System.out.println("amp at end B" + readName + " afterTrimSize=" + newSequence.length());
                        trimedSequenceMap.put(readName, newSequence);
                        continue;
                    }
                }
                System.out.println("can't use " + readName + " matchSize=" + matchSize);
                continue;
            }
            String newSequence = String.valueOf(sequenceMap.get(readName).substring(0, aMatch.getTargetStart() - 1)) + sequenceMap.get(readName).substring(aMatch.getTargetEnd());
            if (readName.endsWith("177246_214162")) {
                System.out.println(String.valueOf(readName) + " original size " + sequenceMap.get(readName).length() + " newSize=" + newSequence.length());
                System.out.println(" aMatch.getTargetStart()= " + aMatch.getTargetStart() + " aMatch.getTargetEnd()=" + aMatch.getTargetEnd());
            }
            trimedSequenceMap.put(readName, newSequence);
        }
        return trimedSequenceMap;
    }

    public static Map<String, List<OneMatch>> parseCMresult(File matchResult, String label) {
        String[] lines;
        HashMap<String, List<OneMatch>> hitMap = new HashMap<String, List<OneMatch>>();
        String[] stringArray = lines = FileManager.readTextFile(matchResult).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(String.valueOf(label) + " ") > 0 && line.trim().split("\\s+").length >= 12 && line.trim().split("\\s+")[4].length() > 2) {
                String readsName;
                String[] items = line.trim().split("\\s+");
                boolean isReverseComp = items[8].trim().equals("C");
                String string = readsName = isReverseComp ? items[9].trim() : items[8].trim();
                if (!hitMap.containsKey(readsName)) {
                    hitMap.put(readsName, new ArrayList());
                }
                OneMatch aMatch = null;
                aMatch = isReverseComp ? new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[12].trim()), Integer.valueOf(items[11].trim()), true) : new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[9].trim()), Integer.valueOf(items[10].trim()), false);
                ((List)hitMap.get(readsName)).add(aMatch);
            }
            ++n2;
        }
        return hitMap;
    }

    public static void getSequenceFromFasta(File fasta, Map<String, String> sequenceMap, Map<String, String> nameIdMap) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) {
                String[] items = lines[i].trim().substring(1).split("\\s+");
                String seqName = items[0];
                String id = items[1].trim().substring(3);
                sequenceMap.put(seqName, lines[i + 1].trim());
                nameIdMap.put(seqName, id);
            }
            ++i;
        }
    }

    public static File alignByCrossmatch(File inputFasta, File ampFasta) throws Exception {
        System.out.println("createTempFile ");
        File tempOutputFile = File.createTempFile("out", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -masklevel 101 -minmatch 50 -minscore 50 " + ampFasta.getAbsolutePath() + " " + inputFasta.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }
}

