/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;
import pacBio.Discrepancy;
import pacBio.OneMatch;

public class MapMamuEexons {
    static String NAME_PREFIX = "RH";
    private static String DELETION = "-";

    public static void main(String[] args) throws Exception {
        File sequenceFile = new File(args[0]);
        File rulesetDir = new File(args[1]);
        File outputFile = new File(args[2]);
        Map<String, String> sequences = FileManager.getSequencesFromFasta(sequenceFile);
        LinkedHashMap<String, Map<String, List<OneMatch>>> exonHitMap = new LinkedHashMap<String, Map<String, List<OneMatch>>>();
        Object[] rulesetFiles = rulesetDir.listFiles();
        Arrays.sort(rulesetFiles);
        HashMap<String, Map<String, String>> rulesetSequences = new HashMap<String, Map<String, String>>();
        Object[] objectArray = rulesetFiles;
        int n = rulesetFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object rulesetFile = objectArray[n2];
            if (((File)rulesetFile).getName().endsWith("fa") && ((File)rulesetFile).getName().startsWith("exon")) {
                System.out.println("search " + ((File)rulesetFile).getName());
                Map<String, String> exonSequences = FileManager.getSequencesFromFasta((File)rulesetFile);
                rulesetSequences.put(((File)rulesetFile).getName().substring(0, ((File)rulesetFile).getName().length() - 3), exonSequences);
                Map<String, String> uniqueSequences = MapMamuEexons.mergeSequences(exonSequences);
                MapMamuEexons.searchExonSeq(sequences, uniqueSequences, ((File)rulesetFile).getName().substring(0, ((File)rulesetFile).getName().length() - 3), exonHitMap);
            }
            ++n2;
        }
        HashMap<String, List<String>> noUseExons = new HashMap<String, List<String>>();
        Map<String, String> resolveTypes = MapMamuEexons.resolveType(exonHitMap, rulesetSequences, noUseExons);
        MapMamuEexons.writeOutput(exonHitMap, resolveTypes, noUseExons, sequences, outputFile);
    }

    private static Map<String, String> resolveType(Map<String, Map<String, List<OneMatch>>> exonHitMap, Map<String, Map<String, String>> rulesetSequences, Map<String, List<String>> noUseExons) {
        LinkedHashMap<String, String> resolveTypes = new LinkedHashMap<String, String>();
        for (String name : exonHitMap.keySet()) {
            Map<String, List<OneMatch>> exonMatches;
            List<String> anchorNames;
            if (!noUseExons.containsKey(name)) {
                noUseExons.put(name, new ArrayList());
            }
            if ((anchorNames = MapMamuEexons.getAnchorTypes(exonMatches = exonHitMap.get(name))).size() == 0) {
                resolveTypes.put(name, "");
                continue;
            }
            int i = 1;
            while (i <= 8) {
                String exonName = "exon" + i;
                List<OneMatch> thisMatches = exonMatches.get(exonName);
                if (thisMatches != null) {
                    ArrayList<String> exonHitNames = new ArrayList<String>();
                    MapMamuEexons.parseTypeNames(exonHitNames, thisMatches);
                    exonHitNames.size();
                    MapMamuEexons.resolveAnchorType(anchorNames, exonHitNames, rulesetSequences.get(exonName), noUseExons.get(name), exonName);
                }
                ++i;
            }
            resolveTypes.put(name, MapMamuEexons.formatName(anchorNames));
        }
        return resolveTypes;
    }

    private static String formatName(List<String> anchorNames) {
        String ret = "";
        for (String name : anchorNames) {
            ret = String.valueOf(ret) + name + "|";
        }
        return ret.substring(0, ret.length() - 1);
    }

    private static void resolveAnchorType(List<String> anchorNames, List<String> exonHitNames, Map<String, String> ruleSetSeq, List<String> unuseExons, String exonName) {
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String name : anchorNames) {
            if (!ruleSetSeq.containsKey(name) || exonHitNames.contains(name)) continue;
            toBeRemoved.add(name);
        }
        if (toBeRemoved.size() == anchorNames.size()) {
            unuseExons.add(exonName);
            return;
        }
        System.out.println("exonName " + exonName);
        Iterator<String> it = anchorNames.iterator();
        while (it.hasNext()) {
            String name = it.next();
            if (!toBeRemoved.contains(name)) continue;
            System.out.println("remove " + name);
            it.remove();
        }
    }

    private static List<String> getAnchorTypes(Map<String, List<OneMatch>> exonMatches) {
        ArrayList<String> anchorNames = new ArrayList<String>();
        if (exonMatches.containsKey("exon2")) {
            List<OneMatch> anchorMatches = exonMatches.get("exon2");
            MapMamuEexons.parseTypeNames(anchorNames, anchorMatches);
            System.out.println("exon2 " + ((Object)anchorNames).toString());
        } else if (exonMatches.containsKey("exon3")) {
            List<OneMatch> anchorMatches = exonMatches.get("exon3");
            MapMamuEexons.parseTypeNames(anchorNames, anchorMatches);
            System.out.println("exon3 " + ((Object)anchorNames).toString());
        }
        return anchorNames;
    }

    private static void parseTypeNames(List<String> anchorNames, List<OneMatch> anchorMatches) {
        for (OneMatch match : anchorMatches) {
            String[] matchNames;
            String[] stringArray = matchNames = match.getTargetName().split("\\|");
            int n = matchNames.length;
            int n2 = 0;
            while (n2 < n) {
                String matchName = stringArray[n2];
                anchorNames.add(matchName);
                ++n2;
            }
        }
    }

    private static void writeOutput(Map<String, Map<String, List<OneMatch>>> exonHitMap, Map<String, String> resolveTypes, Map<String, List<String>> noUseExons, Map<String, String> sequences, File outputFile) {
        StringBuilder builder = new StringBuilder();
        builder.append("Name,").append("Size,").append("Type,").append("SkippedForResolving,").append("Exon1,").append("Exon2,").append("Exon3,").append("Exon4,").append("Exon5,").append("Exon6,").append("Exon7,").append("Exon8,").append("\n");
        for (String name : exonHitMap.keySet()) {
            builder.append(name).append(",");
            builder.append(sequences.get(name).length()).append(",");
            if (resolveTypes.get(name).length() == 0) {
                builder.append("-").append(",");
            } else {
                builder.append(resolveTypes.get(name)).append(",");
            }
            if (noUseExons.get(name).size() == 0) {
                builder.append("-").append(",");
            } else {
                builder.append(MapMamuEexons.formatName(noUseExons.get(name))).append(",");
            }
            int i = 1;
            while (i <= 8) {
                String exonName = "exon" + i;
                if (exonHitMap.get(name).containsKey(exonName)) {
                    List<OneMatch> matches = exonHitMap.get(name).get(exonName);
                    StringBuilder matchNames = new StringBuilder();
                    for (OneMatch match : matches) {
                        if (match.getDiscrepencies().size() > 0) {
                            matchNames.append("~").append(match.getTargetName()).append(MapMamuEexons.formatDiscrep(match.getDiscrepencies())).append("&");
                            continue;
                        }
                        matchNames.append(match.getTargetName()).append("&");
                    }
                    builder.append(matchNames.toString().substring(0, matchNames.toString().length() - 1)).append(",");
                } else {
                    builder.append("-").append(",");
                }
                ++i;
            }
            builder.append("\n");
        }
        System.out.println("write " + outputFile.getAbsolutePath());
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static String formatDiscrep(List<Discrepancy> discrepencies) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (Discrepancy d : discrepencies) {
            builder.append(d.getTargetPosition()).append(d.getType()).append("#");
        }
        return String.valueOf(builder.toString().substring(0, builder.toString().length() - 1)) + ")";
    }

    private static void searchExonSeq(Map<String, String> sequences, Map<String, String> uniqueSequences, String exonName, Map<String, Map<String, List<OneMatch>>> exonHitMap) throws Exception {
        for (String seqName : sequences.keySet()) {
            String thisSeq = sequences.get(seqName);
            if (!exonHitMap.containsKey(seqName)) {
                exonHitMap.put(seqName, new LinkedHashMap());
            }
            boolean findExactMatch = false;
            OneMatch oneMatch = null;
            for (String exonSeq : uniqueSequences.keySet()) {
                if (exonName.equals("exon8")) {
                    if (thisSeq.substring(thisSeq.length() - 100).indexOf(exonSeq) >= 0) {
                        findExactMatch = true;
                        oneMatch = new OneMatch(1, exonSeq.length(), thisSeq.substring(thisSeq.length() - 100).indexOf(exonSeq) + 1 + (thisSeq.length() - 100), thisSeq.substring(thisSeq.length() - 100).indexOf(exonSeq) + 1 + exonSeq.length() + (thisSeq.length() - 100), false);
                        MapMamuEexons.collectMatches(uniqueSequences, exonName, exonHitMap, seqName, oneMatch, exonSeq);
                        continue;
                    }
                    if (thisSeq.substring(0, 100).indexOf(FileManager.revCompSeq(exonSeq)) < 0) continue;
                    findExactMatch = true;
                    oneMatch = new OneMatch(1, exonSeq.length(), thisSeq.substring(0, 100).indexOf(FileManager.revCompSeq(exonSeq)) + 1, thisSeq.substring(0, 100).indexOf(FileManager.revCompSeq(exonSeq)) + 1 + exonSeq.length(), true);
                    MapMamuEexons.collectMatches(uniqueSequences, exonName, exonHitMap, seqName, oneMatch, exonSeq);
                    continue;
                }
                if (thisSeq.indexOf(exonSeq) >= 0) {
                    findExactMatch = true;
                    oneMatch = new OneMatch(1, exonSeq.length(), thisSeq.indexOf(exonSeq) + 1, thisSeq.indexOf(exonSeq) + 1 + exonSeq.length(), false);
                    MapMamuEexons.collectMatches(uniqueSequences, exonName, exonHitMap, seqName, oneMatch, exonSeq);
                    continue;
                }
                if (thisSeq.indexOf(FileManager.revCompSeq(exonSeq)) < 0) continue;
                findExactMatch = true;
                oneMatch = new OneMatch(1, exonSeq.length(), thisSeq.indexOf(FileManager.revCompSeq(exonSeq)) + 1, thisSeq.indexOf(FileManager.revCompSeq(exonSeq)) + 1 + exonSeq.length(), true);
                MapMamuEexons.collectMatches(uniqueSequences, exonName, exonHitMap, seqName, oneMatch, exonSeq);
            }
            if (findExactMatch || exonName.equals("exon8")) continue;
            System.out.println(String.valueOf(exonName) + " findCloseMatch ");
            List<OneMatch> closeMatches = MapMamuEexons.findCloseMatch(uniqueSequences, seqName, thisSeq);
            System.out.println("closeMatches.size()=" + closeMatches.size());
            for (OneMatch aMatch : closeMatches) {
                if (!exonHitMap.get(seqName).containsKey(exonName)) {
                    exonHitMap.get(seqName).put(exonName, new ArrayList());
                }
                exonHitMap.get(seqName).get(exonName).add(aMatch);
            }
        }
    }

    private static List<OneMatch> findCloseMatch(Map<String, String> uniqueSequences, String seqName, String thisSeq) throws Exception {
        File rulesetFile = File.createTempFile("ruleset", "fa");
        rulesetFile.deleteOnExit();
        Map<String, String> shortNameMap = MapMamuEexons.createNameMap(uniqueSequences);
        MapMamuEexons.createRulesetFile(uniqueSequences, rulesetFile, shortNameMap);
        File seqFile = File.createTempFile("seq", "fa");
        seqFile.deleteOnExit();
        MapMamuEexons.createSeqFile(seqName, thisSeq, seqFile);
        File tempOutputFile = MapMamuEexons.alignByCrossmatch(seqFile, rulesetFile);
        List<OneMatch> bestMatches = MapMamuEexons.ParseResult(tempOutputFile, shortNameMap);
        return bestMatches;
    }

    private static List<OneMatch> ParseResult(File matchResult, Map<String, String> shortNameMap) throws Exception {
        ArrayList<OneMatch> bestMatches = new ArrayList<OneMatch>();
        HashMap matchMap = new HashMap();
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(NAME_PREFIX) > 0 && line.trim().split("\\s+").length >= 12) {
                System.out.println(line);
                String[] items = line.trim().split("\\s+");
                startRecord = true;
                fullName = items[4].trim();
                aMatch = MapMamuEexons.populateAmatch(line);
                if (aMatch == null) {
                    System.out.println("discard ");
                    startRecord = false;
                } else if (!matchMap.containsKey(aMatch.getPercentDiscrep())) {
                    matchMap.put(aMatch.getPercentDiscrep(), new ArrayList());
                    ((List)matchMap.get(aMatch.getPercentDiscrep())).add(aMatch);
                }
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                MapMamuEexons.populateDiscrepency(aMatch, line, fullName);
            }
            ++n2;
        }
        if (matchMap.size() == 0) {
            return bestMatches;
        }
        Object[] keys = matchMap.keySet().toArray();
        Arrays.sort(keys);
        bestMatches.addAll((Collection)matchMap.get(keys[0]));
        for (OneMatch match : bestMatches) {
            String shortName = match.getTargetName();
            String fName = MapMamuEexons.getFullName(shortName, shortNameMap);
            match.setTargetName(fName);
        }
        return bestMatches;
    }

    private static String getFullName(String shortName, Map<String, String> shortNameMap) {
        for (String fullName : shortNameMap.keySet()) {
            if (!shortNameMap.get(fullName).equals(shortName)) continue;
            return fullName;
        }
        return null;
    }

    private static void populateDiscrepency(OneMatch match, String line, String fullName) {
        String[] items = line.trim().split("\\s+");
        if (items[0].charAt(0) != 'S' && items[0].charAt(0) != 'I' && items[0].charAt(0) != 'D') {
            return;
        }
        List<Discrepancy> discrepancies = MapMamuEexons.generateDiscrepancy(items, fullName, match.isReverseComp());
        match.setDiscrepencies(discrepancies);
    }

    private static List<Discrepancy> generateDiscrepancy(String[] items, String fullName, boolean isReverseComp) {
        int count = 1;
        if (items[0].trim().length() > 1) {
            count = new Integer(items[0].trim().substring(2));
        }
        char type = items[0].charAt(0);
        String base = items[2].trim().substring(0, items[2].indexOf("("));
        if (isReverseComp) {
            base = FileManager.revCompSeq(base);
        }
        int queryPosition = Integer.parseInt(items[1]);
        int targetPosition = Integer.parseInt(items[3]);
        String queryFlanking = items[4].trim();
        ArrayList<Discrepancy> discrepancies = new ArrayList<Discrepancy>();
        if (type == 'D') {
            int i = 0;
            while (i < count) {
                Discrepancy dis;
                if (isReverseComp) {
                    dis = new Discrepancy(type, 1, queryPosition, DELETION, 20, targetPosition - i, queryFlanking);
                    discrepancies.add(dis);
                } else {
                    dis = new Discrepancy(type, 1, queryPosition, DELETION, 20, targetPosition + i, queryFlanking);
                    discrepancies.add(dis);
                }
                ++i;
            }
        } else {
            Discrepancy dis = new Discrepancy(type, count, queryPosition, base, 20, targetPosition, queryFlanking);
            discrepancies.add(dis);
        }
        return discrepancies;
    }

    public static OneMatch populateAmatch(String line) {
        String[] items = line.trim().split("\\s+");
        boolean isRevComp = items[8].trim().equals("C");
        double discrep = Double.valueOf(items[1].trim()) + Double.valueOf(items[2].trim()) + Double.valueOf(items[3].trim());
        OneMatch aMatch = null;
        if (isRevComp) {
            String leftover = items[10].trim().substring(1, items[10].trim().length() - 1);
            if (!leftover.equals("0") || !items[12].trim().equals("1")) {
                return null;
            }
            aMatch = new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[12].trim()), Integer.valueOf(items[11].trim()), true);
            aMatch.setTargetName(items[9].trim());
        } else {
            String leftover = items[11].trim().substring(1, items[11].trim().length() - 1);
            if (!leftover.equals("0") || !items[9].trim().equals("1")) {
                return null;
            }
            aMatch = new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[9].trim()), Integer.valueOf(items[10].trim()), false);
            aMatch.setTargetName(items[8].trim());
        }
        aMatch.setPercentDiscrep(discrep);
        return aMatch;
    }

    private static void createSeqFile(String seqName, String thisSeq, File seqFile) {
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(seqName).append("\n");
        builder.append(thisSeq).append("\n");
        FileManager.writeTextFile(seqFile, builder.toString(), true);
    }

    private static void createRulesetFile(Map<String, String> uniqueSequences, File rulesetFile, Map<String, String> shortNameMap) {
        StringBuilder builder = new StringBuilder();
        for (String exonSeq : uniqueSequences.keySet()) {
            String fullName = uniqueSequences.get(exonSeq);
            builder.append(">").append(shortNameMap.get(fullName)).append("\n");
            builder.append(exonSeq).append("\n");
        }
        FileManager.writeTextFile(rulesetFile, builder.toString(), true);
    }

    private static Map<String, String> createNameMap(Map<String, String> uniqueSequences) {
        HashMap<String, String> shortNameMap = new HashMap<String, String>();
        int counter = 1;
        for (String fullName : uniqueSequences.values()) {
            shortNameMap.put(fullName, String.valueOf(NAME_PREFIX) + counter);
            ++counter;
        }
        return shortNameMap;
    }

    public static File alignByCrossmatch(File inputFasta, File ampFasta) throws Exception {
        File tempOutputFile = File.createTempFile("out", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/home/rwang/software/phrap/cross_match -masklevel 101 -discrep_lists " + inputFasta.getAbsolutePath() + " " + ampFasta.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }

    private static void collectMatches(Map<String, String> uniqueSequences, String exonName, Map<String, Map<String, List<OneMatch>>> exonHitMap, String seqName, OneMatch oneMatch, String exonSeq) {
        oneMatch.setTargetName(uniqueSequences.get(exonSeq));
        if (!exonHitMap.get(seqName).containsKey(exonName)) {
            exonHitMap.get(seqName).put(exonName, new ArrayList());
        }
        exonHitMap.get(seqName).get(exonName).add(oneMatch);
    }

    private static Map<String, String> mergeSequences(Map<String, String> exonSequences) {
        HashMap<String, String> seqNameMap = new HashMap<String, String>();
        for (String name : exonSequences.keySet()) {
            String seq = exonSequences.get(name);
            if (!seqNameMap.containsKey(seq)) {
                seqNameMap.put(seq, name);
                continue;
            }
            String newName = String.valueOf((String)seqNameMap.get(seq)) + "|" + name;
            seqNameMap.put(seq, newName);
        }
        return seqNameMap;
    }
}

