/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;
import pacBio.OneMatch;

public class MapCcsReads {
    static String NAME_PREFIX = "Barcode";

    public static void main(String[] args) throws Exception {
        File sequenceFile = new File(args[0]);
        File ccsDir = new File(args[1]);
        File outputFile = new File(args[2]);
        double mismatchThreshHold = new Double(args[3]);
        Map<String, String> sequences = FileManager.getSequencesFromFasta(sequenceFile);
        Map<String, List<String>> sequencesBySample = MapCcsReads.organizeSequenceBySample(sequences);
        StringBuilder builder = new StringBuilder();
        builder.append("Name").append(",").append("matched/TotalCcsReads").append(",").append("%ccsMismatch").append(",").append("%mismatchFromTopConsensus").append("\n");
        for (String sampleName : sequencesBySample.keySet()) {
            File ccsFile = MapCcsReads.findCcsFile(sampleName, ccsDir);
            if (ccsFile == null) {
                System.out.println("missing ccs file " + sampleName);
            }
            File seqFile = MapCcsReads.createSeqFile(sequences, sequencesBySample.get(sampleName));
            File tempOutputFile = MapCcsReads.alignByCrossmatch(seqFile, ccsFile);
            Map<String, List<OneMatch>> matchMap = MapCcsReads.ParseCcsMatchResult(tempOutputFile, mismatchThreshHold);
            File topSeqFile = MapCcsReads.createTopSeqFile(sequences, sequencesBySample.get(sampleName));
            File tempOutputFile2 = MapCcsReads.align2TopByCrossmatch(topSeqFile, seqFile);
            Map<String, List<OneMatch>> matchMap2 = MapCcsReads.ParseResult(tempOutputFile2);
            for (String name : matchMap2.keySet()) {
                System.out.println("name " + name + " " + matchMap2.get(name).get(0).getPercentDiscrep());
            }
            MapCcsReads.logInfo(sequencesBySample.get(sampleName), matchMap, matchMap2, builder, FileManager.readTextFile(ccsFile).split("\n").length / 2);
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    public static File align2TopByCrossmatch(File topSeqFile, File seqFile) throws Exception {
        File tempOutputFile = File.createTempFile("out", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/home/rwang/software/phrap/cross_match -masklevel 101 -minscore 2500 " + topSeqFile.getAbsolutePath() + " " + seqFile.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }

    private static File createTopSeqFile(Map<String, String> sequences, List<String> names) throws Exception {
        File seqFile = File.createTempFile("seq", "fa");
        seqFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = names.iterator();
        if (iterator.hasNext()) {
            String name = iterator.next();
            builder.append(">").append(name).append("\n");
            builder.append(sequences.get(name)).append("\n");
        }
        FileManager.writeTextFile(seqFile, builder.toString(), true);
        return seqFile;
    }

    private static void logInfo(List<String> names, Map<String, List<OneMatch>> matchMap, Map<String, List<OneMatch>> matchMap2, StringBuilder builder, int ccsCount) {
        for (String name : names) {
            List<OneMatch> matches;
            String mismatchfromTop = "-";
            if (matchMap2.containsKey(name) && (matches = matchMap2.get(name)).size() > 0) {
                mismatchfromTop = String.format("%.2f", matches.get(0).getPercentDiscrep());
            }
            if (!matchMap.containsKey(name)) {
                builder.append(name).append(",").append("0/").append(ccsCount).append(",").append("-").append(",").append(mismatchfromTop).append("\n");
                continue;
            }
            matches = matchMap.get(name);
            double totalMismatch = 0.0;
            for (OneMatch match : matches) {
                totalMismatch += match.getPercentDiscrep();
            }
            double aveMismatch = totalMismatch / (double)matches.size();
            builder.append(name).append(",").append(matches.size()).append("/").append(ccsCount).append(",").append(String.format("%.2f", aveMismatch)).append(",").append(mismatchfromTop).append("\n");
        }
    }

    private static Map<String, List<OneMatch>> ParseCcsMatchResult(File matchResult, double mismatchThreshHold) throws Exception {
        HashMap<String, List<OneMatch>> matchMap = new HashMap<String, List<OneMatch>>();
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        OneMatch aMatch = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(NAME_PREFIX) > 0 && line.trim().split("\\s+").length >= 12 && (aMatch = MapCcsReads.populateCcsmatch(line, mismatchThreshHold)) != null) {
                String targetName = aMatch.getTargetName();
                if (!matchMap.containsKey(targetName)) {
                    matchMap.put(targetName, new ArrayList());
                }
                ((List)matchMap.get(targetName)).add(aMatch);
            }
            ++n2;
        }
        return matchMap;
    }

    public static OneMatch populateCcsmatch(String line, double mismatchThreshHold) {
        String[] items = line.trim().split("\\s+");
        boolean isRevComp = items[8].trim().equals("C");
        double discrep = Double.valueOf(items[1].trim()) + Double.valueOf(items[2].trim()) + Double.valueOf(items[3].trim());
        if (discrep > mismatchThreshHold) {
            return null;
        }
        OneMatch aMatch = null;
        String leftover = items[7].trim().substring(1, items[7].trim().length() - 1);
        if (isRevComp) {
            aMatch = new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[12].trim()), Integer.valueOf(items[11].trim()), true);
            aMatch.setTargetName(items[9].trim());
        } else {
            aMatch = new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[9].trim()), Integer.valueOf(items[10].trim()), false);
            aMatch.setTargetName(items[8].trim());
        }
        aMatch.setPercentDiscrep(discrep);
        return aMatch;
    }

    private static Map<String, List<OneMatch>> ParseResult(File matchResult) throws Exception {
        HashMap<String, List<OneMatch>> matchMap = new HashMap<String, List<OneMatch>>();
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        OneMatch aMatch = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(NAME_PREFIX) > 0 && line.trim().split("\\s+").length >= 12 && (aMatch = MapCcsReads.populateAmatch(line)) != null) {
                String targetName = aMatch.getTargetName();
                if (!matchMap.containsKey(targetName)) {
                    matchMap.put(targetName, new ArrayList());
                }
                ((List)matchMap.get(targetName)).add(aMatch);
            }
            ++n2;
        }
        return matchMap;
    }

    public static OneMatch populateAmatch(String line) {
        String[] items = line.trim().split("\\s+");
        boolean isRevComp = items[8].trim().equals("C");
        double discrep = Double.valueOf(items[1].trim()) + Double.valueOf(items[2].trim()) + Double.valueOf(items[3].trim());
        OneMatch aMatch = null;
        if (isRevComp) {
            aMatch = new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[12].trim()), Integer.valueOf(items[11].trim()), true);
            aMatch.setTargetName(items[9].trim());
        } else {
            aMatch = new OneMatch(Integer.valueOf(items[5].trim()), Integer.valueOf(items[6].trim()), Integer.valueOf(items[9].trim()), Integer.valueOf(items[10].trim()), false);
            aMatch.setTargetName(items[8].trim());
        }
        aMatch.setPercentDiscrep(discrep);
        return aMatch;
    }

    public static File alignByCrossmatch(File seqFile, File ccsFile) throws Exception {
        File tempOutputFile = File.createTempFile("out", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/home/rwang/software/phrap/cross_match -minscore 2400 " + ccsFile.getAbsolutePath() + " " + seqFile.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }

    private static File createSeqFile(Map<String, String> sequences, List<String> names) throws Exception {
        File seqFile = File.createTempFile("seq", "fa");
        seqFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        for (String name : names) {
            builder.append(">").append(name).append("\n");
            builder.append(sequences.get(name)).append("\n");
        }
        FileManager.writeTextFile(seqFile, builder.toString(), true);
        return seqFile;
    }

    private static File findCcsFile(String sampleName, File ccsDir) {
        File[] files;
        File[] fileArray = files = ccsDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fName = file.getName();
            if (fName.split("\\.")[1].split("--")[0].equals(sampleName)) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, List<String>> organizeSequenceBySample(Map<String, String> sequences) {
        LinkedHashMap<String, List<String>> sequencesBySample = new LinkedHashMap<String, List<String>>();
        for (String name : sequences.keySet()) {
            String sampleName = name.split("--")[0];
            if (!sequencesBySample.containsKey(sampleName)) {
                sequencesBySample.put(sampleName, new ArrayList());
            }
            ((List)sequencesBySample.get(sampleName)).add(name);
        }
        return sequencesBySample;
    }
}

