/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GetSeqByZmw {
    public static void main(String[] args) throws Exception {
        File inputFastaDir = new File(args[0]);
        File inputZmwDir = new File(args[1]);
        File outputDir = new File(args[2]);
        Object[] zmwFiles = inputZmwDir.listFiles();
        Arrays.sort(zmwFiles);
        HashMap<String, List<String>> zmwMap = new HashMap<String, List<String>>();
        HashMap<String, StringBuilder> fastaMap = new HashMap<String, StringBuilder>();
        Object[] objectArray = zmwFiles;
        int n = zmwFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object zmwFile = objectArray[n2];
            if (((File)zmwFile).getName().endsWith("-zmw.txt")) {
                zmwMap.put(((File)zmwFile).getName(), GetSeqByZmw.readIn((File)zmwFile));
                fastaMap.put(((File)zmwFile).getName(), new StringBuilder());
            }
            ++n2;
        }
        Object[] fastaFiles = inputFastaDir.listFiles();
        Arrays.sort(fastaFiles);
        Object[] objectArray2 = fastaFiles;
        int n3 = fastaFiles.length;
        n = 0;
        while (n < n3) {
            Object fastaFile = objectArray2[n];
            if (((File)fastaFile).getName().endsWith("fasta")) {
                System.out.println("\t" + ((File)fastaFile).getName());
                GetSeqByZmw.fileFasta((File)fastaFile, fastaMap, zmwMap);
            }
            ++n;
        }
        for (String name : fastaMap.keySet()) {
            File fastaFile = new File(outputDir, name.replace("-zmw.txt", "-ccs.fasta"));
            FileManager.writeTextFile(fastaFile, ((StringBuilder)fastaMap.get(name)).toString(), true);
        }
    }

    private static void fileFasta(File fastaFile, Map<String, StringBuilder> fastaMap, Map<String, List<String>> zmwMap) {
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String zmw;
            String geneKey;
            String line = lines[i];
            if (line.startsWith(">") && (geneKey = GetSeqByZmw.locate(zmw = line.split("/")[1], zmwMap)) != null) {
                fastaMap.get(geneKey).append(line.trim()).append("\n").append(GetSeqByZmw.collectSeq(i + 1, lines)).append("\n");
            }
            ++i;
        }
    }

    private static String collectSeq(int index, String[] lines) {
        StringBuilder seq = new StringBuilder();
        int i = index;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) break;
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static String locate(String zmw, Map<String, List<String>> zmwMap) {
        for (String gene : zmwMap.keySet()) {
            if (!zmwMap.get(gene).contains(zmw)) continue;
            return gene;
        }
        return null;
    }

    private static List<String> readIn(File zmwFile) {
        String[] lines;
        ArrayList<String> zmws = new ArrayList<String>();
        String[] stringArray = lines = FileManager.readTextFile(zmwFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            zmws.add(line.trim());
            ++n2;
        }
        return zmws;
    }
}

