/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class FastqToFasta {
    public static void main(String[] args) throws Exception {
        File[] fastqFiles;
        File fastqDir = new File(args[0]);
        File fastaDir = new File(args[1]);
        File[] fileArray = fastqFiles = fastqDir.listFiles();
        int n = fastqFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File fastqFile = fileArray[n2];
            if (fastqFile.getName().endsWith("fastq")) {
                LinkedHashMap<String, String> seqMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> qualityMap = new LinkedHashMap<String, String>();
                FastqToFasta.getSeqMap(fastqFile, seqMap, qualityMap);
                File fastaFile = new File(fastaDir, fastqFile.getName().replace("fastq", "fasta"));
                File qualityFile = new File(fastaDir, fastqFile.getName().replace("fastq", "qual"));
                FastqToFasta.writeFastaFile(seqMap, fastaFile);
                FastqToFasta.writeFastaFile(qualityMap, qualityFile);
            }
            ++n2;
        }
    }

    public static void writeFastaFile(Map<String, String> seqMap, File fastaFile) {
        StringBuilder out = new StringBuilder();
        for (String name : seqMap.keySet()) {
            out.append(">").append(name).append("\n");
            out.append(seqMap.get(name)).append("\n");
        }
        FileManager.writeTextFile(fastaFile, out.toString(), true);
    }

    public static void getSeqMap(File fastqFile, Map<String, String> seqMap, Map<String, String> qualityMap) {
        String[] lines = FileManager.readTextFile(fastqFile).trim().split("\n");
        if (lines.length < 4) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (i % 4 == 0) {
                String name = line.substring(1);
                seqMap.put(name, lines[i + 1].trim());
                qualityMap.put(name, lines[i + 3].trim());
            }
            ++i;
        }
    }
}

