/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class CutMamuSeq {
    public static void main(String[] args) throws Exception {
        File sequenceFile = new File(args[0]);
        File CoordFile = new File(args[1]);
        File outputDir = new File(args[2]);
        Map<String, String> sequences = FileManager.getSequencesFromFasta(sequenceFile);
        String[] lines = FileManager.readTextFile(CoordFile).split("\n");
        Map<String, StringBuilder> exonSequenceMap = CutMamuSeq.initExonSequenceMap();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\\s+");
            String sequence = sequences.get(items[0].trim());
            if (items[3].trim().startsWith("18")) {
                CutMamuSeq.parseGenomic(items, sequence, exonSequenceMap);
            } else {
                CutMamuSeq.parseCdna(items, sequence, exonSequenceMap);
            }
            ++n2;
        }
        CutMamuSeq.writeOutput(exonSequenceMap, outputDir);
    }

    private static void writeOutput(Map<String, StringBuilder> exonSequenceMap, File outputDir) {
        for (String exon : exonSequenceMap.keySet()) {
            File exonFile = new File(outputDir, String.valueOf(exon) + ".fa");
            FileManager.writeTextFile(exonFile, exonSequenceMap.get(exon).toString(), true);
        }
    }

    private static void parseGenomic(String[] items, String sequence, Map<String, StringBuilder> exonSequenceMap) {
        String name = items[0].trim();
        int exonCount = 0;
        int i = 1;
        while (i < items.length - 1) {
            if (i % 2 != 0) {
                String exon = "exon" + ++exonCount;
                if (!items[i].trim().equals("-") && !items[i + 1].trim().equals("-")) {
                    int start = Integer.valueOf(items[i].trim());
                    int end = Integer.valueOf(items[i + 1].trim());
                    String exonSequence = sequence.substring(start, end);
                    exonSequenceMap.get(exon).append(">").append(name).append("\n").append(exonSequence).append("\n");
                }
            }
            ++i;
        }
    }

    private static void parseCdna(String[] items, String sequence, Map<String, StringBuilder> exonSequenceMap) {
        String name = items[0].trim();
        int i = 1;
        while (i < items.length - 1) {
            String exon = "exon" + i;
            if (!items[i].trim().equals("-") && !items[i + 1].trim().equals("-")) {
                int start = Integer.valueOf(items[i].trim());
                int end = Integer.valueOf(items[i + 1].trim());
                String exonSequence = sequence.substring(start, end);
                exonSequenceMap.get(exon).append(">").append(name).append("\n").append(exonSequence).append("\n");
            }
            ++i;
        }
    }

    private static Map<String, StringBuilder> initExonSequenceMap() {
        LinkedHashMap<String, StringBuilder> exonSequenceMap = new LinkedHashMap<String, StringBuilder>();
        exonSequenceMap.put("exon1", new StringBuilder());
        exonSequenceMap.put("exon2", new StringBuilder());
        exonSequenceMap.put("exon3", new StringBuilder());
        exonSequenceMap.put("exon4", new StringBuilder());
        exonSequenceMap.put("exon5", new StringBuilder());
        exonSequenceMap.put("exon6", new StringBuilder());
        exonSequenceMap.put("exon7", new StringBuilder());
        exonSequenceMap.put("exon8", new StringBuilder());
        return exonSequenceMap;
    }
}

