/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import misc.FileManager;

public class ConsolidateRunResult {
    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File[] laaDirs = inputDir.listFiles();
        StringBuilder info = new StringBuilder();
        info.append("BarcodeName,FastaName,CoarseCluster,Phase,TotalCoverage,SequenceLength,PredictedAccuracy,ConsensusConverged,NoiseSequence,IsDuplicate,DuplicateOf,IsChimera,ChimeraScore,ParentSequenceA,ParentSequenceB,CrossoverPosition");
        info.append("\n");
        File[] fileArray = laaDirs;
        int n = laaDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File laaDir = fileArray[n2];
            if (laaDir.isDirectory() && laaDir.getName().startsWith("pblaa.tasks.laa-")) {
                File consensusFile = new File(laaDir, "amplicon_analysis.fastq");
                File summaryFile = new File(laaDir, "amplicon_analysis_summary.csv");
                if (!consensusFile.exists() || !summaryFile.exists()) {
                    System.out.println("no result found " + laaDir.getName());
                } else {
                    String name = ConsolidateRunResult.getBarcodeName(consensusFile);
                    File fullName = new File(outputDir, "consensus." + name + "." + name + ".fastq");
                    FileManager.copyFile(consensusFile, fullName, true);
                    System.out.println(String.valueOf(laaDir.getName()) + " -> " + fullName.getName());
                    info.append(ConsolidateRunResult.getSeqInfo(summaryFile));
                }
            }
            ++n2;
        }
        FileManager.writeTextFile(new File(outputDir, "info.csv"), info.toString(), true);
    }

    private static String getSeqInfo(File summaryFile) {
        StringBuilder content = new StringBuilder();
        String[] lines = FileManager.readTextFile(summaryFile).split("\n");
        int i = 1;
        while (i < lines.length) {
            content.append(lines[i].trim());
            content.append("\n");
            ++i;
        }
        return content.toString();
    }

    private static String getBarcodeName(File consensusFile) {
        String line = FileManager.readTextFile(consensusFile).split("\n")[0].trim();
        String name = line.split("_")[0].replace("@Barcode", "");
        return name;
    }
}

