/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import fileOperation.OneMatch;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import pacBio.CollectSeqences;
import pacBio.FastqToFasta;

public class CollectSquenceMamuE {
    static String LABEL = "Barcode";
    static int SIZE = 3000;

    public static void main(String[] args) throws Exception {
        File fastqDir = new File(args[0]);
        File backBone = new File(args[1]);
        File outputFastqFile = new File(args[2]);
        File outputSummaryFile = new File(args[3]);
        String SampleName = new String(args[4]);
        File[] files = fastqDir.listFiles();
        StringBuilder allMatchResult = new StringBuilder();
        LinkedHashMap<String, List<OneMatch>> allConsensus = new LinkedHashMap<String, List<OneMatch>>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("fastq")) {
                allConsensus.put(file.getName(), new ArrayList());
                System.out.println(file.getName());
                File summaryFile = new File(fastqDir, file.getName().replace(".fastq", "-summary.csv"));
                System.out.println(summaryFile.getName());
                File fastaFile = File.createTempFile("seq", "fasta");
                LinkedHashMap<String, String> qualityMap = new LinkedHashMap<String, String>();
                fastaFile.deleteOnExit();
                CollectSquenceMamuE.convertFastqFile(file, fastaFile, qualityMap);
                Map<String, OneMatch> sampleResult = CollectSquenceMamuE.collectConsensus(fastaFile, qualityMap, backBone, allMatchResult);
                for (String seqName : sampleResult.keySet()) {
                    System.out.println(seqName);
                    if (sampleResult.get(seqName).isForwardExist()) {
                        System.out.println("forward: " + sampleResult.get(seqName).getForwardStart() + " " + sampleResult.get(seqName).getForwardEnd());
                    }
                    if (!sampleResult.get(seqName).isReverseExist()) continue;
                    System.out.println("Reverse: " + sampleResult.get(seqName).getReverseStart() + " " + sampleResult.get(seqName).getReverseEnd());
                }
                CollectSquenceMamuE.filleInSequence(sampleResult, fastaFile, qualityMap);
                CollectSquenceMamuE.loadExtractedSequence(sampleResult);
                ((List)allConsensus.get(file.getName())).addAll(sampleResult.values());
            }
            ++n2;
        }
        CollectSquenceMamuE.writeFastaQFile(outputFastqFile, allConsensus, SampleName);
    }

    private static void writeFastaQFile(File outputFastqFile, Map<String, List<OneMatch>> allConsensus, String SampleName) {
        StringBuilder bulider = new StringBuilder();
        for (String fileName : allConsensus.keySet()) {
            String preFix = CollectSquenceMamuE.findPreFix(fileName);
            List<OneMatch> matches = allConsensus.get(fileName);
            for (OneMatch match : matches) {
                bulider.append("@").append(CollectSquenceMamuE.generateName(preFix, match.getName(), SampleName)).append("\n");
                bulider.append(match.getTrimedSequence()).append("\n");
                bulider.append("+").append("\n");
                bulider.append(match.getTrimedQuality()).append("\n");
            }
        }
        FileManager.writeFile(outputFastqFile, bulider.toString(), true);
    }

    private static String generateName(String preFix, String name, String SampleName) {
        String[] items = name.split("_");
        String ret = name.replace(items[0], String.valueOf(preFix) + "_" + SampleName);
        return ret;
    }

    private static String findPreFix(String fileName) {
        String[] items;
        String[] stringArray = items = fileName.replace(".fastq", "").split("-");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (!item.equals("laa")) {
                if (item.startsWith("l")) {
                    return item.substring(1);
                }
                if (item.equals("3000") || item.equals("3100") || item.equals("3200") || item.equals("3300") || item.equals("3400") || item.equals("3500")) {
                    return item;
                }
            }
            ++n2;
        }
        return null;
    }

    private static void loadExtractedSequence(Map<String, OneMatch> sampleResult) {
        for (String name : sampleResult.keySet()) {
            OneMatch match = sampleResult.get(name);
            String trimedAndCorrectedSequence = null;
            String trimedAndCorrectedQuality = null;
            if (match.isForwardExist()) {
                trimedAndCorrectedSequence = match.getSequence().substring(match.getForwardStart() - 1, match.getForwardEnd());
                trimedAndCorrectedQuality = match.getQuality().substring(match.getForwardStart() - 1, match.getForwardEnd());
            } else {
                trimedAndCorrectedSequence = match.getSequence().substring(match.getReverseStart() - 1, match.getReverseEnd());
                trimedAndCorrectedQuality = match.getQuality().substring(match.getReverseStart() - 1, match.getReverseEnd());
            }
            match.setTrimedSequence(trimedAndCorrectedSequence);
            match.setTrimedQuality(trimedAndCorrectedQuality);
        }
    }

    private static void filleInSequence(Map<String, OneMatch> sampleResult, File fastaFile, Map<String, String> qualityMap) {
        HashMap<String, String> seqMap = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (i % 2 == 0) {
                String name = line.substring(1);
                seqMap.put(name, lines[i + 1].trim());
            }
            ++i;
        }
        for (OneMatch match : sampleResult.values()) {
            match.setSequence((String)seqMap.get(match.getName()));
            match.setQuality(qualityMap.get(match.getName()));
        }
    }

    private static void convertFastqFile(File fastqFile, File fastaFile, Map<String, String> qualityMap) throws Exception {
        LinkedHashMap<String, String> seqMap = new LinkedHashMap<String, String>();
        FastqToFasta.getSeqMap(fastqFile, seqMap, qualityMap);
        FastqToFasta.writeFastaFile(seqMap, fastaFile);
    }

    private static Map<String, OneMatch> collectConsensus(File fastaFile, Map<String, String> qualityMap, File backBone, StringBuilder allMatchResult) throws Exception {
        String matchResult = CollectSeqences.alignByCrossmatch(fastaFile, backBone);
        Map<String, List<OneMatch>> sampleResult = CollectSeqences.parseMatchResult(matchResult, allMatchResult);
        Map<String, OneMatch> SampleResultByLocus = CollectSquenceMamuE.AnalyzeTypingResult(sampleResult, qualityMap);
        return SampleResultByLocus;
    }

    private static Map<String, OneMatch> AnalyzeTypingResult(Map<String, List<OneMatch>> sampleResult, Map<String, String> qualityMap) {
        HashMap<String, OneMatch> SampleResultByName = new HashMap<String, OneMatch>();
        for (String seqName : sampleResult.keySet()) {
            List<OneMatch> matches = sampleResult.get(seqName);
            OneMatch bestTargetMatch = CollectSquenceMamuE.getBestTarget(matches, qualityMap.get(seqName));
            if (bestTargetMatch == null) continue;
            SampleResultByName.put(seqName, bestTargetMatch);
        }
        return SampleResultByName;
    }

    private static OneMatch getBestTarget(List<OneMatch> matches, String quality) {
        OneMatch bestTarget = null;
        int averageQ = 0;
        int score = 0;
        for (OneMatch match : matches) {
            int thisQ;
            if (match.isForwardExist() && match.getForwardTargetEnd() - match.getForwardTargetStart() > SIZE) {
                thisQ = CollectSquenceMamuE.getAverageQ(match.getForwardStart(), match.getForwardEnd(), quality);
                System.out.println(String.valueOf(match.getName()) + " forward average Q=" + thisQ);
                if (thisQ > averageQ) {
                    averageQ = thisQ;
                    score = match.getForwardScore();
                    bestTarget = match;
                }
            }
            if (!match.isReverseExist() || match.getReverseTargetEnd() - match.getReverseTargetStart() <= SIZE) continue;
            thisQ = CollectSquenceMamuE.getAverageQ(match.getReverseStart(), match.getReverseEnd(), quality);
            System.out.println(String.valueOf(match.getName()) + " reverse average Q=" + thisQ);
            if (thisQ <= averageQ) continue;
            averageQ = thisQ;
            score = match.getReverseScore();
            bestTarget = match;
        }
        if (bestTarget == null) {
            return null;
        }
        if (bestTarget.isForwardExist() && bestTarget.getForwardScore() == score) {
            bestTarget.setReverseExist(false);
        } else if (bestTarget.isReverseExist() && bestTarget.getReverseScore() == score) {
            bestTarget.setForwardExist(false);
        }
        return bestTarget;
    }

    private static int getAverageQ(int start, int end, String quality) {
        int sum = 0;
        int i = start - 1;
        while (i < end) {
            sum += quality.charAt(i) - 33;
            ++i;
        }
        return sum / (end - start + 1);
    }
}

