/*
 * Decompiled with CFR 0.152.
 */
package pacBio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;

public class BatchProbMatchSearch {
    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File refFile = new File(args[1]);
        File outputDir = new File(args[2]);
        Object[] files = fastaDir.listFiles();
        Arrays.sort(files);
        System.out.println(refFile.getName());
        StringBuilder log = new StringBuilder();
        LinkedHashMap<String, List<String>> hitMap = new LinkedHashMap<String, List<String>>();
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (((File)file).getName().endsWith("fasta")) {
                System.out.println("\t" + ((File)file).getName());
                log.append("----" + ((File)file).getName() + "\n");
                hitMap.put(((File)file).getName(), new ArrayList());
                File matchOutputFile = BatchProbMatchSearch.runMatchSearch((File)file, refFile);
                BatchProbMatchSearch.parseCMresult(matchOutputFile, (List)hitMap.get(((File)file).getName()), log);
            }
            ++n2;
        }
        BatchProbMatchSearch.writeOutput(refFile.getName(), outputDir, log, hitMap);
    }

    private static void writeOutput(String name, File outputDir, StringBuilder log, Map<String, List<String>> hitMap) {
        String gene = name.replace(".fa", "");
        File logFile = new File(outputDir, String.valueOf(gene) + "-log.txt");
        File zmwFile = new File(outputDir, String.valueOf(gene) + "-zmw.txt");
        FileManager.writeTextFile(logFile, log.toString(), true);
        StringBuilder zmwBuilder = new StringBuilder();
        int counter = 0;
        for (List<String> zmws : hitMap.values()) {
            for (String zmw : zmws) {
                zmwBuilder.append(zmw).append("\n");
            }
            counter += zmws.size();
        }
        FileManager.writeTextFile(zmwFile, zmwBuilder.toString(), true);
        System.out.println(String.valueOf(zmwFile.getAbsolutePath()) + " " + counter);
    }

    public static void parseCMresult(File matchResult, List<String> zmws, StringBuilder log) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(matchResult).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\\s+");
            if (line.indexOf("/ccs ") > 0 && items.length >= 12 && items[4].split("/").length == 3) {
                String readsName = items[4].trim();
                String zmw = readsName.split("/")[1];
                if (!zmws.contains(zmw)) {
                    zmws.add(zmw);
                }
                log.append(line).append("\n");
            }
            ++n2;
        }
    }

    private static File runMatchSearch(File file, File refFile) throws Exception {
        File tempOutputFile = File.createTempFile("out", "txt");
        tempOutputFile.deleteOnExit();
        String cmd = "/home/rwang/software/phrap/cross_match -minscore 75 " + file.getAbsolutePath() + " " + refFile.getAbsolutePath() + " > " + tempOutputFile.getAbsolutePath();
        System.out.println("cmd= " + cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tempOutputFile;
    }
}

