/*
 * Decompiled with CFR 0.152.
 */
package nmerCluster;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nmerCluster.Nmer;
import nmerCluster.RawReadPair;

public class NmerCluster {
    private static int BUFFER_SIZE = 40;

    public static void doNmerClustering(List<RawReadPair> readPairList, List<Nmer> nmerList, File outputDir, String outputNameBase) throws IOException {
        LinkedHashMap<String, List<RawReadPair>> destMap = new LinkedHashMap<String, List<RawReadPair>>();
        int count = 0;
        block0: for (RawReadPair pair : readPairList) {
            String sequenceA = pair.sequences[0];
            String sequenceB = pair.sequences[1];
            for (Nmer nmer : nmerList) {
                String targetNmer = nmer.getSequence();
                if (nmer.getDirection().equals("R")) {
                    targetNmer = NmerCluster.revComp(targetNmer);
                }
                if (sequenceA.indexOf(targetNmer) > -1 && NmerCluster.withinRange(sequenceA.indexOf(targetNmer), nmer.getPosition())) {
                    NmerCluster.addToDestMap(nmer.getDestination(), destMap, pair);
                    ++count;
                    continue block0;
                }
                if (sequenceB.indexOf(targetNmer) <= -1 || !NmerCluster.withinRange(sequenceB.indexOf(targetNmer), nmer.getPosition())) continue;
                NmerCluster.addToDestMap(nmer.getDestination(), destMap, pair);
                ++count;
                continue block0;
            }
        }
        System.out.println("Total read pairs=" + readPairList.size());
        System.out.println("Number of pairs clustered=" + count);
        for (String exon : destMap.keySet()) {
            System.out.println("\t" + exon + " " + ((List)destMap.get(exon)).size());
        }
        NmerCluster.writeToFile(destMap, outputDir, outputNameBase);
    }

    private static void writeToFile(Map<String, List<RawReadPair>> destMap, File outputDir, String outputNameBase) throws IOException {
        File clusterFastaDir = new File(outputDir, outputNameBase);
        if (!clusterFastaDir.exists()) {
            clusterFastaDir.mkdirs();
        }
        for (String locus : destMap.keySet()) {
            File fastaFile = new File(clusterFastaDir, String.valueOf(outputNameBase) + "-" + NmerCluster.renameLocusExon(locus) + ".fa");
            BufferedWriter writer = new BufferedWriter(new FileWriter(fastaFile));
            List<RawReadPair> readPairList = destMap.get(locus);
            Collections.shuffle(readPairList);
            for (RawReadPair readPair : readPairList) {
                writer.write(">" + readPair.id + "/1" + "\n");
                writer.write(String.valueOf(readPair.sequences[0]) + "\n");
                writer.write(">" + readPair.id + "/2" + "\n");
                writer.write(String.valueOf(readPair.sequences[1]) + "\n");
            }
            writer.flush();
            writer.close();
        }
    }

    public static String renameLocusExon(String locusExon) {
        String[] items = locusExon.split("-");
        String fix = "exon";
        if (items[1].equals("23")) {
            fix = "bridge";
        } else if (items[1].equals("45")) {
            fix = "bridge";
        }
        return String.valueOf(items[0]) + "-" + fix + items[1];
    }

    private static void addToDestMap(List<String> destinations, Map<String, List<RawReadPair>> destMap, RawReadPair pair) {
        for (String dest : destinations) {
            if (!destMap.containsKey(dest)) {
                destMap.put(dest, new ArrayList());
            }
            destMap.get(dest).add(pair);
        }
    }

    private static boolean withinRange(int hit, int targetPosition) {
        if (hit == targetPosition) {
            return true;
        }
        if (hit > targetPosition && hit <= targetPosition + BUFFER_SIZE) {
            return true;
        }
        return hit < targetPosition && hit >= targetPosition - BUFFER_SIZE;
    }

    public static String revComp(String seq) {
        String revcomp = new StringBuilder(seq.replace('A', 'B').replace('T', 'A').replace('B', 'T').replace('C', 'D').replace('G', 'C').replace('D', 'G')).reverse().toString();
        return revcomp;
    }
}

