/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import newRuleset.IntronBoundary;
import newRuleset.Tools;

public class padEnd {
    public static void main(String[] args) throws Exception {
        File[] files;
        File rulesetDir = new File(args[0]);
        File intronDir = new File(args[1]);
        File outputDir = new File(args[2]);
        Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles = padEnd.recordSpecialAllele(intronDir);
        File[] fileArray = files = rulesetDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("fa")) {
                System.out.println("----work on " + file.getName());
                padEnd.workOnePadding(file, specialAlleles, outputDir);
            }
            ++n2;
        }
    }

    private static Map<String, Map<Integer, Map<String, IntronBoundary>>> recordSpecialAllele(File intronDir) {
        File[] allfiles = intronDir.listFiles();
        LinkedHashMap<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles = new LinkedHashMap<String, Map<Integer, Map<String, IntronBoundary>>>();
        File[] fileArray = allfiles;
        int n = allfiles.length;
        int n2 = 0;
        while (n2 < n) {
            String locusName;
            File file = fileArray[n2];
            if (file.getName().indexOf("intron") > 0 && !(locusName = file.getName().split("-")[0]).equals("S") && !locusName.equals("T")) {
                Integer intronNumber = Integer.valueOf(String.valueOf(file.getName().charAt(file.getName().length() - 4)));
                if (!specialAlleles.containsKey(locusName)) {
                    specialAlleles.put(locusName, new LinkedHashMap());
                }
                ((Map)specialAlleles.get(locusName)).put(intronNumber, new LinkedHashMap());
                Map<String, String> seq = Tools.getSequences(file);
                for (String type : seq.keySet()) {
                    String start = "";
                    String end = "";
                    if (seq.get(type).length() < 2) {
                        start = "..";
                        end = "..";
                    } else {
                        start = seq.get(type).substring(0, 2);
                        end = seq.get(type).substring(seq.get(type).length() - 2, seq.get(type).length());
                    }
                    boolean doRecord = false;
                    if (locusName.equals("DQB1") && intronNumber == 4) {
                        if (!start.equals("GT") && !start.equals("**")) {
                            doRecord = true;
                            System.out.println(String.valueOf(type) + " intron" + intronNumber + " " + start + " " + end);
                        }
                    } else if (!start.equals("GT") && !start.equals("**") || !end.equals("AG") && !end.equals("**")) {
                        doRecord = true;
                        System.out.println(String.valueOf(type) + " intron" + intronNumber + " " + start + " " + end);
                    }
                    if (!doRecord) continue;
                    IntronBoundary intronBoundary = new IntronBoundary(start, end);
                    ((Map)((Map)specialAlleles.get(locusName)).get(intronNumber)).put(type, intronBoundary);
                }
            }
            ++n2;
        }
        return specialAlleles;
    }

    private static void workOnePadding(File file, Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles, File outputDir) {
        String[] genesCI = new String[]{"A", "B", "C"};
        String[] genesCIIg1 = new String[]{"DPA1", "DQA1"};
        String[] genesCIIg2 = new String[]{"DPB1", "DQB1", "DRB1"};
        String[] genesMIC = new String[]{"MICA", "MICB"};
        String[] subTargetsCI = new String[]{"exon2", "exon3", "exon4", "exon5"};
        String[] subTargetsCIIg1 = new String[]{"exon2", "exon3"};
        String[] subTargetsCIIg2 = new String[]{"exon2", "exon3", "exon4"};
        String[] subTargetsMIC = new String[]{"exon2", "exon3", "exon4", "exon5"};
        String locusName = file.getName().split("-")[0];
        String region = file.getName().split("-")[1].replace(".fa", "");
        if (Arrays.asList(genesCI).contains(locusName) && Arrays.asList(subTargetsCI).contains(region)) {
            padEnd.padBeginningAndEnd(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (Arrays.asList(genesCIIg1).contains(locusName) && Arrays.asList(subTargetsCIIg1).contains(region)) {
            padEnd.padBeginningAndEnd(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (Arrays.asList(genesCIIg2).contains(locusName) && Arrays.asList(subTargetsCIIg2).contains(region)) {
            padEnd.padBeginningAndEnd(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (Arrays.asList(genesMIC).contains(locusName) && Arrays.asList(subTargetsMIC).contains(region)) {
            padEnd.padBeginningAndEnd(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (region.equals("exon1")) {
            padEnd.padStartExon(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (Arrays.asList(genesMIC).contains(locusName) && region.equals("bridge45")) {
            padEnd.padMiddleSingleEnd(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (region.equals("bridge23")) {
            padEnd.padMiddleBothEnd(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (Arrays.asList(genesCI).contains(locusName) && region.equals("exon67")) {
            padEnd.padBeginningAndMiddleBothEnd(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (Arrays.asList(genesMIC).contains(locusName) && region.equals("exon6")) {
            padEnd.padEndExon(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else if (Arrays.asList(genesCIIg1).contains(locusName) && region.equals("exon4")) {
            padEnd.padEndExon(file, specialAlleles, locusName, region, new File(outputDir, file.getName()));
        } else {
            System.out.println("??? How to padding for " + file.getName());
        }
    }

    private static void padEndExon(File input, Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles, String locusName, String region, File output) {
        System.out.println("padEndExon for " + locusName + "-" + region);
        Map<String, String> sequences = Tools.getSequences(input);
        Integer exonNumber = new Integer(region.replace("exon", ""));
        Integer intronNumber1 = exonNumber - 1;
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append(">").append(name).append("\n");
            String thisLocusName = name.split("\\*")[0];
            if (!specialAlleles.containsKey(thisLocusName) || !specialAlleles.get(thisLocusName).containsKey(intronNumber1)) {
                System.out.println("no record for intron " + intronNumber1);
            }
            Map<String, IntronBoundary> special = specialAlleles.get(thisLocusName).get(intronNumber1);
            String prepend = "AG";
            if (special.containsKey(name)) {
                prepend = special.get(name).getEndingBases();
            }
            builder.append(prepend).append(sequences.get(name)).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void padMiddleSingleEnd(File input, Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles, String locusName, String region, File output) {
        System.out.println("padMiddleSingleEnd for " + locusName + "-" + region);
        Map<String, String> sequences = Tools.getSequences(input);
        String combinedNumber = region.replace("exon", "").replace("bridge", "");
        Integer intronNumber = new Integer(combinedNumber.substring(0, 1));
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append(">").append(name).append("\n");
            String thisLocusName = name.split("\\*")[0];
            if (!specialAlleles.containsKey(thisLocusName) || !specialAlleles.get(thisLocusName).containsKey(intronNumber)) {
                System.out.println("no record for intron " + intronNumber);
            }
            Map<String, IntronBoundary> special1 = specialAlleles.get(thisLocusName).get(intronNumber);
            String right = "AG";
            if (special1.containsKey(name)) {
                right = special1.get(name).getEndingBases();
            }
            String newSeparator = "XXXXXXXXXX" + right;
            builder.append(sequences.get(name).replaceAll("XXXXXXXXXX", newSeparator)).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void padBeginningAndMiddleBothEnd(File input, Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles, String locusName, String region, File output) {
        System.out.println("padBeginningAndMiddleBothEnd for " + locusName + "-" + region);
        Map<String, String> sequences = Tools.getSequences(input);
        String combinedNumber = region.replace("exon", "").replace("bridge", "");
        Integer intronNumber = new Integer(combinedNumber.substring(0, 1));
        Integer intronNumber0 = intronNumber - 1;
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append(">").append(name).append("\n");
            String thisLocusName = name.split("\\*")[0];
            if (!(specialAlleles.containsKey(thisLocusName) && specialAlleles.get(thisLocusName).containsKey(intronNumber) && specialAlleles.get(thisLocusName).containsKey(intronNumber0))) {
                System.out.println("no record for intron " + intronNumber + " or " + intronNumber0);
            }
            Map<String, IntronBoundary> special1 = specialAlleles.get(thisLocusName).get(intronNumber);
            Map<String, IntronBoundary> special0 = specialAlleles.get(thisLocusName).get(intronNumber0);
            String start = "AG";
            String left = "GT";
            String right = "AG";
            if (special1.containsKey(name)) {
                left = special1.get(name).getBeginningBases();
                right = special1.get(name).getEndingBases();
            }
            if (special0.containsKey(name)) {
                start = special0.get(name).getEndingBases();
            }
            String newSeparator = String.valueOf(left) + "XXXXXXXXXX" + right;
            builder.append(start).append(sequences.get(name).replaceAll("XXXXXXXXXX", newSeparator)).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void padMiddleBothEnd(File input, Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles, String locusName, String region, File output) {
        System.out.println("padMiddleBothEnd for " + locusName + "-" + region);
        Map<String, String> sequences = Tools.getSequences(input);
        String combinedNumber = region.replace("exon", "").replace("bridge", "");
        Integer intronNumber = new Integer(combinedNumber.substring(0, 1));
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append(">").append(name).append("\n");
            String thisLocusName = name.split("\\*")[0];
            if (!specialAlleles.containsKey(thisLocusName) || !specialAlleles.get(thisLocusName).containsKey(intronNumber)) {
                System.out.println("no record for intron " + intronNumber);
            }
            Map<String, IntronBoundary> special1 = specialAlleles.get(thisLocusName).get(intronNumber);
            String left = "GT";
            String right = "AG";
            if (special1.containsKey(name)) {
                left = special1.get(name).getBeginningBases();
                right = special1.get(name).getEndingBases();
            }
            String newSeparator = String.valueOf(left) + "XXXXXXXXXX" + right;
            builder.append(sequences.get(name).replaceAll("XXXXXXXXXX", newSeparator)).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void padStartExon(File input, Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles, String locusName, String region, File output) {
        Integer exonNumber;
        System.out.println("padOnlyAtEnd for " + locusName + "-" + region);
        Map<String, String> sequences = Tools.getSequences(input);
        Integer intronNumber2 = exonNumber = new Integer(region.replace("exon", ""));
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append(">").append(name).append("\n");
            String thisLocusName = name.split("\\*")[0];
            if (!specialAlleles.containsKey(thisLocusName) || !specialAlleles.get(thisLocusName).containsKey(intronNumber2)) {
                System.out.println("no record for intron " + intronNumber2);
            }
            Map<String, IntronBoundary> special2 = specialAlleles.get(thisLocusName).get(intronNumber2);
            String postpend = "GT";
            if (special2.containsKey(name)) {
                postpend = special2.get(name).getBeginningBases();
            }
            builder.append(sequences.get(name)).append(postpend).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static void padBeginningAndEnd(File input, Map<String, Map<Integer, Map<String, IntronBoundary>>> specialAlleles, String locusName, String region, File output) {
        System.out.println("paddBeginningAndEnd for " + locusName + "-" + region);
        Map<String, String> sequences = Tools.getSequences(input);
        Integer exonNumber = new Integer(region.replace("exon", ""));
        Integer intronNumber1 = exonNumber - 1;
        Integer intronNumber2 = exonNumber;
        StringBuilder builder = new StringBuilder();
        for (String name : sequences.keySet()) {
            builder.append(">").append(name).append("\n");
            String thisLocusName = name.split("\\*")[0];
            if (!(specialAlleles.containsKey(thisLocusName) && specialAlleles.get(thisLocusName).containsKey(intronNumber1) && specialAlleles.get(thisLocusName).containsKey(intronNumber2))) {
                System.out.println("no record for intron " + intronNumber1 + " " + intronNumber2);
            }
            Map<String, IntronBoundary> special1 = specialAlleles.get(thisLocusName).get(intronNumber1);
            Map<String, IntronBoundary> special2 = specialAlleles.get(thisLocusName).get(intronNumber2);
            String prepend = "AG";
            String postpend = "GT";
            if (special1.containsKey(name)) {
                prepend = special1.get(name).getEndingBases();
            }
            if (special2.containsKey(name)) {
                postpend = special2.get(name).getBeginningBases();
            }
            builder.append(prepend).append(sequences.get(name)).append(postpend).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }
}

