/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import newRuleset.Tools;

public class GenerateBridge23 {
    static int TRIM_SIZE = 80;

    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File output = new File(args[1]);
        String header = args[2];
        File exon2 = new File(input, String.valueOf(header) + "-exon2.fa");
        File exon3 = new File(input, String.valueOf(header) + "-exon3.fa");
        File bridge23 = new File(output, String.valueOf(header) + "-bridge23.fa");
        Map<String, String> seq2 = Tools.getSequences(exon2);
        Map<String, String> seq3 = Tools.getSequences(exon3);
        LinkedHashMap<String, String> bridgeSeq23 = new LinkedHashMap<String, String>();
        GenerateBridge23.combineAndCutSequences(seq2, seq3, bridgeSeq23);
        GenerateBridge23.writeFastaOutput(bridgeSeq23, bridge23);
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static void combineAndCutSequences(Map<String, String> seq2, Map<String, String> seq3, Map<String, String> bridgeSeq23) {
        for (String name : seq2.keySet()) {
            if (name.indexOf("sudo") > 0) continue;
            if (seq3.get(name) != null) {
                bridgeSeq23.put(name, String.valueOf(seq2.get(name).substring(TRIM_SIZE)) + "XXXXXXXXXX" + seq3.get(name).substring(0, seq3.get(name).length() - TRIM_SIZE));
                continue;
            }
            System.out.println(String.valueOf(name) + " no exon3");
        }
    }
}

