/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class GenerateACbridge68 {
    public static void main(String[] args) throws Exception {
        File inputExon67 = new File(args[0]);
        File inputIntron7 = new File(args[1]);
        File inputExon8 = new File(args[2]);
        File output = new File(args[3]);
        String header = args[4];
        Map<String, String> seq67 = GenerateACbridge68.getSequences(inputExon67);
        Map<String, String> intron7 = GenerateACbridge68.getSequences(inputIntron7);
        Map<String, String> seq8 = GenerateACbridge68.getSequences(inputExon8);
        LinkedHashMap<String, String> seq678 = new LinkedHashMap<String, String>();
        GenerateACbridge68.combineAndCutSequences(seq67, intron7, seq8, seq678, header);
        GenerateACbridge68.writeFastaOutput(seq678, new File(output, String.valueOf(header) + "-bridge68.fa"));
    }

    private static void writeFastaOutput(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        for (String name : seq.keySet()) {
            sb.append(">").append(name).append("\n");
            if (seq.get(name).indexOf("*") >= 0) {
                System.out.println(String.valueOf(name) + " contains unknown char ");
            }
            sb.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
        System.out.println(outfile.getAbsolutePath());
    }

    private static void combineAndCutSequences(Map<String, String> seq67, Map<String, String> intron7, Map<String, String> seq8, Map<String, String> seq678, String header) {
        for (String name : seq8.keySet()) {
            if (seq67.containsKey(name) && intron7.containsKey(name)) {
                seq678.put(name, GenerateACbridge68.customTrim(seq67.get(name), intron7.get(name), seq8.get(name), header));
                continue;
            }
            if (seq67.containsKey(name)) {
                seq678.put(name, GenerateACbridge68.customTrim(seq67.get(name), GenerateACbridge68.getIntronPadding(name, intron7), seq8.get(name), header));
                continue;
            }
            if (!intron7.containsKey(name)) {
                System.out.println("No intron " + name);
                continue;
            }
            if (seq67.containsKey(name)) continue;
            System.out.println(name);
        }
    }

    private static String customTrim(String exon67, String intron7, String exon8, String header) {
        String left = null;
        String right = null;
        if (header.equals("A")) {
            left = exon67.split("XXXXXXXXXX")[0];
            right = String.valueOf(intron7.substring(intron7.length() - 125, intron7.length())) + exon8;
        } else if (header.equals("C")) {
            left = exon67;
            right = String.valueOf(intron7.substring(intron7.length() - 70, intron7.length())) + exon8;
        }
        return String.valueOf(left) + "XXXXXXXXXX" + right;
    }

    public static String getClosestPaddingAllele(String alleleName, Map<String, String> allSeq) {
        String[] nameElements = alleleName.split(":");
        int fieldCount = 1;
        while (fieldCount < nameElements.length) {
            String searchName = "";
            int i = 0;
            while (i < nameElements.length - fieldCount) {
                searchName = searchName.length() > 0 ? String.valueOf(searchName) + ":" + nameElements[i] : nameElements[i];
                ++i;
            }
            for (String type : allSeq.keySet()) {
                String seq;
                if (!type.startsWith(String.valueOf(searchName) + ":") || (seq = allSeq.get(type)).indexOf("*") >= 0) continue;
                return type;
            }
            ++fieldCount;
        }
        return null;
    }

    private static String getIntronPadding(String name, Map<String, String> intron7) {
        String paddName = GenerateACbridge68.getClosestPaddingAllele(name, intron7);
        if (paddName != null) {
            System.out.println(String.valueOf(name) + " -> " + paddName);
            return intron7.get(paddName);
        }
        System.out.println("!!!!!!! No close memeber for " + name);
        return null;
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static void outputAmb(Map<String, String> seq, File outfile) {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap seqName = new LinkedHashMap();
        for (String name : seq.keySet()) {
            if (!seqName.containsKey(seq.get(name))) {
                seqName.put(seq.get(name), new ArrayList());
            }
            ((List)seqName.get(seq.get(name))).add(name);
        }
        for (String sequence : seqName.keySet()) {
            if (((List)seqName.get(sequence)).size() <= 1) continue;
            sb.append(GenerateACbridge68.createOutput((List)seqName.get(sequence))).append("\n");
        }
        FileManager.writeTextFile(outfile, sb.toString(), true);
    }

    private static String createOutput(List<String> list) {
        String out = String.valueOf(list.get(0)) + "R";
        for (String n : list) {
            out = String.valueOf(out) + "\t" + n;
        }
        return out;
    }
}

