/*
 * Decompiled with CFR 0.152.
 */
package newRuleset;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class CompareRulesetFile {
    public static void main(String[] args) throws Exception {
        File[] files;
        File newFastaDir = new File(args[0]);
        File oldFastaDir = new File(args[1]);
        String gene = args[2];
        File[] fileArray = files = newFastaDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File newFastaFile = fileArray[n2];
            if (newFastaFile.getName().startsWith(gene)) {
                System.out.println(newFastaFile.getName());
                File oldFastaFile = new File(oldFastaDir, newFastaFile.getName());
                System.out.println(String.valueOf(oldFastaFile.getAbsolutePath()) + " " + oldFastaFile.exists());
                if (oldFastaFile.exists()) {
                    System.out.println("comparing " + newFastaFile.getName() + " " + oldFastaFile.getName());
                    CompareRulesetFile.compareFasta(newFastaFile, oldFastaFile);
                }
            }
            ++n2;
        }
    }

    private static void compareAmb(File newAmbFile, File oldAmbFile) {
        Map<String, String> newHapNames = CompareRulesetFile.populateHapAmbNames(newAmbFile);
        Map<String, String> oldHapNames = CompareRulesetFile.populateHapAmbNames(oldAmbFile);
        CompareRulesetFile.checkCrossLocus(oldAmbFile);
        for (String name : newHapNames.keySet()) {
            String newAmbName = newHapNames.get(name);
            if (!oldHapNames.containsKey(name)) continue;
            String oldAmbName = oldHapNames.get(name);
            oldAmbName.substring(0, oldAmbName.length() - 1).equals(newAmbName.substring(0, newAmbName.length() - 1));
        }
        for (String name : oldHapNames.keySet()) {
            String oldAmbName = oldHapNames.get(name);
            if (newHapNames.containsKey(name) || newHapNames.containsKey(String.valueOf(name) + ":01")) continue;
            System.out.println(">>>>>>>>>>>>>>>>>>>>missing amb member " + name + " -> " + oldAmbName);
        }
    }

    private static void checkCrossLocus(File oldAmbFile) {
        String[] lines;
        HashMap hapNames = new HashMap();
        String[] stringArray = lines = FileManager.readTextFile(oldAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    if (!items[i].trim().split("\\*")[0].equals(gname.split("\\*")[0])) {
                        System.out.println("!!!!!!!!!! cross locus amb " + gname + " " + items[i].trim());
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    public static Map<String, String> populateHapAmbNames(File hapAmbFile) {
        String[] lines;
        HashMap<String, String> hapNames = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
        return hapNames;
    }

    private static void compareFasta(File newFastaFile, File oldFastaFile) {
        Map<String, String> newSeq = CompareRulesetFile.getSequences(newFastaFile);
        Map<String, String> oldSeq = CompareRulesetFile.getSequences(oldFastaFile);
        Map<String, String> anchorMap = CompareRulesetFile.loadAnchorMap(newSeq);
        for (String name : newSeq.keySet()) {
            String locus = name.split("\\*")[0];
            String anchor = newSeq.get(anchorMap.get(locus)).trim();
            int size = newSeq.get(anchorMap.get(locus)).length();
            if (newSeq.get(name).indexOf("N") > -1) {
                System.out.println(String.valueOf(name) + " contains N");
                System.out.println(newSeq.get(name).trim());
            }
            if (newSeq.get(name).trim().length() != size && !oldSeq.containsKey(name)) {
                System.out.println("----diff size new seq " + name + " " + (newSeq.get(name).length() - size));
                System.out.println("this size=" + newSeq.get(name).trim().length());
                System.out.println(newSeq.get(name).trim());
                System.out.println("anchor size=" + anchor.length());
                System.out.println(anchor);
            }
            if (!oldSeq.containsKey(name)) {
                System.out.println("----new " + name + " " + newSeq.get(name).trim().length());
                continue;
            }
            if (oldSeq.get(name).equals(newSeq.get(name))) continue;
            if ((newFastaFile.getName().equals("DPB1-exon4.fa") || newFastaFile.getName().equals("DQB1-exon4.fa") || newFastaFile.getName().equals("DRB1-exon4.fa")) && oldSeq.get(name).length() == 113 && newSeq.get(name).length() == 115) {
                if (newSeq.get(name).substring(0, 113).equals(oldSeq.get(name))) continue;
                System.out.println("!!!! diff seq than last ruleset DPB1 " + name);
                System.out.println("new size=" + newSeq.get(name).trim().length());
                System.out.println(newSeq.get(name).trim());
                System.out.println("old size=" + oldSeq.get(name).trim().length());
                System.out.println(oldSeq.get(name).trim());
                continue;
            }
            System.out.println("!!!! diff seq than last ruleset " + name);
            System.out.println("new size=" + newSeq.get(name).trim().length());
            System.out.println(newSeq.get(name).trim());
            System.out.println("old size=" + oldSeq.get(name).trim().length());
            System.out.println(oldSeq.get(name).trim());
        }
        for (String name : oldSeq.keySet()) {
            if (newSeq.containsKey(name) || newSeq.containsKey(String.valueOf(name) + ":01")) continue;
            System.out.println("-----------------sudo " + name);
        }
    }

    private static Map<String, String> loadAnchorMap(Map<String, String> newSeq) {
        HashMap<String, String> anchorMap = new HashMap<String, String>();
        for (String name : newSeq.keySet()) {
            String locus = name.split("\\*")[0];
            if (anchorMap.containsKey(locus)) continue;
            anchorMap.put(locus, name);
        }
        return anchorMap;
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }
}

