/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.Map;

public class SnpConfig {
    public static int MAX_DISCREPENCY = 100000;
    public static String FLAG_CHAR = "*";
    public static int ODD_LIMIT = 500;
    private double noisePeak = 0.15;
    private double noisePeakLow = 0.13;
    private double noiseRatio = 0.125;
    private double htPeak = 0.2;
    private double htRatio = 0.25;
    private int qualAssureHomo = 55;
    private int qualAssure = 40;
    private int qualCutoff = 10;
    private int qualAroundCutoff = 22;
    private int qualAroundCutoffHigh = 35;
    private int lengthFlanking = 20;
    private int lengthRefSeq = 10;
    private double trimCutoff = 0.025;
    private String delimeter = "_";
    private int cellLinePos = 0;
    private int refChromatQuality = 35;
    private int refChromatQualityHigh = 55;
    private boolean hasHomoFile = false;
    private String homoFilePath;
    private boolean merge = true;
    private boolean probablityFilter = true;
    private boolean homoExist = false;
    private boolean flag = true;
    private int gapInitPenalty = -4;
    private boolean useAbi = false;
    private boolean errorProof = false;

    public void init(Map opts) {
        for (String op : opts.keySet()) {
            if (op.equals("x")) {
                this.setHomoExist(true);
                continue;
            }
            if (op.equals("a")) {
                this.setUseAbi(true);
                continue;
            }
            if (op.equals("e")) {
                this.setErrorProof(true);
                continue;
            }
            if (op.equals("b")) {
                this.setProbablityFilter(false);
                continue;
            }
            if (op.equals("n")) {
                this.setMerge(false);
                continue;
            }
            if (op.equals("o")) {
                this.setFlag(false);
                continue;
            }
            if (op.equals("q")) {
                this.setQualAssureHomo(60);
                this.setNoisePeak(0.12);
                this.setNoisePeakLow(0.1);
                this.setNoiseRatio(0.1);
                this.setHtPeak(0.18);
                this.setHtRatio(0.2);
                continue;
            }
            if (op.equals("f")) {
                this.setQualAssureHomo((Integer)opts.get(op));
                continue;
            }
            if (op.equals("u")) {
                this.setQualCutoff((Integer)opts.get(op));
                continue;
            }
            if (op.equals("t")) {
                this.setQualAroundCutoff((Integer)opts.get(op));
                continue;
            }
            if (op.equals("s")) {
                this.setQualAroundCutoffHigh((Integer)opts.get(op));
                continue;
            }
            if (op.equals("p")) {
                this.setTrimCutoff(1.0 / (double)((Integer)opts.get(op)).intValue());
                System.out.println(this.getTrimCutoff());
                continue;
            }
            if (op.equals("i")) {
                this.setQualAssure((Integer)opts.get(op));
                continue;
            }
            if (op.equals("l")) {
                this.setLengthFlanking((Integer)opts.get(op));
                continue;
            }
            if (op.equals("d")) {
                this.setDelimeter((String)opts.get(op));
                continue;
            }
            if (op.equals("c")) {
                this.setCellLinePos((Integer)opts.get(op));
                continue;
            }
            if (op.equals("m")) {
                String fn = (String)opts.get(op);
                File file = new File(fn);
                if (!file.exists() || !file.isFile() || !file.canRead()) continue;
                this.setHasHomoFile(true);
                this.setHomoFilePath(fn);
                continue;
            }
            if (!op.equals("g")) continue;
            this.setGapInitPenalty((Integer)opts.get(op));
        }
    }

    public int getCellLinePos() {
        return this.cellLinePos;
    }

    public void setCellLinePos(int cellLinePos) {
        this.cellLinePos = cellLinePos;
    }

    public String getDelimeter() {
        return this.delimeter;
    }

    public void setDelimeter(String delimeter) {
        this.delimeter = delimeter;
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public boolean isHasHomoFile() {
        return this.hasHomoFile;
    }

    public void setHasHomoFile(boolean hasHomoFile) {
        this.hasHomoFile = hasHomoFile;
    }

    public boolean isHomoExist() {
        return this.homoExist;
    }

    public void setHomoExist(boolean homoExist) {
        this.homoExist = homoExist;
    }

    public String getHomoFilePath() {
        return this.homoFilePath;
    }

    public void setHomoFilePath(String homoFilePath) {
        this.homoFilePath = homoFilePath;
    }

    public double getHtPeak() {
        return this.htPeak;
    }

    public void setHtPeak(double htPeak) {
        this.htPeak = htPeak;
    }

    public double getHtRatio() {
        return this.htRatio;
    }

    public void setHtRatio(double htRatio) {
        this.htRatio = htRatio;
    }

    public int getLengthFlanking() {
        return this.lengthFlanking;
    }

    public void setLengthFlanking(int lengthFlanking) {
        this.lengthFlanking = lengthFlanking;
    }

    public int getLengthRefSeq() {
        return this.lengthRefSeq;
    }

    public void setLengthRefSeq(int lengthRefSeq) {
        this.lengthRefSeq = lengthRefSeq;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public double getNoisePeak() {
        return this.noisePeak;
    }

    public void setNoisePeak(double noisePeak) {
        this.noisePeak = noisePeak;
    }

    public double getNoisePeakLow() {
        return this.noisePeakLow;
    }

    public void setNoisePeakLow(double noisePeakLow) {
        this.noisePeakLow = noisePeakLow;
    }

    public double getNoiseRatio() {
        return this.noiseRatio;
    }

    public void setNoiseRatio(double noiseRatio) {
        this.noiseRatio = noiseRatio;
    }

    public boolean isProbablityFilter() {
        return this.probablityFilter;
    }

    public void setProbablityFilter(boolean probablityFilter) {
        this.probablityFilter = probablityFilter;
    }

    public int getQualAroundCutoff() {
        return this.qualAroundCutoff;
    }

    public void setQualAroundCutoff(int qualAroundCutoff) {
        this.qualAroundCutoff = qualAroundCutoff;
    }

    public int getQualAroundCutoffHigh() {
        return this.qualAroundCutoffHigh;
    }

    public void setQualAroundCutoffHigh(int qualAroundCutoffHigh) {
        this.qualAroundCutoffHigh = qualAroundCutoffHigh;
    }

    public int getQualAssure() {
        return this.qualAssure;
    }

    public void setQualAssure(int qualAssure) {
        this.qualAssure = qualAssure;
    }

    public int getQualAssureHomo() {
        return this.qualAssureHomo;
    }

    public void setQualAssureHomo(int qualAssureHomo) {
        this.qualAssureHomo = qualAssureHomo;
    }

    public int getQualCutoff() {
        return this.qualCutoff;
    }

    public void setQualCutoff(int qualCutoff) {
        this.qualCutoff = qualCutoff;
    }

    public int getRefChromatQuality() {
        return this.refChromatQuality;
    }

    public void setRefChromatQuality(int refChromatQuality) {
        this.refChromatQuality = refChromatQuality;
    }

    public int getRefChromatQualityHigh() {
        return this.refChromatQualityHigh;
    }

    public void setRefChromatQualityHigh(int refChromatQualityHigh) {
        this.refChromatQualityHigh = refChromatQualityHigh;
    }

    public double getTrimCutoff() {
        return this.trimCutoff;
    }

    public void setTrimCutoff(double trimCutoff) {
        this.trimCutoff = trimCutoff;
    }

    public int getGapInitPenalty() {
        return this.gapInitPenalty;
    }

    public void setGapInitPenalty(int gapInitPenalty) {
        this.gapInitPenalty = gapInitPenalty;
    }

    public boolean isUseAbi() {
        return this.useAbi;
    }

    public void setUseAbi(boolean useAbi) {
        this.useAbi = useAbi;
    }

    public boolean isErrorProof() {
        return this.errorProof;
    }

    public void setErrorProof(boolean errorProof) {
        this.errorProof = errorProof;
    }
}

