/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import misc.FileHandler;

public class SnpCommon {
    public static int[] getAveQualAround3(int chrPos, String chrQuals, int offset) {
        int qualLeft3 = 0;
        int qualRight3 = 0;
        int qual3 = 0;
        String[] quals = chrQuals.trim().split("\\s+");
        int i = chrPos - offset - 1;
        while (i < chrPos - 1) {
            if (i >= 0 && i < quals.length) {
                qualLeft3 += new Integer(quals[i]).intValue();
            }
            ++i;
        }
        i = chrPos + 2;
        while (i < chrPos + offset + 2) {
            if (i >= 0 && i < quals.length) {
                qualRight3 += new Integer(quals[i]).intValue();
            }
            ++i;
        }
        i = chrPos - 1;
        while (i < chrPos + 2) {
            if (i >= 0 && i < quals.length) {
                qual3 += new Integer(quals[i]).intValue();
            }
            ++i;
        }
        int[] ret = new int[]{qualLeft3 / offset, qualRight3 / offset, qual3 / 3};
        return ret;
    }

    public static int[] getAveQualAround(int chrPos, String chrQuals, int offset) {
        int qualLeft = 0;
        int qualRight = 0;
        String[] quals = chrQuals.trim().split("\\s+");
        int i = chrPos - offset;
        while (i < chrPos) {
            if (i >= 0 && i < quals.length) {
                qualLeft += new Integer(quals[i]).intValue();
            }
            ++i;
        }
        i = chrPos + 1;
        while (i < chrPos + offset + 1) {
            if (i >= 0 && i < quals.length) {
                qualRight += new Integer(quals[i]).intValue();
            }
            ++i;
        }
        int[] ret = new int[]{qualLeft / offset, qualRight / offset};
        return ret;
    }

    public static List getHomoCellLines(String fn) throws IOException {
        ArrayList<String> homoClList = new ArrayList<String>();
        FileHandler handler = new FileHandler();
        List data = handler.readFile(fn);
        Iterator it = data.iterator();
        while (it.hasNext()) {
            String cl = ((String)it.next()).trim();
            if (cl.length() <= 0) continue;
            homoClList.add(cl);
        }
        return homoClList;
    }

    public static boolean passContQual(int chrPos, String chrQuals, int offset, int cutoff) {
        boolean ret = false;
        String[] quals = chrQuals.trim().split("\\s+");
        int i = chrPos - offset;
        while (i < chrPos + offset + 1) {
            if (i >= 0 && i < quals.length && new Integer(quals[i]) > cutoff) {
                return true;
            }
            ++i;
        }
        return ret;
    }

    public static boolean isSameCall(String r1, String r2) {
        if (r1.equals(r2)) {
            return true;
        }
        if (r1.split("/").length != r2.split("/").length) {
            return false;
        }
        if (r1.split("/").length == 1 && r2.split("/").length == 1) {
            return false;
        }
        if (r1.split("/").length == 2 && r2.split("/").length == 2) {
            return r1.charAt(0) == r2.charAt(2) && r1.charAt(2) == r2.charAt(0);
        }
        return false;
    }

    public static String[] formatBaseCall(String call) {
        String tcall = call.split("\\(")[0];
        String qual = call.split("\\(")[1];
        qual = qual.substring(0, qual.length() - 1);
        if (tcall.charAt(0) == '?') {
            tcall = tcall.substring(1);
        }
        String[] ret = new String[]{tcall, qual};
        return ret;
    }
}

