/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ShiftRunCoord {
    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        List<Map<String, String>> list = ShiftRunCoord.initShiftList();
        File fromfn = null;
        File tofn = null;
        for (Map<String, String> coords : list) {
            for (String from : coords.keySet()) {
                fromfn = ShiftRunCoord.findFile(inputDir, from);
                tofn = ShiftRunCoord.findFile(inputDir, coords.get(from));
                if (fromfn == null) {
                    System.out.println("ERROR: NO " + from);
                }
                if (tofn == null) {
                    System.out.println("warning: NO " + coords.get(from));
                    tofn = new File(inputDir, fromfn.getName().replace(from, coords.get(from)));
                }
                System.out.println("copy " + fromfn.getAbsolutePath() + " -> " + tofn.getAbsolutePath());
                FileManager.copyFile(fromfn, tofn, true);
            }
            if (fromfn.getName().indexOf("temp") <= -1) continue;
            System.out.println("delete " + fromfn.getName());
            fromfn.delete();
        }
    }

    private static File findFile(File plateDir, String coord) {
        String[] names = null;
        System.out.println(plateDir.getAbsolutePath());
        File[] fileArray = plateDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File chromatFn = fileArray[n2];
            names = chromatFn.getName().split("\\.")[0].split("_");
            if (names.length == 2 && names[1].equals(coord)) {
                return chromatFn;
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, String> switchCoord(String letter, int number) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        String from = String.valueOf(letter) + (String.valueOf(number).length() == 1 ? "0" + number : Integer.valueOf(number));
        int toNumber = number < 7 ? number + 6 : number - 6;
        String to = String.valueOf(letter) + (String.valueOf(toNumber).length() == 1 ? "0" + toNumber : Integer.valueOf(toNumber));
        coords.put(from, "temp");
        coords.put(to, from);
        coords.put("temp", to);
        return coords;
    }

    private static List<Map<String, String>> initShiftList() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        int i = 1;
        while (i < 7) {
            list.add(ShiftRunCoord.switchCoord("A", i));
            list.add(ShiftRunCoord.switchCoord("B", i));
            list.add(ShiftRunCoord.switchCoord("C", i));
            list.add(ShiftRunCoord.switchCoord("D", i));
            list.add(ShiftRunCoord.switchCoord("E", i));
            list.add(ShiftRunCoord.switchCoord("F", i));
            list.add(ShiftRunCoord.switchCoord("G", i));
            list.add(ShiftRunCoord.switchCoord("H", i));
            ++i;
        }
        return list;
    }
}

