/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import misc.FileHandler;
import misc.FileHelper;
import misc.LogUtil;
import misc.SnpCommon;
import misc.SnpConfig;
import misc.StringUtils;

public class PositionCaller {
    private String chromatDir;
    private String backbone;
    private String outputDir;
    private SnpConfig config;
    private LogUtil log;
    private LogUtil snpPositionLog;
    private String snpDataDir;
    private String rawFile;
    private String polyDir;
    private String backboneSeq;
    private Map matched;
    private List notMatched;
    private Map matchedPos;
    private Map matchedDetails;
    private Map rawPosDic;
    private Map posDic;
    private Map fastaDic;
    private Map fastaTrimDic;
    private Map qualDic;
    private Map qualTrimDic;
    private Map callDic;
    private Map cellLineMap;

    public PositionCaller(String chrDir, String fn, String outDir, SnpConfig conf, LogUtil mainLog) {
        this.chromatDir = chrDir;
        this.backbone = fn;
        this.outputDir = outDir;
        this.config = conf;
        this.log = mainLog;
        this.snpPositionLog = new LogUtil(FileHelper.SNP_POSITION_LOG);
        this.cellLineMap = new HashMap();
        this.matched = new HashMap();
        this.notMatched = new ArrayList();
        this.matchedPos = new HashMap();
        this.matchedDetails = new HashMap();
        this.rawPosDic = new HashMap();
        this.posDic = new HashMap();
        this.callDic = new HashMap();
    }

    public void runPositionCall() throws IOException {
        System.out.println("\tSNP call...");
        this.snpPositionLog.enter("<Script PositionCaller>\n");
        this.snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        this.polyDir = FileHelper.polyDir(this.outputDir, this.chromatDir, this.config);
        this.rawFile = FileHelper.snpChromatRawDataFile(this.snpDataDir);
        String fastaFile = FileHelper.fastaFile(this.snpDataDir);
        this.fastaDic = FileHandler.getAllFasta(fastaFile);
        String fastaTrimFile = FileHelper.fastaTrimFile(this.snpDataDir);
        this.fastaTrimDic = FileHandler.getAllFasta(fastaTrimFile);
        String qualFile = FileHelper.qualFile(this.snpDataDir);
        this.qualDic = FileHandler.getAllFasta(qualFile);
        String qualTrimFile = FileHelper.qualTrimFile(this.snpDataDir);
        this.qualTrimDic = FileHandler.getAllFasta(qualTrimFile);
        FileHandler handler = new FileHandler();
        this.backboneSeq = ((String)handler.readFile(this.backbone).get(1)).trim();
        this.parseCrossMatchResult();
        this.addHiddenSnpPosition();
        this.snpPositionLog.add("Position dictionary producted:\n \t\t{" + StringUtils.MapToString(this.posDic) + "}\n");
        this.GenerateRawData();
        this.snpPositionLog.add("Write raw base call file... \n");
        this.WriteRawDateFile();
        this.snpPositionLog.exit("</Script PositionCaller>\n");
        this.snpPositionLog.write(this.snpDataDir);
    }

    public void WriteRawDateFile() throws IOException {
        String line;
        ArrayList<String> data = new ArrayList<String>();
        String header = "Backbone_Position";
        Object[] pos = this.posDic.keySet().toArray();
        Arrays.sort(pos);
        int i = 0;
        while (i < pos.length) {
            header = String.valueOf(header) + "\t" + pos[i].toString();
            ++i;
        }
        data.add(String.valueOf(header) + "\n");
        Object[] chrs = this.matched.keySet().toArray();
        Arrays.sort(chrs);
        int i2 = 0;
        while (i2 < chrs.length) {
            line = (String)chrs[i2];
            Map baseMap = (Map)this.callDic.get(chrs[i2]);
            int j = 0;
            while (j < pos.length) {
                line = String.valueOf(line) + "\t" + (String)baseMap.get(pos[j]);
                ++j;
            }
            data.add(String.valueOf(line) + "\n");
            ++i2;
        }
        Object[] nChrs = this.notMatched.toArray();
        Arrays.sort(nChrs);
        int i3 = 0;
        while (i3 < nChrs.length) {
            line = (String)nChrs[i3];
            int j = 0;
            while (j < pos.length) {
                line = String.valueOf(line) + "\t?/-1/-1/?";
                ++j;
            }
            data.add(String.valueOf(line) + "\n");
            ++i3;
        }
        FileHandler handler = new FileHandler();
        handler.writeFile(this.rawFile, data);
    }

    public Map candidatePosOnChromat(String chr) throws IOException {
        HashMap<Integer, String[]> ret = new HashMap<Integer, String[]>();
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        String[] chrQuals = ((String)this.qualDic.get(chr)).trim().split("\\s+");
        String chrSeq = (String)this.fastaDic.get(chr);
        int[] startEnd = this.getSearchingStartEnd(chrQuals);
        int i = startEnd[0];
        while (i < startEnd[1]) {
            if (new Integer(chrQuals[i]) <= 31 && new Integer(chrQuals[i - 1]) <= 31 && new Integer(chrQuals[i + 1]) <= 31 && chrSeq.charAt(i) != 'N') {
                String[] refSeqs = this.getThisRefSeq(chrSeq, i + 1);
                boolean hasDouble = this.checkDoublePeak(polyFn, i);
                float signalToNoise = this.getSignalToNoiseRatial(polyFn, i, 10);
                float[] peakAreas = this.getPeakAreas(polyFn, i);
                if ((double)(peakAreas[0] / peakAreas[1]) < 1.5 && (double)peakAreas[1] > 0.25) {
                    ret.put(new Integer(i + 1), refSeqs);
                    System.out.println(String.valueOf(chr) + " add " + (i + 1));
                }
            }
            ++i;
        }
        return ret;
    }

    public void GenerateRawData() throws IOException {
        this.snpPositionLog.enter("<Function GenerateRawData>\n");
        for (String chr : this.matched.keySet()) {
            this.callDic.put(chr, new HashMap());
        }
        Iterator it = this.posDic.keySet().iterator();
        this.snpPositionLog.add("Referencing sequence:\n");
        while (it.hasNext()) {
            Integer pos = (Integer)it.next();
            List list = (List)this.posDic.get(pos);
            Object[] refSeqs = this.getThisRefSeq(this.backboneSeq, pos);
            this.snpPositionLog.add(" \t\t" + pos + " : [" + StringUtils.ArrayToString(refSeqs) + "]\n");
            for (String chr : this.matched.keySet()) {
                String call;
                Map baseMap = (Map)this.callDic.get(chr);
                for (List data : list) {
                    String tempChr = (String)data.get(0);
                    if (!tempChr.equals(chr)) continue;
                    call = this.getAlleleData1(chr, data, pos);
                    baseMap.put(pos, call);
                    break;
                }
                if (baseMap.containsKey(pos)) continue;
                call = this.getAlleleData2((String[])refSeqs, chr, pos);
                baseMap.put(pos, call);
            }
        }
        this.snpPositionLog.exit("</Function GenerateRawData>\n");
    }

    public String getAlleleData2(String[] refSeqs, String chr, Integer pos) {
        String direction = (String)this.matched.get(chr);
        String chrSeq = (String)this.fastaDic.get(chr);
        List positions = (List)this.matchedPos.get(chr);
        int newChrPos = -1;
        int finalPos = -1;
        int[] nArray = new int[2];
        nArray[1] = -1;
        int[] chrPos = nArray;
        int chrStart = (Integer)positions.get(0);
        int chrEnd = (Integer)positions.get(1);
        int backboneStart = (Integer)positions.get(2);
        int backboneEnd = (Integer)positions.get(3);
        if (pos >= Math.min(backboneStart, backboneEnd) && pos <= Math.max(backboneStart, backboneEnd)) {
            newChrPos = this.calculatePos2(pos, chr, chrStart, chrEnd, backboneStart, backboneEnd);
        }
        if (newChrPos <= -1 && (chrPos = this.getSequencePos(refSeqs, direction, chrSeq))[0] == 0) {
            chrPos = this.getSequencePosComplex(refSeqs, direction, chrSeq, pos);
        }
        if (newChrPos <= -1 && chrPos[1] == -1 && chrPos[0] == 1) {
            this.snpPositionLog.add("<WARNING>More than one match for " + chr + " at " + pos + "\n");
            this.log.add("<WARNING>More than one match for " + chr + " at " + pos + "\n");
            return "X/-1/-1/X";
        }
        if (newChrPos > -1 && chrPos[1] > -1 && Math.abs(newChrPos - chrPos[1]) > 0) {
            System.out.print("diff at " + pos + " " + chr + " " + chrPos[1] + " " + newChrPos);
            finalPos = newChrPos;
        } else if (newChrPos > -1 && chrPos[1] == -1) {
            finalPos = newChrPos;
        } else {
            if (newChrPos <= -1 && chrPos[1] == -1) {
                return "X/-1/-1/X";
            }
            if (newChrPos <= -1 && chrPos[1] > -1) {
                if (chrPos[1] > chrStart && chrPos[1] < chrEnd && newChrPos == -1) {
                    System.out.print("wrong pos " + pos + " " + chr + " " + chrPos[1] + "\n");
                    return "X/-1/-1/X";
                }
                finalPos = chrPos[1];
            }
        }
        String allele = chrSeq.substring(finalPos, finalPos + 1);
        String[] chrQuals = ((String)this.qualDic.get(chr)).trim().split("\\s+");
        Integer qual = new Integer(chrQuals[finalPos]);
        return String.valueOf(allele) + "/" + qual + "/" + finalPos + "/" + direction;
    }

    public int calculatePos2(int bPos, String chr, int chrStart, int chrEnd, int backboneStart, int backboneEnd) {
        int cPos;
        int num;
        String entry;
        int pos;
        String direction = (String)this.matched.get(chr);
        Map details = (Map)this.matchedDetails.get(chr);
        Map delDic = (Map)details.get("D");
        Map insDic = (Map)details.get("I");
        int totalD = 0;
        int totalI = 0;
        Iterator it = delDic.keySet().iterator();
        while (it.hasNext()) {
            pos = (Integer)it.next();
            entry = (String)delDic.get(new Integer(pos));
            num = new Integer(entry.split(",")[0]);
            cPos = new Integer(entry.split(",")[1]);
            if (direction.equals("F")) {
                if (bPos >= pos && bPos - pos < num) {
                    return -2;
                }
                if (pos < backboneStart || pos > bPos) continue;
                totalD += num;
                continue;
            }
            if (bPos <= pos && pos - bPos < num) {
                return -2;
            }
            if (pos > backboneStart || pos < bPos) continue;
            totalD += num;
        }
        it = insDic.keySet().iterator();
        while (it.hasNext()) {
            pos = (Integer)it.next();
            entry = (String)insDic.get(new Integer(pos));
            num = new Integer(entry.split(",")[0]);
            cPos = new Integer(entry.split(",")[1]);
            if (direction.equals("F")) {
                if (pos < backboneStart || pos > bPos) continue;
                totalI += num;
                continue;
            }
            if (pos > backboneStart || pos < bPos) continue;
            totalI += num;
        }
        int ret = chrStart - totalD + totalI + Math.abs(bPos - backboneStart) - 1;
        return ret;
    }

    public String getAlleleData1(String chr, List data, Integer pos) {
        String allele = (String)data.get(2);
        String direction = (String)data.get(5);
        int chrPos = this.calculatePos1(chr, pos);
        String[] chrQuals = ((String)this.qualDic.get(chr)).trim().split("\\s+");
        Integer qual = new Integer(chrQuals[chrPos]);
        return String.valueOf(allele) + "/" + qual + "/" + chrPos + "/" + direction;
    }

    public int calculatePos1(String chr, Integer pos) {
        Map details = (Map)this.matchedDetails.get(chr);
        Map sData = (Map)details.get("S");
        String data = (String)sData.get(pos);
        Integer chrPos = new Integer(data.split(",")[1]);
        return chrPos - 1;
    }

    public void parseCrossMatchResult() throws IOException {
        this.snpPositionLog.enter("<Function ParseCrossMatchResult>\n");
        String fastaTrimFile = FileHelper.fastaTrimFile(this.snpDataDir);
        List allChromats = FileHandler.getAllChromatNames(fastaTrimFile);
        this.snpPositionLog.add(String.valueOf(allChromats.size()) + " chromats in this batch:\n \t\t\t[" + StringUtils.listToString(allChromats) + "]\n");
        this.log.add("<INFO>" + allChromats.size() + " chromats in this batch\n");
        this.getSnpPosition();
        this.convertMap();
        this.filterSnpPosition();
        this.getNotMatched(allChromats);
        this.snpPositionLog.add(String.valueOf(this.matched.keySet().size()) + " chromats matched:\n \t\t\t[" + StringUtils.ArrayToString(this.matched.keySet().toArray()) + "]\n");
        this.snpPositionLog.add(String.valueOf(this.notMatched.size()) + " chromats not matched:\n \t\t\t[" + StringUtils.listToString(this.notMatched) + "]\n");
        this.log.add("<INFO>" + this.matched.keySet().size() + " chromats matched\n");
        this.log.add("<INFO>" + this.notMatched.size() + " chromats not matched: [" + StringUtils.listToString(this.notMatched) + "]\n");
        for (Integer n : this.posDic.keySet()) {
        }
        this.snpPositionLog.exit("</Function ParseCrossMatchResult>\n");
    }

    public void getNotMatched(List allChromats) {
        for (String chr : allChromats) {
            if (this.matched.containsKey(chr)) continue;
            this.notMatched.add(chr);
        }
    }

    public void addHiddenSnpPosition() throws IOException {
        System.out.println("addHiddenSnpPosition");
        Iterator it = this.matched.keySet().iterator();
        this.getCellLineMap();
        HashMap untrustMap = new HashMap();
        while (it.hasNext()) {
            String chr = (String)it.next();
            Map candidateMap = this.candidatePosOnChromat(chr);
            this.validateHiddenPosition(candidateMap, chr, untrustMap);
        }
        if (this.config.isErrorProof()) {
            for (Integer pos : untrustMap.keySet()) {
                int num = (Integer)untrustMap.get(pos);
                if (num <= 10 || num <= this.matched.size() / 8 || !this.posDic.containsKey(pos) || ((List)this.posDic.get(pos)).size() != 0) continue;
                System.out.print("error proof remove " + pos);
                this.posDic.remove(pos);
            }
        }
    }

    public void getCellLineMap() {
        for (String chr : this.fastaDic.keySet()) {
            String cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
            if (!this.cellLineMap.containsKey(cl)) {
                this.cellLineMap.put(cl, new ArrayList());
            }
            List list = (List)this.cellLineMap.get(cl);
            list.add(chr);
        }
    }

    public void validateHiddenPosition(Map cMap, String chr, Map untrustMap) throws IOException {
        for (Integer chrPos : cMap.keySet()) {
            Integer backbonePos = this.convertBackbonePos(chrPos, (String[])cMap.get(chrPos), chr);
            if (backbonePos <= -1 || this.posDic.containsKey(new Integer(backbonePos + 1)) && ((List)this.posDic.get(new Integer(backbonePos + 1))).size() > 0) continue;
            if (!this.discrepencyChromat((String[])cMap.get(chrPos), chrPos - 1, chr) && this.passReferenceCheck((String[])cMap.get(chrPos), chrPos - 1, chr)) {
                if (this.posDic.containsKey(new Integer(backbonePos + 1))) continue;
                this.posDic.put(new Integer(backbonePos + 1), new ArrayList());
                System.out.println("add" + (backbonePos + 1) + " by " + chr + " " + chrPos);
                continue;
            }
            if (!untrustMap.containsKey(new Integer(backbonePos + 1))) {
                untrustMap.put(new Integer(backbonePos + 1), new Integer(0));
            }
            int num = (Integer)untrustMap.get(new Integer(backbonePos + 1)) + 1;
            untrustMap.put(new Integer(backbonePos + 1), new Integer(num));
        }
    }

    public boolean discrepencyChromat(String[] refSeqs, int chrPos, String chr) throws IOException {
        String direction = (String)this.matched.get(chr);
        String cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
        List list = (List)this.cellLineMap.get(cl);
        for (String thisChr : list) {
            String dir;
            int thisPos;
            if (thisChr.equals(chr) || (thisPos = this.getSequencePos(refSeqs, dir = direction.equals(this.matched.get(thisChr)) ? "F" : "R", (String)this.fastaDic.get(thisChr))[1]) <= -1 || !this.hasDiscrepency(chr, thisChr, chrPos, thisPos, direction, (String)this.matched.get(thisChr))) continue;
            return true;
        }
        return false;
    }

    public boolean hasDiscrepency(String chr, String thisChr, int chrPos, int thisPos, String dir, String thisDir) throws IOException {
        String[] quals = ((String)this.qualDic.get(chr)).trim().split("\\s+");
        String[] thisQuals = ((String)this.qualDic.get(thisChr)).trim().split("\\s+");
        int thisQual = new Integer(thisQuals[thisPos]);
        if (thisQual >= this.config.getQualAssureHomo()) {
            return true;
        }
        if (chrPos - 2 < 0 || chrPos + 2 >= quals.length || thisPos - 2 < 0 || thisPos + 2 >= thisQuals.length) {
            return false;
        }
        int overAllQ = new Integer(quals[chrPos - 2]) + new Integer(quals[chrPos - 1]) + new Integer(quals[chrPos + 1]) + new Integer(quals[chrPos + 2]);
        int thisOverAllQ = new Integer(thisQuals[thisPos - 2]) + new Integer(thisQuals[thisPos - 1]) + new Integer(thisQuals[thisPos + 1]) + new Integer(thisQuals[thisPos + 2]);
        if (thisOverAllQ > overAllQ && new Integer(thisQuals[thisPos]) >= 30) {
            String thisPeak2;
            String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
            String thisPolyFn = new File(new File(this.polyDir), String.valueOf(thisChr) + ".poly").getAbsolutePath();
            FileHandler handler = new FileHandler();
            List polyData = handler.readFile(polyFn);
            String[] data = ((String)polyData.get(chrPos + 1)).trim().split("\\s+");
            String peak1 = data[0];
            String peak2 = data[4];
            List thisPolyData = handler.readFile(thisPolyFn);
            String[] thisData = ((String)thisPolyData.get(thisPos + 1)).trim().split("\\s+");
            String thisPeak1 = dir.equals(thisDir) ? thisData[0] : StringUtils.revCompSeq(thisData[0]);
            String string = thisPeak2 = dir.equals(thisDir) ? thisData[4] : StringUtils.revCompSeq(thisData[4]);
            if (!(peak1.equals(thisPeak1) && peak2.equals(thisPeak2) || peak1.equals(thisPeak2) && peak2.equals(thisPeak1))) {
                return true;
            }
        }
        return false;
    }

    public boolean passReferenceCheck(String[] refSeqs, int chrPos, String chr) throws IOException {
        String direction = (String)this.matched.get(chr);
        String refChr = "";
        int refQual = -1;
        int refPos = -1;
        String call1 = ((String)this.fastaDic.get(chr)).substring(chrPos - 2, chrPos - 1);
        String call2 = ((String)this.fastaDic.get(chr)).substring(chrPos + 2, chrPos + 3);
        for (String thisChr : this.matched.keySet()) {
            int thisPos;
            if (!direction.equals(this.matched.get(thisChr)) || thisChr.equals(chr) || (thisPos = this.getSequencePos(refSeqs, "F", (String)this.fastaDic.get(thisChr))[1]) <= -1 || thisPos - 2 < 0 || thisPos + 2 >= ((String)this.fastaDic.get(thisChr)).length()) continue;
            String thisCall1 = ((String)this.fastaDic.get(thisChr)).substring(thisPos - 2, thisPos - 1);
            String thisCall2 = ((String)this.fastaDic.get(thisChr)).substring(thisPos + 2, thisPos + 3);
            String[] thisQuals = ((String)this.qualDic.get(thisChr)).trim().split("\\s+");
            int totalQ = 0;
            int i = thisPos - 2;
            while (i < thisPos + 3) {
                totalQ += new Integer(thisQuals[i]).intValue();
                ++i;
            }
            if (totalQ / 5 <= refQual || !thisCall1.equals(call1) || !thisCall2.equals(call2)) continue;
            refQual = totalQ / 5;
            refChr = thisChr;
            refPos = thisPos;
        }
        if (refQual > 40) {
            float[] chrAreas = this.getPeakAreaRatio(chr, chrPos);
            float[] refAreas = this.getPeakAreaRatio(refChr, refPos);
            if ((double)(refAreas[0] / chrAreas[0]) > 1.5 && (refAreas[3] < 0.0f || (double)(chrAreas[3] / refAreas[3]) > 1.5)) {
                return true;
            }
            if ((double)(refAreas[0] / chrAreas[0]) > 1.3 && ((double)refAreas[2] > 1.5 || (double)chrAreas[2] > 1.0) && (refAreas[3] < 0.0f || (double)(chrAreas[3] / refAreas[3]) > 1.5)) {
                float chrHeightRatio = this.getPeakHeightRatio(chr, chrPos);
                float refHeightRatio = this.getPeakHeightRatio(refChr, refPos);
                if ((double)(refHeightRatio / chrHeightRatio) > 1.3) {
                    return true;
                }
            }
        }
        return false;
    }

    public float getPeakHeightRatio(String chr, int chrPos) throws IOException {
        Map atcgMap = PositionCaller.getIndexMap();
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        FileHandler handler = new FileHandler();
        List polyData = handler.readFile(polyFn);
        int lineNum = chrPos + 1;
        String[] data = ((String)polyData.get(lineNum)).trim().split("\\s+");
        String[] dataPre = ((String)polyData.get(lineNum - 2)).trim().split("\\s+");
        String[] dataPos = ((String)polyData.get(lineNum + 2)).trim().split("\\s+");
        float height = new Float(data[data.length + (Integer)atcgMap.get(data[0])]).floatValue();
        float heightPre = new Float(dataPre[dataPre.length + (Integer)atcgMap.get(dataPre[0])]).floatValue();
        float heightPos = new Float(dataPos[dataPos.length + (Integer)atcgMap.get(dataPos[0])]).floatValue();
        return height / (heightPre + heightPos);
    }

    public static Map getIndexMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("A", new Integer(-4));
        map.put("C", new Integer(-3));
        map.put("G", new Integer(-2));
        map.put("T", new Integer(-1));
        map.put("N", new Integer(0));
        return map;
    }

    public float[] getPeakAreaRatio(String chr, int chrPos) throws IOException {
        String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
        FileHandler handler = new FileHandler();
        List polyData = handler.readFile(polyFn);
        int lineNum = chrPos + 1;
        String[] data = ((String)polyData.get(lineNum)).trim().split("\\s+");
        String[] dataPre = ((String)polyData.get(lineNum - 2)).trim().split("\\s+");
        String[] dataPos = ((String)polyData.get(lineNum + 2)).trim().split("\\s+");
        float area = new Float(data[3]).floatValue();
        float area2 = new Float(data[7]).floatValue();
        float neibourArea = new Float(dataPre[3]).floatValue() + new Float(dataPos[3]).floatValue();
        float[] ret = new float[]{area / neibourArea, neibourArea, area, area2};
        return ret;
    }

    public String[] getPeakCalls(String polyFn, int pos) throws IOException {
        FileHandler handler = new FileHandler();
        List polyData = handler.readFile(polyFn);
        int lineNum = pos + 1;
        String[] data = ((String)polyData.get(lineNum)).trim().split("\\s+");
        String[] peaks = new String[]{data[0], data[4]};
        return peaks;
    }

    public Integer convertBackbonePos(int chrPos, String[] refSeqs, String chr) {
        List positions = (List)this.matchedPos.get(chr);
        int newBackbonePos = -1;
        int backbonePos = -1;
        int chrStart = (Integer)positions.get(0);
        int chrEnd = (Integer)positions.get(1);
        int backboneStart = (Integer)positions.get(2);
        int backboneEnd = (Integer)positions.get(3);
        if (chrPos >= chrStart && chrPos <= chrEnd) {
            newBackbonePos = this.calculateBackbonePos(chrPos, chr, chrStart, chrEnd, backboneStart, backboneEnd);
        }
        if (newBackbonePos > -1) {
            return new Integer(newBackbonePos);
        }
        String direction = (String)this.matched.get(chr);
        backbonePos = this.getSequencePos(refSeqs, direction, this.backboneSeq)[1];
        return new Integer(backbonePos);
    }

    public int[] getSequencePosComplex(String[] refSeqs, String direction, String seq, Integer bPos) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Iterator it = this.posDic.keySet().iterator();
        while (it.hasNext()) {
            int pos = (Integer)it.next();
            if (pos < bPos - 6 || pos > bPos + 6) continue;
            list.add(new Integer(pos - bPos + 6));
        }
        String newSeq = "";
        int i = 0;
        while (i < refSeqs[0].length()) {
            newSeq = list.contains(new Integer(i)) ? String.valueOf(newSeq) + "." : String.valueOf(newSeq) + refSeqs[0].substring(i, i + 1);
            ++i;
        }
        Pattern p1 = direction.equals("F") ? Pattern.compile(newSeq) : Pattern.compile(StringUtils.revCompSeq(newSeq));
        int[] ret = this.matchPosition(p1, seq, 6);
        return ret;
    }

    public int[] getSequencePos(String[] refSeqs, String direction, String seq) {
        Pattern p3;
        Pattern p2;
        Pattern p1;
        if (direction.equals("F")) {
            p1 = Pattern.compile(String.valueOf(refSeqs[0].substring(0, 6)) + "." + refSeqs[0].substring(7));
            p2 = Pattern.compile(String.valueOf(refSeqs[1].substring(0, this.config.getLengthRefSeq())) + ".");
            p3 = Pattern.compile("." + refSeqs[2].substring(1));
        } else {
            p1 = Pattern.compile(StringUtils.revCompSeq(String.valueOf(refSeqs[0].substring(0, 6)) + "." + refSeqs[0].substring(7)));
            p2 = Pattern.compile(String.valueOf(StringUtils.revCompSeq(refSeqs[2].substring(1))) + ".");
            p3 = Pattern.compile("." + StringUtils.revCompSeq(refSeqs[1].substring(0, this.config.getLengthRefSeq())));
        }
        int[] ret = this.matchPosition(p1, seq, 6);
        if (ret[1] == -1) {
            ret = this.matchPosition(p2, seq, this.config.getLengthRefSeq());
        }
        if (ret[1] == -1) {
            ret = this.matchPosition(p3, seq, 0);
        }
        return ret;
    }

    public int[] matchPosition(Pattern p, String seq, int offset) {
        int pos = -1;
        int find = 0;
        int start = 0;
        Matcher m = p.matcher(seq);
        boolean result = m.find();
        if (result) {
            find = 1;
            if (!m.find((start += m.start()) + 1)) {
                pos = start + offset;
            }
        }
        int[] ret = new int[]{find, pos};
        return ret;
    }

    public int calculateBackbonePos(int chrPos, String chr, int chrStart, int chrEnd, int backboneStart, int backboneEnd) {
        int cPos;
        int num;
        String entry;
        int pos;
        Map details = (Map)this.matchedDetails.get(chr);
        Map delDic = (Map)details.get("D");
        Map insDic = (Map)details.get("I");
        int totalD = 0;
        int totalI = 0;
        Iterator it = delDic.keySet().iterator();
        while (it.hasNext()) {
            pos = (Integer)it.next();
            entry = (String)delDic.get(new Integer(pos));
            num = new Integer(entry.split(",")[0]);
            cPos = new Integer(entry.split(",")[1]);
            if (cPos < chrStart || cPos >= chrPos) continue;
            totalD += num;
        }
        it = insDic.keySet().iterator();
        while (it.hasNext()) {
            pos = (Integer)it.next();
            entry = (String)insDic.get(new Integer(pos));
            num = new Integer(entry.split(",")[0]);
            cPos = new Integer(entry.split(",")[1]);
            if (pos < cPos + num && pos > cPos - num) {
                return -1;
            }
            if (cPos < chrStart || cPos > chrPos) continue;
            totalI += num;
        }
        String direction = (String)this.matched.get(chr);
        int ret = direction.equals("F") ? backboneStart + totalD - totalI + (chrPos - chrStart) - 1 : backboneStart - totalD + totalI - (chrPos - chrStart) - 1;
        return ret;
    }

    public float[] getPeakAreas(String polyFn, int pos) throws IOException {
        FileHandler handler = new FileHandler();
        List polyData = handler.readFile(polyFn);
        int lineNum = pos + 1;
        String[] data = ((String)polyData.get(lineNum)).trim().split("\\s+");
        float peakArea1 = new Float(data[3]).floatValue();
        float peakArea2 = new Float(data[7]).floatValue();
        float[] peakAreas = new float[]{peakArea1, peakArea2};
        return peakAreas;
    }

    public float getSignalToNoiseRatial(String polyFn, int pos, int offset) throws IOException {
        float total = 0.0f;
        float noise = 0.0f;
        FileHandler handler = new FileHandler();
        List polyData = handler.readFile(polyFn);
        int lineNum = pos + 1;
        int i = lineNum - offset;
        while (i < lineNum + offset) {
            if (i > 0 && i < polyData.size()) {
                String[] temp = ((String)polyData.get(i)).trim().split("\\s+");
                total += new Float(temp[3]).floatValue();
                if (!temp[4].equals("N")) {
                    noise += new Float(temp[7]).floatValue();
                }
            }
            ++i;
        }
        return noise / total;
    }

    public boolean checkDoublePeak(String polyFn, int pos) throws IOException {
        String[] temp;
        int lineNum;
        boolean ret = false;
        FileHandler handler = new FileHandler();
        List polyData = handler.readFile(polyFn);
        String[] data = ((String)polyData.get(lineNum = pos + 1)).trim().split("\\s+");
        if (data[4].equals("N")) {
            return false;
        }
        int noise = 0;
        int highNoise = 0;
        int i = lineNum - 2;
        while (i < lineNum + 3) {
            temp = ((String)polyData.get(i)).trim().split("\\s+");
            if (!temp[4].equals("N")) {
                Float f = new Float(temp[7]);
                if ((double)f.floatValue() > 0.1) {
                    ++noise;
                }
            }
            if (!temp[4].equals("N")) {
                Float f = new Float(temp[7]);
                if ((double)f.floatValue() > 0.18) {
                    ++highNoise;
                }
            }
            ++i;
        }
        float peakArea1 = new Float(data[3]).floatValue();
        float peakArea2 = new Float(data[7]).floatValue();
        String[] dataPre = ((String)polyData.get(lineNum - 1)).trim().split("\\s+");
        String[] dataPos = ((String)polyData.get(lineNum + 1)).trim().split("\\s+");
        double posPre = new Double(dataPre[1]);
        double posPos = new Double(dataPos[1]);
        double posMid = new Double(data[1]);
        double posMid2 = new Double(data[5]);
        double space = (Math.abs(posPos - posMid) + Math.abs(posMid - posPre)) / 2.0;
        double offSpace = Math.abs(posMid - posMid2);
        if ((peakArea1 / peakArea2 < 3.0f || (double)peakArea2 > 0.25) && (double)(peakArea1 / peakArea2) > 0.5 && offSpace <= space / 4.0) {
            if ((double)peakArea2 > 0.18) {
                return true;
            }
            if ((double)peakArea2 > 0.13) {
                int i2 = lineNum - 2;
                while (i2 < lineNum + 3) {
                    temp = ((String)polyData.get(i2)).trim().split("\\s+");
                    if (!temp[4].equals("N") && i2 != lineNum) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            return false;
        }
        return ret;
    }

    public String[] getThisRefSeq(String chrSeq, int chrPos) {
        String refSeq1 = chrPos - 7 < 0 || chrPos + 6 > chrSeq.length() ? "NNNNNNNNNNNNN" : chrSeq.substring(chrPos - 7, chrPos + 6);
        String refSeq2 = chrPos - this.config.getLengthRefSeq() - 1 < 0 ? "NNNNNNNNNNN" : chrSeq.substring(chrPos - this.config.getLengthRefSeq() - 1, chrPos);
        String refSeq3 = chrPos + this.config.getLengthRefSeq() > chrSeq.length() ? chrSeq.substring(chrPos - 1) : chrSeq.substring(chrPos - 1, chrPos + this.config.getLengthRefSeq());
        String[] ret = new String[]{refSeq1, refSeq2, refSeq3};
        return ret;
    }

    public int[] getSearchingStartEnd(String[] quals) {
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < quals.length - 2) {
            if (new Integer(quals[i]) > 40 && new Integer(quals[i + 1]) > 40 && new Integer(quals[i + 2]) > 40) {
                start = i;
                break;
            }
            ++i;
        }
        i = quals.length - 1;
        while (i > 3) {
            if (new Integer(quals[i]) > 40 && new Integer(quals[i - 1]) > 40 && new Integer(quals[i - 2]) > 40) {
                end = i;
                break;
            }
            --i;
        }
        int[] ret = new int[]{start, end};
        return ret;
    }

    public void filterSnpPosition() {
        for (Integer pos : this.rawPosDic.keySet()) {
            boolean keep = false;
            if (this.highQualDiff((List)this.rawPosDic.get(pos))) {
                keep = true;
            } else if (this.passNeighbourCheck((List)this.rawPosDic.get(pos))) {
                keep = true;
            }
            if (keep) {
                this.posDic.put(pos, (List)this.rawPosDic.get(pos));
                continue;
            }
            System.out.println("remove " + pos);
        }
    }

    private boolean passNeighbourCheck(List list) {
        boolean ret = false;
        for (List aList : list) {
            String chr = (String)aList.get(0);
            int chrPos = (Integer)aList.get(1) - 1;
            int qual = (Integer)aList.get(3);
            String chrQuals = (String)this.qualTrimDic.get(chr);
            String polyFn = new File(new File(this.polyDir), String.valueOf(chr) + ".poly").getAbsolutePath();
            int[] quals = SnpCommon.getAveQualAround3(chrPos, chrQuals, 4);
            boolean passCQ = SnpCommon.passContQual(chrPos, chrQuals, 2, 30);
            boolean passRQ = this.passRegionalQual(chrPos, chrQuals, 10, 28);
            boolean passRQ2 = this.passRegionalQual(chrPos, chrQuals, 10, 25);
            if (quals[0] >= 30 && quals[1] >= 30 && passCQ && passRQ) {
                return true;
            }
            if ((quals[0] > 30 || quals[1] > 30) && quals[0] > 27 && quals[1] > 27 && (quals[0] + quals[1] + quals[2]) / 3 >= 30 && passCQ && passRQ) {
                return true;
            }
            if (qual < 33 || quals[0] < 33 && quals[1] < 33 || !passCQ || !passRQ2) continue;
            return true;
        }
        return ret;
    }

    public boolean passRegionalQual(int chrPos, String chrQuals, int offset, int cutoff) {
        boolean ret = false;
        int overall = 0;
        int left = 0;
        int right = 0;
        String[] quals = chrQuals.trim().split("\\s+");
        int i = chrPos - offset + 2;
        while (i < chrPos + offset - 1) {
            if (i >= 0 && i < quals.length && new Integer(quals[i]) <= cutoff) {
                ++overall;
            }
            ++i;
        }
        i = chrPos - offset + 2;
        while (i < chrPos + 2) {
            if (i >= 0 && i < quals.length && new Integer(quals[i]) <= cutoff) {
                ++left;
            }
            ++i;
        }
        i = chrPos - 1;
        while (i < chrPos + offset - 1) {
            if (i >= 0 && i < quals.length && new Integer(quals[i]) <= cutoff) {
                ++right;
            }
            ++i;
        }
        if ((double)overall < (double)offset * 0.8 && (double)left < (double)offset * 0.7 && (double)right < (double)offset * 0.7) {
            ret = true;
        }
        return ret;
    }

    public boolean highQualDiff(List list) {
        boolean ret = false;
        Iterator it = list.iterator();
        int count = 0;
        while (it.hasNext()) {
            List aList = (List)it.next();
            Integer qual = (Integer)aList.get(3);
            if (qual >= this.config.getQualAssure()) {
                return true;
            }
            if (qual < 30) continue;
            if (count == 0) {
                ++count;
                continue;
            }
            return true;
        }
        return ret;
    }

    public void convertMap() throws IOException {
        int start = 0;
        int end = 0;
        for (String chr : this.fastaTrimDic.keySet()) {
            String seqTrim;
            if (!this.matchedPos.containsKey(chr)) continue;
            List posList = (List)this.matchedPos.get(chr);
            Integer oldStart = (Integer)posList.get(0);
            Integer oldEnd = (Integer)posList.get(1);
            String seq = (String)this.fastaDic.get(chr);
            int i = seq.indexOf(seqTrim = (String)this.fastaTrimDic.get(chr));
            if (i >= 0) {
                start = i + oldStart;
                end = start + (oldEnd - oldStart);
            } else {
                System.out.println("exception in convertMap");
            }
            posList.set(0, new Integer(start));
            posList.set(1, new Integer(end));
            Map chrMap = (Map)this.matchedDetails.get(chr);
            this.convertMatchMap((Map)chrMap.get("S"), i);
            this.convertMatchMap((Map)chrMap.get("I"), i);
            this.convertMatchMap((Map)chrMap.get("D"), i);
        }
    }

    public void convertMatchMap(Map map, int start) {
        for (Integer bPos : map.keySet()) {
            String info = (String)map.get(bPos);
            Integer oldPos = new Integer(info.split(",")[1]);
            Integer newPos = new Integer(oldPos + start);
            info = String.valueOf(info.split(",")[0]) + "," + newPos;
            map.put(bPos, info);
        }
    }

    public void getSnpPosition() throws IOException {
        FileHandler handler = new FileHandler();
        List data = handler.readFile(FileHelper.crossMatchLog(this.snpDataDir));
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < data.size()) {
            String line = (String)data.get(i);
            if (line.trim().equals("Maximal single base matches (low complexity regions):")) {
                start = i + 1;
            } else if (line.indexOf("matching entries") > -1) {
                end = i - 1;
                break;
            }
            ++i;
        }
        int skipped = 0;
        int i2 = start;
        while (i2 <= end) {
            String[] item = ((String)data.get(i2)).trim().split("\\s+");
            if (item.length >= 11 && "0123456789".indexOf(item[0].substring(0, 1)) > -1) {
                this.recordMatchData(item);
                boolean processed = this.recordDiscrepcyData(item[4], data, i2 + 1, end);
                if (processed) {
                    this.recordSnpData(item[4], data, i2 + 1, end);
                } else {
                    ++skipped;
                }
            }
            ++i2;
        }
        if (skipped * 4 > this.matched.keySet().size()) {
            this.log.add("<WARNING> This folder need manual attention!\n");
        }
    }

    public void recordSnpData(String chr, List data, int current, int end) {
        int i = current;
        while (i <= end) {
            int qual;
            String[] item = ((String)data.get(i)).trim().split("\\s+");
            if (item.length != 5) break;
            if (item[0].equals("S") && (qual = new Integer(item[2].substring(2, item[2].length() - 1)).intValue()) > this.config.getQualCutoff()) {
                Integer backbonePos = new Integer(item[3]);
                if (!this.rawPosDic.containsKey(backbonePos)) {
                    this.rawPosDic.put(backbonePos, new ArrayList());
                }
                ArrayList<Object> tempList = new ArrayList<Object>();
                tempList.add(chr);
                tempList.add(new Integer(item[1]));
                tempList.add(item[2].substring(0, 1));
                tempList.add(new Integer(qual));
                tempList.add(item[4]);
                tempList.add((String)this.matched.get(chr));
                ((List)this.rawPosDic.get(backbonePos)).add(tempList);
            }
            ++i;
        }
    }

    public boolean recordDiscrepcyData(String chr, List data, int current, int end) {
        Map diffMap;
        if (!this.matchedDetails.containsKey(chr)) {
            diffMap = new HashMap();
            diffMap.put("D", new HashMap());
            diffMap.put("I", new HashMap());
            diffMap.put("S", new HashMap());
            this.matchedDetails.put(chr, diffMap);
        } else {
            diffMap = (Map)this.matchedDetails.get(chr);
            diffMap.put("D", new HashMap());
            diffMap.put("I", new HashMap());
        }
        int diff = 0;
        int i = current;
        while (i <= end) {
            if (((String)data.get(i)).trim().split("\\s+").length != 5) break;
            ++diff;
            ++i;
        }
        if (diff < SnpConfig.MAX_DISCREPENCY) {
            int i2 = current;
            while (i2 <= end) {
                String[] item = ((String)data.get(i2)).trim().split("\\s+");
                if (item.length != 5) break;
                Integer backbonePos = new Integer(item[3]);
                Integer chrPos = new Integer(item[1]);
                if (item[0].equals("S")) {
                    ((Map)diffMap.get("S")).put(backbonePos, "1," + chrPos);
                } else if (item[0].substring(0, 1).equals("I")) {
                    if (item[0].equals("I")) {
                        ((Map)diffMap.get("I")).put(backbonePos, "1," + chrPos);
                    } else {
                        ((Map)diffMap.get("I")).put(backbonePos, String.valueOf(item[0].split("-")[1]) + "," + chrPos);
                    }
                } else if (item[0].substring(0, 1).equals("D")) {
                    if (item[0].equals("D")) {
                        ((Map)diffMap.get("D")).put(backbonePos, "1," + chrPos);
                    } else {
                        ((Map)diffMap.get("D")).put(backbonePos, String.valueOf(item[0].split("-")[1]) + "," + chrPos);
                    }
                } else {
                    System.out.println("exception entry in cross match log: " + item[0]);
                }
                ++i2;
            }
            return true;
        }
        this.snpPositionLog.add("Skipped parse cross match result for " + chr + " discrepency: " + diff + " \n");
        return false;
    }

    public void recordMatchData(String[] item) {
        Integer backboneEnd;
        Integer backboneStart;
        String direction;
        ArrayList<Integer> posList = new ArrayList<Integer>();
        Integer chrStart = new Integer(item[5]);
        Integer chrEnd = new Integer(item[6]);
        if (item[8].equals("C")) {
            direction = "R";
            if (item[item.length - 1].equals("*")) {
                backboneStart = new Integer(item[item.length - 3]);
                backboneEnd = new Integer(item[item.length - 2]);
            } else {
                backboneStart = new Integer(item[item.length - 2]);
                backboneEnd = new Integer(item[item.length - 1]);
            }
        } else {
            direction = "F";
            if (item[item.length - 1].equals("*")) {
                backboneStart = new Integer(item[item.length - 4]);
                backboneEnd = new Integer(item[item.length - 3]);
            } else {
                backboneStart = new Integer(item[item.length - 3]);
                backboneEnd = new Integer(item[item.length - 2]);
            }
        }
        posList.add(chrStart);
        posList.add(chrEnd);
        posList.add(backboneStart);
        posList.add(backboneEnd);
        String chr = item[4];
        this.matched.put(chr, direction);
        this.matchedPos.put(chr, posList);
    }
}

