/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import misc.CompareNote;
import misc.FileManager;

public class GroupCellLineBySnp {
    private static int VARIATION_LIMIT = 2;
    private static int GROUP_NUMBER = 4;
    private static int SNP_MIN_QUALITY = 30;

    public static void main(String[] args) throws Exception {
        File ampliconList = new File(args[0]);
        File snpOutputDir = new File(args[1]);
        File cellLineFile = new File(args[2]);
        CompareNote note = null;
        String[] amplicons = FileManager.readTextFile(ampliconList).split("\n");
        Map<String, List> majorSnpMap = GroupCellLineBySnp.getCommonSnpPositionList(amplicons, snpOutputDir);
        String[] cellLines = FileManager.readTextFile(cellLineFile).split("\n");
        String cellLine1 = cellLines[0];
        System.out.println(cellLine1);
        TreeSet<CompareNote> treeSet = new TreeSet<CompareNote>(new CompareNote("header", 0, 0));
        int i = 0;
        while (i < cellLines.length) {
            note = GroupCellLineBySnp.compareSnps(cellLine1, cellLines[i], majorSnpMap, snpOutputDir);
            treeSet.add(note);
            ++i;
        }
        for (CompareNote compareNote : treeSet) {
            System.out.println(String.valueOf(compareNote.getCellLine()) + "\t" + compareNote.getMatchCount() + "\t" + compareNote.getMismatchCount());
        }
    }

    private static CompareNote compareSnps(String cellLine1, String cellLine2, Map<String, List> majorSnpMap, File snpOutputDir) {
        CompareNote compareNote = new CompareNote(cellLine2, 0, 0);
        List posList = null;
        String[] data = null;
        String[] data1 = null;
        String[] data2 = null;
        int matchScore = 0;
        int misMatchScore = 0;
        String call1 = null;
        String call2 = null;
        for (String amplicon : majorSnpMap.keySet()) {
            posList = majorSnpMap.get(amplicon);
            data = FileManager.readTextFile(new File(snpOutputDir, String.valueOf(amplicon) + ".txt")).split("\n");
            data1 = GroupCellLineBySnp.getDataByCellLine(data, cellLine1);
            data2 = GroupCellLineBySnp.getDataByCellLine(data, cellLine2);
            if (data1 == null || data2 == null) {
                System.out.println("no cell line info " + cellLine1 + " or " + cellLine2 + " in " + amplicon);
                continue;
            }
            Iterator iterator = posList.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                call1 = data1[pos];
                call2 = data2[pos];
                char read1a = call1.charAt(0);
                char read2a = call2.charAt(0);
                if (read1a == 'N' || read1a == '?' || read2a == 'N' || read2a == '?') continue;
                char read1b = call1.indexOf("/") > 0 ? call1.charAt(2) : call1.charAt(0);
                char read2b = call2.indexOf("/") > 0 ? call2.charAt(2) : call2.charAt(0);
                if (read1a == read2a && read1b == read2b || read1a == read2b && read1b == read2a) {
                    matchScore += 2;
                    continue;
                }
                if (read1a != read2a && read1a != read2b && read1b != read2b && read1b != read2a) {
                    misMatchScore += 2;
                    continue;
                }
                ++matchScore;
                ++misMatchScore;
            }
        }
        compareNote.setMatchCount(matchScore);
        compareNote.setMismatchCount(misMatchScore);
        return compareNote;
    }

    private static String[] getDataByCellLine(String[] data, String cellLine) {
        String[] ret = null;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String info = stringArray[n2];
            ret = info.split("\\s+");
            if (ret[0].equals(cellLine)) {
                return ret;
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, List> getCommonSnpPositionList(String[] amplicons, File snpOutputDir) {
        File snpFile = null;
        String[] data = null;
        String[] header = null;
        Object snps = null;
        ArrayList<Integer> posList = null;
        int totalCount = 0;
        HashMap<String, List> majorSnpMap = new HashMap<String, List>();
        String[] stringArray = amplicons;
        int n = amplicons.length;
        int n2 = 0;
        while (n2 < n) {
            String amplicon = stringArray[n2];
            System.out.println(amplicon);
            snpFile = new File(snpOutputDir, String.valueOf(amplicon) + ".txt");
            data = FileManager.readTextFile(snpFile).split("\n");
            header = data[0].split("\\s+");
            if (header.length > 1 && data.length > 3) {
                posList = new ArrayList<Integer>();
                int i = 1;
                while (i < header.length) {
                    int quality = new Integer(header[i].split(":")[1]);
                    if (quality >= SNP_MIN_QUALITY && !GroupCellLineBySnp.isRareSnp(data, i)) {
                        posList.add(i);
                    }
                    ++i;
                }
                majorSnpMap.put(amplicon, posList);
                totalCount += posList.size();
            }
            ++n2;
        }
        System.out.println("total common snp " + totalCount);
        return majorSnpMap;
    }

    private static boolean isRareSnp(String[] data, int pos) {
        Object snps = null;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        String call = null;
        String read1 = null;
        String read2 = null;
        int i = 3;
        while (i < data.length) {
            call = data[i].split("\\s+")[pos].trim();
            if (call.indexOf("(") > 0) {
                call = call.split("\\(")[0];
            }
            if (!(read1 = String.valueOf(call.charAt(0))).equals("N") && !read1.equals("?")) {
                if (!countMap.containsKey(read1)) {
                    countMap.put(read1, 0);
                }
                countMap.put(read1, (Integer)countMap.get(read1) + 1);
                if (call.indexOf("/") > 0) {
                    read2 = String.valueOf(call.charAt(2));
                    if (!countMap.containsKey(read2)) {
                        countMap.put(read2, 0);
                    }
                    countMap.put(read2, (Integer)countMap.get(read2) + 1);
                }
            }
            ++i;
        }
        int maxCount = 0;
        String maxRead = null;
        for (String read : countMap.keySet()) {
            Integer count = (Integer)countMap.get(read);
            if (count <= maxCount) continue;
            maxCount = count;
            maxRead = read;
        }
        for (String read : countMap.keySet()) {
            if (read.equals(maxRead) || (Integer)countMap.get(read) < VARIATION_LIMIT) continue;
            return false;
        }
        System.out.println("rare snp " + pos);
        return true;
    }
}

